/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFCharacter;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.AdjacencyInfo;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.Wordafier;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.WordafierImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

class HorizontalAdjacencyInfo
extends AdjacencyInfo {
    private double fontSize;
    private double deltaYAbs;
    private static final double COS_30_DEGREES = 0.86602540378;

    HorizontalAdjacencyInfo(PDFCharacter currentChar, PDFCharacter nextChar, ArrayList<PDFCharacter> referenceList, Wordafier wordafier) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getHorizontalAdjacencyInfo(currentChar, nextChar, referenceList, wordafier, false);
    }

    public HorizontalAdjacencyInfo(PDFCharacter currentChar, PDFCharacter nextChar, ArrayList<PDFCharacter> referenceList, Wordafier wordafier, boolean checkSuperscriptsSubscripts) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getHorizontalAdjacencyInfo(currentChar, nextChar, referenceList, wordafier, true);
    }

    private void getHorizontalAdjacencyInfo(PDFCharacter currentChar, PDFCharacter nextChar, ArrayList<PDFCharacter> referenceList, Wordafier wordafier, boolean checkSuperscriptsSubscripts) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean nextCharIsAdjacent;
        HorizontalAdjacencyInfo adjacencyInfo = this;
        double X_ADJACENCY_FACTOR = 0.5;
        double Y_ADJACENCY_FACTOR = 0.2;
        WordafierImpl wordafierImpl = new WordafierImpl();
        double spaceWidth = 0.0;
        double fontSize = 0.0;
        double xThreshold = 0.0;
        double yThreshold = 0.0;
        if (currentChar.getTextRun() == nextChar.getTextRun()) {
            spaceWidth = wordafier.getSpaceCharWidth(currentChar);
            fontSize = currentChar.getVerticalFontSize();
        } else {
            double nextCharFontHeight;
            double currentCharFontHeight;
            int nextCharIdx = Collections.binarySearch(referenceList, nextChar, Wordafier.positionBasedHorizontalCharacterSorter);
            int curCharIdx = Collections.binarySearch(referenceList, currentChar, Wordafier.positionBasedHorizontalCharacterSorter);
            PDFCharacter spaceChar = null;
            if (nextCharIdx >= 0 && curCharIdx >= 0 && Math.abs(nextCharIdx - curCharIdx) == 2 && wordafierImpl.isWhitespace(spaceChar = referenceList.get((nextCharIdx + curCharIdx) / 2))) {
                spaceWidth = wordafier.getSpaceCharWidth(spaceChar);
            }
            if (spaceWidth == 0.0) {
                double nextCharSpaceWidth;
                double currentCharSpaceWidth = wordafier.getSpaceCharWidth(currentChar);
                spaceWidth = currentCharSpaceWidth < (nextCharSpaceWidth = wordafier.getSpaceCharWidth(nextChar)) ? currentCharSpaceWidth : nextCharSpaceWidth;
            }
            fontSize = (currentCharFontHeight = currentChar.getVerticalFontSize()) < (nextCharFontHeight = nextChar.getVerticalFontSize()) ? currentCharFontHeight : nextCharFontHeight;
        }
        double avgCharWidthInTextRun = this.getAvgCharWidthInTextRun(currentChar);
        if (currentChar.getTextRun() != nextChar.getTextRun()) {
            avgCharWidthInTextRun = Math.min(avgCharWidthInTextRun, this.getAvgCharWidthInTextRun(nextChar));
        }
        xThreshold = 0.5 * Math.min(avgCharWidthInTextRun, spaceWidth);
        yThreshold = 0.2 * fontSize;
        double deltaX = currentChar.getXDistanceTo(nextChar);
        double deltaY = currentChar.getYDistanceTo(nextChar);
        double deltaYAbs = Math.abs(deltaY);
        adjacencyInfo.setDeltaYAbs(deltaYAbs);
        adjacencyInfo.setFontSize(fontSize);
        adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.None);
        if (deltaX >= 0.0) {
            if (deltaX <= xThreshold) {
                adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Right);
            }
        } else if (Math.abs(deltaX) <= currentChar.getWidth()) {
            adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Right);
        } else if (Math.abs(deltaX) < currentChar.getWidth() + xThreshold) {
            adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Left);
        } else {
            deltaX = nextChar.getXDistanceTo(currentChar);
            if (deltaX > 0.0) {
                if (deltaX <= xThreshold) {
                    adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Left);
                }
            } else if (Math.abs(deltaX) <= nextChar.getWidth()) {
                adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Left);
            } else if (Math.abs(deltaX) <= nextChar.getWidth() + xThreshold) {
                adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Right);
            }
        }
        boolean hasYAdjacency = deltaYAbs <= yThreshold;
        boolean isSuperscriptOrSubscript = false;
        if (checkSuperscriptsSubscripts) {
            if (this.yOverlapExistsForHorizChars(currentChar, nextChar) && !this.xOverlapExistsForHorizChars(currentChar, nextChar) && this.superscriptFoundForHorizChars(currentChar, nextChar)) {
                isSuperscriptOrSubscript = true;
            }
            nextCharIsAdjacent = adjacencyInfo.getXAdjacency() != AdjacencyInfo.XAdjacency.None && (hasYAdjacency || isSuperscriptOrSubscript) && currentChar.getBaselineAngle() == nextChar.getBaselineAngle();
        } else {
            nextCharIsAdjacent = adjacencyInfo.getXAdjacency() != AdjacencyInfo.XAdjacency.None && hasYAdjacency;
        }
        adjacencyInfo.setAdjacent(nextCharIsAdjacent);
        if (currentChar.areCentersAlignedinYDir(nextChar)) {
            boolean nextCharIsAdjacent1;
            if (deltaY >= 0.0) {
                if (deltaY <= yThreshold) {
                    adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Bottom);
                }
            } else if (Math.abs(deltaY) <= Math.abs(currentChar.getSpaceCharHeight())) {
                adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Top);
            } else if (Math.abs(deltaY) < Math.abs(currentChar.getSpaceCharHeight() + yThreshold)) {
                adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Bottom);
            } else {
                deltaY = nextChar.getYDistanceTo(currentChar);
                if (deltaY > 0.0) {
                    if (deltaY <= yThreshold) {
                        adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Top);
                    }
                } else if (Math.abs(deltaY) <= Math.abs(currentChar.getSpaceCharHeight())) {
                    adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Top);
                } else if (Math.abs(deltaY) <= Math.abs(currentChar.getSpaceCharHeight()) + yThreshold) {
                    adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Bottom);
                }
            }
            isSuperscriptOrSubscript = false;
            if (checkSuperscriptsSubscripts) {
                if (this.xOverlapExistsForVertChars(currentChar, nextChar) && !this.yOverlapExistsForVertChars(currentChar, nextChar) && this.superscriptFoundForVertChars(currentChar, nextChar)) {
                    isSuperscriptOrSubscript = true;
                }
                nextCharIsAdjacent1 = (adjacencyInfo.getXAdjacency() != AdjacencyInfo.XAdjacency.None || isSuperscriptOrSubscript) && adjacencyInfo.getYAdjacency() != AdjacencyInfo.YAdjacency.None && Math.cos(currentChar.getBaselineAngle() - nextChar.getBaselineAngle()) > 0.86602540378;
            } else {
                nextCharIsAdjacent1 = adjacencyInfo.getXAdjacency() != AdjacencyInfo.XAdjacency.None && adjacencyInfo.getYAdjacency() != AdjacencyInfo.YAdjacency.None;
            }
            adjacencyInfo.setAdjacent(nextCharIsAdjacent1);
        }
    }

    private boolean superscriptFoundForVertChars(PDFCharacter currentChar, PDFCharacter nextChar) {
        return Math.min(currentChar.getAbsYDistanceTo(nextChar), nextChar.getAbsYDistanceTo(currentChar)) < Math.max(currentChar.getHorizontalFontSize(), nextChar.getHorizontalFontSize()) && currentChar.getVerticalFontSize() != nextChar.getVerticalFontSize() && currentChar.getBaselineAngle() == nextChar.getBaselineAngle();
    }

    private boolean yOverlapExistsForVertChars(PDFCharacter currentChar, PDFCharacter nextChar) {
        double currY1 = currentChar.getOrigin().y();
        double currY2 = currentChar.getEnd().y();
        double nextY1 = nextChar.getOrigin().y();
        double nextY2 = nextChar.getEnd().y();
        return !(Math.max(currY1, currY2) < Math.min(nextY1, nextY2)) && !(Math.max(nextY1, nextY2) < Math.min(currY1, currY2));
    }

    private boolean xOverlapExistsForVertChars(PDFCharacter currentChar, PDFCharacter nextChar) {
        double nextX;
        double currX = currentChar.getOrigin().x();
        return currX > (nextX = nextChar.getOrigin().x()) && nextX + nextChar.getVerticalFontSize() > currX || nextX > currX && currX + currentChar.getVerticalFontSize() > nextX;
    }

    private boolean superscriptFoundForHorizChars(PDFCharacter currentChar, PDFCharacter nextChar) {
        return Math.min(currentChar.getAbsXDistanceTo(nextChar), nextChar.getAbsXDistanceTo(currentChar)) < Math.max(currentChar.getHorizontalFontSize(), nextChar.getHorizontalFontSize()) && currentChar.getVerticalFontSize() != nextChar.getVerticalFontSize() && currentChar.getBaselineAngle() == 0.0 && nextChar.getBaselineAngle() == 0.0;
    }

    private boolean xOverlapExistsForHorizChars(PDFCharacter currentChar, PDFCharacter nextChar) {
        double currX1 = currentChar.getOrigin().x();
        double currX2 = currentChar.getEnd().x();
        double nextX1 = nextChar.getOrigin().x();
        double nextX2 = nextChar.getEnd().x();
        return !(Math.max(currX1, currX2) < Math.min(nextX1, nextX2)) && !(Math.max(nextX1, nextX2) < Math.min(currX1, currX2));
    }

    private boolean yOverlapExistsForHorizChars(PDFCharacter currentChar, PDFCharacter nextChar) {
        double nextY;
        double currY = currentChar.getOrigin().y();
        return currY > (nextY = nextChar.getOrigin().y()) && nextY + nextChar.getVerticalFontSize() > currY || nextY > currY && currY + currentChar.getVerticalFontSize() > nextY;
    }

    private double getAvgCharWidthInTextRun(PDFCharacter pdfChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfChar.getTextRun().getAvgCharWidth() != 0.0) {
            return pdfChar.getTextRun().getAvgCharWidth();
        }
        int nCharsInTextRun = pdfChar.getTextRun().getCharacters().size();
        Iterator<PDFCharacter> textRunCharsIter = pdfChar.getTextRun().getCharacters().iterator();
        double sumCharWidths = 0.0;
        while (textRunCharsIter.hasNext()) {
            PDFCharacter textRunChar = textRunCharsIter.next();
            sumCharWidths += textRunChar.getWidth();
        }
        pdfChar.getTextRun().setAvgCharWidth(sumCharWidths / (double)nCharsInTextRun);
        return pdfChar.getTextRun().getAvgCharWidth();
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setDeltaYAbs(double deltaYAbs) {
        this.deltaYAbs = deltaYAbs;
    }

    public double getDeltaYAbs() {
        return this.deltaYAbs;
    }
}

