/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.security;

import com.adobe.agl.text.Normalizer;
import com.adobe.agl.text.StringPrep;
import com.adobe.agl.text.StringPrepParseException;
import com.adobe.agl.text.UCharacterIterator;
import com.adobe.internal.pdftoolkit.services.security.UnicodePasswordUtil;
import java.io.IOException;
import java.io.InputStream;

public class UnicodePasswordUtilHelper {
    StringPrep stringPrep = null;

    public UnicodePasswordUtilHelper() {
        InputStream saslPrepStream = UnicodePasswordUtil.class.getClassLoader().getResourceAsStream("com/adobe/agl/impl/data/icudt40b/SaslPrepProfile_norm_bidi.spp");
        try {
            this.stringPrep = new StringPrep(saslPrepStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String saslPrep(String inPassword) {
        StringBuffer sb = null;
        if (this.stringPrep != null) {
            UCharacterIterator ucharIterator = UCharacterIterator.getInstance(inPassword);
            try {
                sb = this.stringPrep.prepare(ucharIterator, 1);
            }
            catch (StringPrepParseException stringPrepParseException) {
                // empty catch block
            }
        }
        if (sb != null) {
            return sb.toString();
        }
        return Normalizer.normalize(inPassword, Normalizer.NFKC);
    }
}

