/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.security;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProviderStandard;

public class StandardEncryptionPermissions {
    private Integer mPerms;
    private static final int ALLOW_SECURE = 2;
    private static final int ALLOW_PRINT_LOW = 4;
    private static final int ALLOW_MODIFY = 8;
    private static final int ALLOW_COPY = 16;
    private static final int ALLOW_ADD = 32;
    private static final int RESERVED7 = 64;
    private static final int RESERVED8 = 128;
    private static final int ALLOW_FILL = 256;
    private static final int ALLOW_EXTRACT = 512;
    private static final int ALLOW_ASSEMBLE = 1024;
    private static final int ALLOW_PRINT_HIGH = 2048;
    private static final int ALLOW_ALL = 3902;
    private static final int RESERVED13_32 = -4096;
    private static final int RESEREVED_MUST_BE_1 = -3904;

    private StandardEncryptionPermissions(Number perms) {
        this(perms.intValue());
    }

    private StandardEncryptionPermissions(int perms) {
        int filled = perms & 0xF3E;
        this.mPerms = filled | 0xFFFFF0C0;
    }

    public static StandardEncryptionPermissions newInstance(Number permissions) {
        return new StandardEncryptionPermissions(permissions);
    }

    public static StandardEncryptionPermissions newInstance(int permissions) {
        return new StandardEncryptionPermissions(permissions);
    }

    public static StandardEncryptionPermissions newInstance(PermissionProvider provider) throws PDFUnableToCompleteOperationException {
        if (provider == null) {
            return null;
        }
        PermissionProviderStandard encryptPermissions = PermissionProviderStandard.newInstance(provider);
        return StandardEncryptionPermissions.newInstance(encryptPermissions.getPermissionBits());
    }

    public static StandardEncryptionPermissions newInstanceAll() {
        return StandardEncryptionPermissions.newInstance(3902);
    }

    public static StandardEncryptionPermissions newInstanceNone() {
        return StandardEncryptionPermissions.newInstance(0);
    }

    public boolean mayPrintLow() {
        return (this.getPermissions() & 4) != 0;
    }

    public boolean maySecure() {
        return (this.getPermissions() & 2) != 0;
    }

    public boolean mayModify() {
        return (this.getPermissions() & 8) != 0;
    }

    public boolean mayCopy() {
        return (this.getPermissions() & 0x10) != 0;
    }

    public boolean mayAdd() {
        return (this.getPermissions() & 0x20) != 0;
    }

    public boolean mayFill() {
        return (this.getPermissions() & 0x100) != 0;
    }

    public boolean mayExtract() {
        return (this.getPermissions() & 0x200) != 0;
    }

    public boolean mayAssemble() {
        return (this.getPermissions() & 0x400) != 0;
    }

    public boolean mayPrintHigh() {
        return (this.getPermissions() & 0x800) != 0;
    }

    public boolean allowPrintLow(boolean how) {
        boolean oldFlag = this.mayPrintLow();
        this.setFlag(4, how);
        return oldFlag;
    }

    public boolean allowSecure(boolean how) {
        boolean oldFlag = this.mayPrintLow();
        this.setFlag(2, how);
        return oldFlag;
    }

    public boolean allowModify(boolean how) {
        boolean oldFlag = this.mayModify();
        this.setFlag(8, how);
        return oldFlag;
    }

    public boolean allowCopy(boolean how) {
        boolean oldFlag = this.mayCopy();
        this.setFlag(16, how);
        return oldFlag;
    }

    public boolean allowAdd(boolean how) {
        boolean oldFlag = this.mayAdd();
        this.setFlag(32, how);
        return oldFlag;
    }

    public boolean allowFill(boolean how) {
        boolean oldFlag = this.mayFill();
        this.setFlag(256, how);
        return oldFlag;
    }

    public boolean allowExtract(boolean how) {
        boolean oldFlag = this.mayExtract();
        this.setFlag(512, how);
        return oldFlag;
    }

    public boolean allowAssemble(boolean how) {
        boolean oldFlag = this.mayAssemble();
        this.setFlag(1024, how);
        return oldFlag;
    }

    public boolean allowPrintHigh(boolean how) {
        boolean oldFlag = this.mayPrintHigh();
        this.setFlag(2048, how);
        if (how) {
            this.setFlag(4, how);
        }
        return oldFlag;
    }

    public PermissionProvider getPermissionProvider() {
        return new PermissionProviderStandard(this.getPermissions());
    }

    public Integer getPermissions() {
        return this.mPerms;
    }

    private void setFlag(int flag, boolean how) {
        int flags = this.getPermissions();
        if (how) {
            flags |= flag;
        } else {
            int mask = 0xFFFFFFFF ^ flag;
            flags &= mask;
        }
        this.mPerms = flags;
    }
}

