/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.security;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityKeyPKIInterface;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityKeyPasswordInterface;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityLockPKIInterface;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityLockPasswordInterface;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

class SecurityLocation {
    private static final String SECURITY__IMPL_LOCATION = "com.adobe.internal.pdftoolkit.core.encryption.";
    private static final String SECURITY__KEY_PKI = "SecurityKeyPKIImpl";
    private static final String SECURITY__KEY_PASSWORD = "SecurityKeyPasswordImpl";
    private static final String SECURITY__LOCK_PKI = "SecurityLockPKIImpl";
    private static final String SECURITY__LOCK_PASSWORD = "SecurityLockPasswordImpl";
    private static final SecurityKeyPasswordInterface mSecurityKeyPasswordImpl = (SecurityKeyPasswordInterface)SecurityLocation.getSecurityKeyImpl("SecurityKeyPasswordImpl");
    private static final SecurityKeyPKIInterface mSecurityKeyPKIImpl = (SecurityKeyPKIInterface)SecurityLocation.getSecurityKeyImpl("SecurityKeyPKIImpl");
    private static final SecurityLockPasswordInterface mSecurityLockPasswordImpl = (SecurityLockPasswordInterface)SecurityLocation.getSecurityKeyImpl("SecurityLockPasswordImpl");
    private static final SecurityLockPKIInterface mSecurityLockPKIImpl = (SecurityLockPKIInterface)SecurityLocation.getSecurityKeyImpl("SecurityLockPKIImpl");

    private SecurityLocation() {
    }

    static SecurityKeyPasswordInterface getSecurityKeyPassword() {
        if (mSecurityKeyPasswordImpl == null) {
            throw new PDFUnsupportedFeatureException("Encryption is not supported");
        }
        return mSecurityKeyPasswordImpl;
    }

    static SecurityKeyPKIInterface getSecurityKeyPKI() {
        if (mSecurityKeyPKIImpl == null) {
            throw new PDFUnsupportedFeatureException("Encryption is not supported");
        }
        return mSecurityKeyPKIImpl;
    }

    static SecurityLockPKIInterface getSecurityLockPKI() {
        if (mSecurityLockPKIImpl == null) {
            throw new PDFUnsupportedFeatureException("Encryption is not supported");
        }
        return mSecurityLockPKIImpl;
    }

    static SecurityLockPasswordInterface getSecurityLockPassword() {
        if (mSecurityLockPasswordImpl == null) {
            throw new PDFUnsupportedFeatureException("Encryption is not supported");
        }
        return mSecurityLockPasswordImpl;
    }

    private static Object getSecurityKeyImpl(String implName) {
        Object askedImpl;
        String fullName = SECURITY__IMPL_LOCATION + implName;
        try {
            Class<?> askedClass = Class.forName(fullName);
            Constructor<?> askedConstructor = askedClass.getConstructor(new Class[0]);
            askedImpl = askedConstructor.newInstance(new Object[0]);
        }
        catch (Exception exp) {
            askedImpl = null;
        }
        return askedImpl;
    }

    static Map buildEncryptParams(int version, int length, int revision, String filter, String cryptFilter, boolean metaData, boolean aes, boolean docOpen) {
        HashMap<String, Object> encryptParams = new HashMap<String, Object>(6);
        boolean lengthInBytes = true;
        if (length < 0) {
            length = -length;
            lengthInBytes = false;
        }
        if (131102 <= revision) {
            lengthInBytes = false;
        }
        if (filter == null) {
            filter = ASName.k_Standard.asString(true);
        }
        encryptParams.put(ASName.k_Filter.asString(true), filter);
        encryptParams.put(ASName.k_V.asString(true), version);
        if (length > 0) {
            encryptParams.put(ASName.k_Length.asString(true), length);
        }
        encryptParams.put(ASName.k_R.asString(true), revision);
        if (version >= 4) {
            if (cryptFilter == null) {
                cryptFilter = "StdCF";
            }
            HashMap<String, Object> cfmDict = new HashMap<String, Object>(3);
            cfmDict.put(ASName.k_Type.asString(true), ASName.k_CryptFilter);
            String v2 = aes ? (length <= 128 && version == 4 ? ASName.k_AESV2.asString(true) : ASName.k_AESV3.asString(true)) : ASName.k_V2.asString(true);
            cfmDict.put(ASName.k_CFM.asString(true), v2);
            if (!docOpen) {
                cfmDict.put(ASName.k_AuthEvent.asString(true), ASName.k_EFOpen.asString(true));
            }
            if (length > 0) {
                if (lengthInBytes) {
                    length /= 8;
                }
                cfmDict.put(ASName.k_Length.asString(true), length);
            }
            HashMap<String, HashMap<String, Object>> cfDict = new HashMap<String, HashMap<String, Object>>(1);
            cfDict.put(cryptFilter, cfmDict);
            encryptParams.put(ASName.k_CF.asString(true), cfDict);
            encryptParams.put(ASName.k_StmF.asString(true), cryptFilter);
            encryptParams.put(ASName.k_StrF.asString(true), cryptFilter);
            if (!metaData) {
                cfmDict.put(ASName.k_EncryptMetadata.asString(true), metaData);
            }
            encryptParams.put(ASName.k_EncryptMetadata.asString(true), metaData);
        }
        return encryptParams;
    }
}

