/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCID;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureParentTree;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontListener;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionHandler;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionOptions;
import com.adobe.internal.pdftoolkit.services.redaction.impl.AnnotationRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ContentStreamRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.OCRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionAdditionalInfo;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionContentWriter;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionUtils;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionXObjectWriter;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ResourcesState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.XObjectsNumberWrapper;
import com.adobe.internal.pdftoolkit.services.textextraction.TextExtractor;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RedactionProcessor {
    private PDFDocument pdfDoc;
    private RedactionOptions redactionOptions;
    private RedactionHandler redactionHandler;
    private RedactionState redactionState;
    private AnnotationRedactor annotationRedactor;
    private Map<Integer, Set<GeneralPath>> quadPointsRedactionPaths = new LinkedHashMap<Integer, Set<GeneralPath>>();
    private OCRedactor ocRedactor;
    private Set<Integer> unredactedPageSet = new HashSet<Integer>();

    public RedactionProcessor(PDFDocument pdfDoc, RedactionOptions redactionOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        this.redactionState = new RedactionState();
        this.pdfDoc = pdfDoc;
        PDFFontListener fontListener = PDFFontListener.getFontListener(pdfDoc);
        if (fontListener == null) {
            throw new PDFUnableToCompleteOperationException("Font Listener seems to be disabled. Redaction can't proceed ahead");
        }
        fontListener.setIgnoreErrors(true);
        this.redactionOptions = redactionOptions;
        if (redactionOptions != null) {
            this.redactionHandler = redactionOptions.getRedactionHandler();
        }
        if (pdfDoc.requireCatalog().getOCProperties() != null) {
            this.ocRedactor = new OCRedactor(pdfDoc);
        }
    }

    public void redactDocument() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        this.annotationRedactor = new AnnotationRedactor(this.redactionState, this.pdfDoc, this.redactionHandler, this.ocRedactor);
        Iterator<PDFPage> pageIterator = this.pdfDoc.requirePages().iterator();
        boolean redactionAnnotationFound = false;
        while (pageIterator.hasNext()) {
            PDFPage currentPage = pageIterator.next();
            if (currentPage == null) continue;
            List<Shape> shapes = this.getRedactionShapes(currentPage);
            Area redactionArea = RedactionUtils.getTotalArea(shapes);
            int pageNumber = currentPage.getPageNumber();
            ResourcesState currentPageResourcesState = this.getResourceStateObjectForPage(currentPage);
            this.annotationRedactor.setPageResourcesState(currentPageResourcesState);
            this.annotationRedactor.setPageNumber(pageNumber);
            PDFAnnotationList redactionAnnotationList = this.annotationRedactor.redactAnnotations(currentPage.getAnnotationList(), redactionArea);
            if (!shapes.isEmpty()) {
                redactionAnnotationFound = true;
                ASMatrix currCTM = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
                RedactionContentWriter writer = RedactionContentWriter.newInstance(currentPage.getPDFDocument(), currentPageResourcesState, currentPageResourcesState, this.redactionState, pageNumber, this.ocRedactor);
                if (currentPage.getContents() != null && currentPage.getContents().hasContents()) {
                    ContentStreamRedactor csr = new ContentStreamRedactor(this.pdfDoc, redactionArea, currentPageResourcesState, this.redactionOptions, this.redactionHandler, this.redactionState, pageNumber, this.ocRedactor);
                    RedactionAdditionalInfo additionalInfo = new RedactionAdditionalInfo();
                    LinkedHashMap<PDFXObjectForm, Map<ASMatrix, ASRectangle>> xObjsToInitialMatricesMap = new LinkedHashMap<PDFXObjectForm, Map<ASMatrix, ASRectangle>>();
                    csr.redactContentStream(Content.newInstance(currentPage), writer, currCTM, null, additionalInfo, xObjsToInitialMatricesMap, new XObjectsNumberWrapper());
                    RedactionXObjectWriter.removeRedactionAnnotations(this.pdfDoc, writer, this.quadPointsRedactionPaths, pageNumber, this.redactionOptions, redactionAnnotationList, xObjsToInitialMatricesMap);
                    InputByteStream ibs = writer.close().getContentStream();
                    try {
                        PDFContents contents = null;
                        if (ibs.bytesAvailable() > 0L) {
                            contents = this.getNewContents(ibs);
                        }
                        currentPage.setContents(contents);
                    }
                    catch (IOException e) {
                        throw new PDFIOException(e);
                    }
                    currentPageResourcesState.cleanResources(additionalInfo);
                    continue;
                }
                RedactionXObjectWriter.removeRedactionAnnotations(this.pdfDoc, writer, this.quadPointsRedactionPaths, pageNumber, this.redactionOptions, redactionAnnotationList, null);
                PDFContents contents = this.getNewContents(writer.close().getContentStream());
                currentPage.setContents(contents);
                currentPageResourcesState.cleanResources(null);
                continue;
            }
            this.unredactedPageSet.add(pageNumber);
        }
        if (redactionAnnotationFound) {
            this.cleanResources(this.unredactedPageSet);
        }
    }

    private PDFContents getNewContents(InputByteStream ibs) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        try {
            PDFContents contents = PDFContents.newInstance(this.pdfDoc);
            PDFFilterFlate filter = PDFFilterFlate.newInstance(this.pdfDoc, null);
            PDFFilterList filterList = PDFFilterList.newInstance(this.pdfDoc);
            filterList.add(filter);
            contents.setOutputFiltersList(filterList.getCosArray());
            contents.setContents(ibs);
            return contents;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private ResourcesState getResourceStateObjectForPage(PDFPage currentPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources currentPageResources = currentPage.getResources();
        PDFResources clonedResourcesForCurrentpage = null;
        ResourcesState currentPageResourcesState = null;
        if (currentPageResources != null) {
            clonedResourcesForCurrentpage = RedactionUtils.cloneResources(currentPageResources);
            currentPageResourcesState = new ResourcesState(clonedResourcesForCurrentpage, this.redactionHandler, currentPage.getPageNumber());
            currentPage.setResources(clonedResourcesForCurrentpage);
        }
        return currentPageResourcesState;
    }

    private List<Shape> getRedactionShapes(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Shape> redactionRegionShapes = new ArrayList<Shape>();
        PDFAnnotationIterator annotationIterator = page.getAnnotationsIterator();
        while (annotationIterator.hasNext()) {
            PDFAnnotationRedaction currentRedactionAnnotation;
            PDFRectangle locationRectangle;
            PDFAnnotation currentAnnotation = annotationIterator.next();
            if (!(currentAnnotation instanceof PDFAnnotationRedaction) || (locationRectangle = (currentRedactionAnnotation = (PDFAnnotationRedaction)currentAnnotation).getRect()) == null) continue;
            double[] redactionQuads = currentRedactionAnnotation.getQuadPoints();
            if (redactionQuads != null && redactionQuads.length >= 8) {
                LinkedHashSet<GeneralPath> paths = new LinkedHashSet<GeneralPath>();
                int numOfQuads = redactionQuads.length / 8;
                for (int i = 0; i < numOfQuads; ++i) {
                    GeneralPath redactionQuadPath = new GeneralPath();
                    redactionQuadPath.moveTo((float)redactionQuads[i * 8], (float)redactionQuads[i * 8 + 1]);
                    redactionQuadPath.lineTo((float)redactionQuads[i * 8 + 2], (float)redactionQuads[i * 8 + 2 + 1]);
                    redactionQuadPath.lineTo((float)redactionQuads[i * 8 + 6], (float)redactionQuads[i * 8 + 6 + 1]);
                    redactionQuadPath.lineTo((float)redactionQuads[i * 8 + 4], (float)redactionQuads[i * 8 + 4 + 1]);
                    redactionQuadPath.closePath();
                    paths.add(redactionQuadPath);
                    redactionRegionShapes.add(redactionQuadPath);
                }
                this.quadPointsRedactionPaths.put(currentAnnotation.getCosObject().getObjNum(), paths);
                continue;
            }
            locationRectangle = locationRectangle.normalized(page.getPDFDocument());
            Rectangle2D.Double redactionRectangle = new Rectangle2D.Double(locationRectangle.left(), locationRectangle.bottom(), locationRectangle.width(), locationRectangle.height());
            redactionRegionShapes.add(redactionRectangle);
        }
        return redactionRegionShapes;
    }

    private void cleanResources(Set<Integer> pagesSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        for (int pageNum : pagesSet) {
            PDFPage currentPage = this.pdfDoc.requirePages().getPage(pageNum);
            ResourcesState pageResourceState = new ResourcesState(currentPage.getResources(), null, pageNum);
            RedactionUtils.parseForResourcesInfo(Content.newInstance(currentPage), pageResourceState, pageResourceState, null, false, pageNum, null, null, true);
        }
        this.annotationRedactor.cleanAnnotationResources();
        this.cleanStructParent();
        if (this.ocRedactor != null) {
            this.ocRedactor.cleanOC(pagesSet);
        }
    }

    private void cleanStructParent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureParentTree parentTree;
        PDFStructureRoot structureRoot;
        Map<Integer, Set<Integer>> structParentMap = this.redactionState.getStructParent();
        PDFCatalog catalog = this.pdfDoc.requireCatalog();
        if (catalog != null && (structureRoot = catalog.getStructureRoot()) != null && !structureRoot.isEmpty() && (parentTree = structureRoot.getParentTree()) != null && !parentTree.isEmpty()) {
            Iterator<PDFTree.Entry> iterator = parentTree.iterator();
            while (iterator.hasNext()) {
                PDFStructureContentArray contentArray;
                Integer key;
                PDFTree.Entry entry = iterator.next();
                Object entryKey = entry.getKey();
                if (!(entryKey instanceof Integer) || this.unredactedPageSet.contains(key = (Integer)entryKey)) continue;
                Set<Integer> structParentSet = structParentMap.get(key);
                if (structParentSet == null) {
                    iterator.remove();
                    continue;
                }
                Object object = entry.getValue();
                if (!(object instanceof PDFStructureContentArray) || (contentArray = (PDFStructureContentArray)object) == null || contentArray.isEmpty()) continue;
                for (PDFStructureContentInterface contentInterface : contentArray) {
                    PDFStructureElement structureElement;
                    if (!(contentInterface instanceof PDFStructureElement) || !(structureElement = (PDFStructureElement)contentInterface).getStructureType().equals(PDFStructureType.Element)) continue;
                    PDFStructureContentInterface structureContentInterface = structureElement.getContent();
                    Integer spValue = null;
                    if (structureContentInterface instanceof PDFStructureMCID) {
                        PDFStructureMCID structureMCID = (PDFStructureMCID)structureContentInterface;
                        spValue = structureMCID.getMCID();
                    }
                    if (structParentSet.contains(spValue)) continue;
                    structureElement.removeKids();
                }
            }
        }
    }

    public static double[] adjustBoundingBox(PDFPage currPage, TextExtractor textExtractor, Set<String> wordsToRemove, RedactionOptions options, boolean ignoreCase) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        return RedactionUtils.adjustBoundingBox(currPage, textExtractor, wordsToRemove, options, ignoreCase);
    }
}

