/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.graphicsDOM.AbstractContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.XObject;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterBlendingComposite;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentImageItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTextState;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.Iterator;

public class RasterXobject
extends XObject<RasterGraphicsState, RasterTextState, RasterContentItem> {
    public RasterXobject(RasterGraphicsState gState, int id) {
        super(gState, id);
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        super.writeToDisplayArea(context);
        RasterDocumentContext rasterDocumentContext = (RasterDocumentContext)context;
        if (((RasterGraphicsState)this.getGState()).getNonStrokeAlpha() != 0.0 && (this.getIsIsolatedGroup() || this.getIsKnockoutGroup())) {
            rasterDocumentContext.setNonStrokeAlpha(((RasterGraphicsState)this.getGState()).getNonStrokeAlpha());
        }
        if (!this.isGroupXobject()) {
            this.writeToDisplayAreaForXobject(rasterDocumentContext, rasterDocumentContext.getGraphics2d());
            return;
        }
        this.processTransparencyGroupXobject(rasterDocumentContext);
    }

    public static void applyMask1(BufferedImage tempBackground, BufferedImage xObjectForm, RasterDocumentContext rasterDocumentContext) {
        int[] pixels = ((DataBufferInt)tempBackground.getRaster().getDataBuffer()).getData();
        int[] smaskPixels = ((DataBufferInt)xObjectForm.getRaster().getDataBuffer()).getData();
        int height = rasterDocumentContext.getPageHeight();
        int width = rasterDocumentContext.getWidth();
        for (int index = 0; index < height * width; ++index) {
            pixels[index] = smaskPixels[index] & 0xFF000000 | pixels[index] & 0xFFFFFF;
        }
    }

    public static void applyMask(BufferedImage tempBackground, BufferedImage xObjectForm, RasterDocumentContext rasterDocumentContext) {
        int[] pixels = ((DataBufferInt)tempBackground.getRaster().getDataBuffer()).getData();
        int[] smaskPixels = ((DataBufferInt)xObjectForm.getRaster().getDataBuffer()).getData();
        int height = rasterDocumentContext.getPageHeight();
        int width = rasterDocumentContext.getWidth();
        for (int index = 0; index < height * width; ++index) {
            int red = RasterXobject.adjustRange(pixels[index] >> 16 & 0xFF);
            int green = RasterXobject.adjustRange(pixels[index] >> 8 & 0xFF);
            int blue = RasterXobject.adjustRange(pixels[index] & 0xFF);
            pixels[index] = smaskPixels[index] << 24 | red << 16 | green << 8 | blue;
        }
    }

    private static int adjustRange(int color) {
        if (color < 0) {
            color += 255;
        }
        return color;
    }

    private void processTransparencyGroupXobject(RasterDocumentContext rasterDocumentContext) {
        Graphics2D oldGraphics2d = rasterDocumentContext.getGraphics2d();
        BufferedImage oldImage = rasterDocumentContext.getImage();
        GraphicsState.BlendingMode mode = ((RasterGraphicsState)this.getGState()).getBlendingMode();
        Area backdropArea = ((RasterGraphicsState)this.getGState()).getBackDropArea();
        BufferedImage newImage = null;
        Graphics2D newGraphics2D = null;
        BufferedImage newImageForXobject = null;
        Graphics2D newGraphics2DForXobject = null;
        if (this.getIsIsolatedGroup()) {
            newImage = new BufferedImage(rasterDocumentContext.getImage().getWidth(), rasterDocumentContext.getImage().getHeight(), 2);
            newGraphics2D = newImage.createGraphics();
        } else {
            newImage = RasterXobject.deepCopy(oldImage);
            newGraphics2D = newImage.createGraphics();
            newImageForXobject = new BufferedImage(rasterDocumentContext.getImage().getWidth(), rasterDocumentContext.getImage().getHeight(), 2);
            newGraphics2DForXobject = newImageForXobject.createGraphics();
        }
        rasterDocumentContext.setGraphics2d(newGraphics2D);
        rasterDocumentContext.setImage(newImage);
        rasterDocumentContext.setGraphics2dForXobject(newGraphics2DForXobject);
        rasterDocumentContext.setImageForXobject(newImageForXobject);
        ContentItemsList ciList = this.getContentItems();
        if (ciList != null) {
            Iterator itr = ciList.iterator();
            while (itr.hasNext()) {
                AbstractContentItem ci = (AbstractContentItem)itr.next();
                if (backdropArea != null) {
                    ((RasterGraphicsState)ci.getGState()).setBackDropArea(backdropArea);
                }
                GraphicsState.BlendingMode bm = null;
                if (this.isGroupXobject() && this.getIsKnockoutGroup() && this.getIsIsolatedGroup()) {
                    bm = ((GraphicsState)ci.getGState()).getBlendingMode();
                    ((GraphicsState)ci.getGState()).setBlendingMode(GraphicsState.BlendingMode.NORMAL);
                }
                ci.writeToDisplayArea(rasterDocumentContext);
                if (this.isGroupXobject() && this.getIsKnockoutGroup() && this.getIsIsolatedGroup()) {
                    ((GraphicsState)ci.getGState()).setBlendingMode(bm);
                }
                if (newGraphics2DForXobject == null || rasterDocumentContext.getImageForXobject() == null) continue;
                newGraphics2DForXobject.setComposite(AlphaComposite.SrcOver);
                newGraphics2DForXobject.drawImage(rasterDocumentContext.getImageForXobject(), null, 0, 0);
                rasterDocumentContext.setGraphics2dForXobject(newGraphics2DForXobject);
                rasterDocumentContext.setImageForXobject(newImageForXobject);
            }
        }
        Composite origComp = oldGraphics2d.getComposite();
        oldGraphics2d.setComposite(new RasterBlendingComposite(mode, (float)((RasterGraphicsState)this.getGState()).getNonStrokeAlpha()));
        if (!this.getIsIsolatedGroup()) {
            RasterXobject.applyMask1(newImage, newImageForXobject, rasterDocumentContext);
        } else {
            rasterDocumentContext.setImageForXobject(newImage);
        }
        this.processSoftMask(rasterDocumentContext);
        oldGraphics2d.drawImage(newImage, null, 0, 0);
        oldGraphics2d.setComposite(origComp);
        rasterDocumentContext.setGraphics2d(oldGraphics2d);
        rasterDocumentContext.setImage(oldImage);
    }

    private void writeToDisplayAreaForXobject(RasterDocumentContext rasterDocumentContext, Graphics2D newGraphics2D) {
        Area backdropArea = ((RasterGraphicsState)this.getGState()).getBackDropArea();
        ContentItemsList ciList = this.getContentItems();
        if (ciList != null) {
            Iterator itr = ciList.iterator();
            while (itr.hasNext()) {
                AbstractContentItem ci = (AbstractContentItem)itr.next();
                if (backdropArea != null) {
                    ((RasterGraphicsState)ci.getGState()).setBackDropArea(backdropArea);
                }
                if (((RasterGraphicsState)this.getGState()).getGraphicsStateSoftMask() != null) {
                    ((RasterGraphicsState)ci.getGState()).setGraphicsStateSoftMask(((RasterGraphicsState)this.getGState()).getGraphicsStateSoftMask());
                    ((RasterGraphicsState)ci.getGState()).setCachedSoftMask(((RasterGraphicsState)this.getGState()).getCachedSoftMask());
                }
                ContentItem oldSMask = ((RasterGraphicsState)this.getGState()).getGraphicsStateSoftMask();
                ((RasterGraphicsState)this.getGState()).setCachedSoftMask(null);
                ((RasterGraphicsState)this.getGState()).setGraphicsStateSoftMask(null);
                ci.writeToDisplayArea(rasterDocumentContext);
                ((RasterGraphicsState)this.getGState()).setCachedSoftMask(oldSMask);
                ((RasterGraphicsState)this.getGState()).setGraphicsStateSoftMask(oldSMask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSoftMask(RasterDocumentContext rasterDocumentContext) {
        RasterXobject sMask = (RasterXobject)((RasterGraphicsState)this.getGState()).getGraphicsStateSoftMask();
        if (sMask == null) {
            return;
        }
        BufferedImage xObjectForm = new BufferedImage(rasterDocumentContext.getImage().getWidth(), rasterDocumentContext.getImage().getHeight(), 2);
        BufferedImage oldImage = rasterDocumentContext.getImage();
        Graphics2D oldGraphics2d = rasterDocumentContext.getGraphics2d();
        ((RasterGraphicsState)this.getGState()).setGraphicsStateSoftMask(null);
        ((RasterGraphicsState)this.getGState()).setCachedSoftMask(null);
        BufferedImage newImageForXobject1 = null;
        Graphics2D newGraphics2DForXobject1 = null;
        try {
            Graphics2D maskGraphics2d = xObjectForm.createGraphics();
            rasterDocumentContext.setGraphics2d(maskGraphics2d);
            rasterDocumentContext.setImage(xObjectForm);
            rasterDocumentContext.setIsGSSoftMask(true);
            ContentItemsList sMaskCIList = sMask.getContentItems();
            Iterator ciListIter = sMaskCIList.iterator();
            while (ciListIter.hasNext()) {
                Object ciObject = ciListIter.next();
                if (!(ciObject instanceof RasterContentImageItem)) continue;
                RasterContentImageItem imageItem = (RasterContentImageItem)ciObject;
                imageItem.setIsSoftMaskImage(true);
            }
            newImageForXobject1 = rasterDocumentContext.getImageForXobject();
            newGraphics2DForXobject1 = rasterDocumentContext.getGraphics2dForXobject();
            rasterDocumentContext.setGraphics2dForXobject(null);
            rasterDocumentContext.setImageForXobject(null);
            GraphicsUtils.writeToDisplayAreaForSoftMask(sMask, rasterDocumentContext);
            rasterDocumentContext.setGraphics2dForXobject(newGraphics2DForXobject1);
            rasterDocumentContext.setImageForXobject(newImageForXobject1);
            rasterDocumentContext.setIsGSSoftMask(false);
            rasterDocumentContext.setGraphics2d(oldGraphics2d);
            rasterDocumentContext.setImage(oldImage);
        }
        catch (Throwable throwable) {
            rasterDocumentContext.setGraphics2dForXobject(newGraphics2DForXobject1);
            rasterDocumentContext.setImageForXobject(newImageForXobject1);
            rasterDocumentContext.setIsGSSoftMask(false);
            rasterDocumentContext.setGraphics2d(oldGraphics2d);
            rasterDocumentContext.setImage(oldImage);
            throw throwable;
        }
        RasterXobject.applyMask(oldImage, xObjectForm, rasterDocumentContext);
    }

    static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    @Override
    public double getDisplayRotation() {
        return 0.0;
    }

    @Override
    public void setDisplayRotation(double rotation) {
    }
}

