/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterBlendingComposite;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterUtils;

abstract class RasterBlendingMixture {
    private static final double weight = 0.95;
    private static final int[] DodgeDelta = new int[]{0, 3, 6, 9, 11, 14, 16, 19, 21, 23, 26, 28, 30, 32, 33, 35, 37, 39, 40, 42, 43, 45, 46, 47, 48, 49, 51, 52, 53, 53, 54, 55, 56, 57, 57, 58, 58, 59, 60, 60, 60, 61, 61, 62, 62, 62, 62, 63, 63, 63, 63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 62, 62, 62, 62, 62, 62, 62, 61, 61, 61, 61, 61, 61, 60, 60, 60, 60, 60, 59, 59, 59, 59, 59, 58, 58, 58, 58, 57, 57, 57, 57, 56, 56, 56, 56, 55, 55, 55, 55, 54, 54, 54, 54, 53, 53, 53, 52, 52, 52, 51, 51, 51, 51, 50, 50, 50, 49, 49, 49, 48, 48, 48, 47, 47, 47, 46, 46, 46, 45, 45, 45, 44, 44, 43, 43, 43, 42, 42, 42, 41, 41, 40, 40, 40, 39, 39, 39, 38, 38, 37, 37, 37, 36, 36, 35, 35, 35, 34, 34, 33, 33, 33, 32, 32, 31, 31, 31, 30, 30, 29, 29, 28, 28, 28, 27, 27, 26, 26, 25, 25, 25, 24, 24, 23, 23, 22, 22, 21, 21, 21, 20, 20, 19, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 13, 13, 12, 12, 11, 11, 10, 10, 9, 9, 8, 8, 7, 7, 6, 6, 5, 5, 4, 4, 3, 3, 2, 2, 1, 1, 0, 0};

    RasterBlendingMixture() {
    }

    abstract void blend(int[] var1, int[] var2, int[] var3);

    static RasterBlendingMixture getMixture(RasterBlendingComposite composite) {
        switch (composite.getMode()) {
            case NORMAL: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        result[0] = src[0];
                        result[1] = src[1];
                        result[2] = src[2];
                        result[3] = src[3];
                    }
                };
            }
            case MULTIPLY: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        result[0] = src[0] * dst[0] >> 8;
                        result[1] = src[1] * dst[1] >> 8;
                        result[2] = src[2] * dst[2] >> 8;
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case SCREEN: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        result[0] = 255 - ((255 - src[0]) * (255 - dst[0]) >> 8);
                        result[1] = 255 - ((255 - src[1]) * (255 - dst[1]) >> 8);
                        result[2] = 255 - ((255 - src[2]) * (255 - dst[2]) >> 8);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case DARKEN: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        result[0] = Math.min(src[0], dst[0]);
                        result[1] = Math.min(src[1], dst[1]);
                        result[2] = Math.min(src[2], dst[2]);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case LIGHTEN: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        result[0] = Math.max(src[0], dst[0]);
                        result[1] = Math.max(src[1], dst[1]);
                        result[2] = Math.max(src[2], dst[2]);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case DIFFERENCE: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        result[0] = Math.abs(dst[0] - src[0]);
                        result[1] = Math.abs(dst[1] - src[1]);
                        result[2] = Math.abs(dst[2] - src[2]);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case EXCLUSION: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        result[0] = dst[0] + src[0] - (dst[0] * src[0] >> 7);
                        result[1] = dst[1] + src[1] - (dst[1] * src[1] >> 7);
                        result[2] = dst[2] + src[2] - (dst[2] * src[2] >> 7);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case COLORDODGE: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        result[0] = src[0] == 255 ? 255 : Math.min(Math.round((dst[0] << 8) / (255 - src[0])), 255);
                        result[1] = src[1] == 255 ? 255 : Math.min(Math.round((dst[1] << 8) / (255 - src[1])), 255);
                        result[2] = src[2] == 255 ? 255 : Math.min(Math.round((dst[2] << 8) / (255 - src[2])), 255);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case COLORBURN: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        result[0] = src[0] == 0 ? 0 : Math.max(0, 255 - Math.round((255 - dst[0] << 8) / src[0]));
                        result[1] = src[1] == 0 ? 0 : Math.max(0, 255 - Math.round((255 - dst[1] << 8) / src[1]));
                        result[2] = src[2] == 0 ? 0 : Math.max(0, 255 - Math.round((255 - dst[2] << 8) / src[2]));
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case HARDLIGHT: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        result[0] = src[0] < 128 ? dst[0] * src[0] >> 7 : 255 - ((255 - src[0]) * (255 - dst[0]) >> 7);
                        result[1] = src[1] < 128 ? dst[1] * src[1] >> 7 : 255 - ((255 - src[1]) * (255 - dst[1]) >> 7);
                        result[2] = src[2] < 128 ? dst[2] * src[2] >> 7 : 255 - ((255 - src[2]) * (255 - dst[2]) >> 7);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case SOFTLIGHT: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        result[0] = (int)(src[0] < 128 ? (2.0 * (double)src[0] * (double)(255 - dst[0]) + 255.0 * (double)dst[0]) * (double)dst[0] / 65025.0 : (double)dst[0] + ((double)src[0] * 2.0 - 255.0) * (double)DodgeDelta[dst[0]] / 255.0);
                        result[1] = (int)(src[1] < 128 ? (2.0 * (double)src[1] * (double)(255 - dst[1]) + 255.0 * (double)dst[1]) * (double)dst[1] / 65025.0 : (double)dst[1] + ((double)src[1] * 2.0 - 255.0) * (double)DodgeDelta[dst[1]] / 255.0);
                        result[2] = (int)(src[2] < 128 ? (2.0 * (double)src[2] * (double)(255 - dst[2]) + 255.0 * (double)dst[2]) * (double)dst[2] / 65025.0 : (double)dst[2] + ((double)src[2] * 2.0 - 255.0) * (double)DodgeDelta[dst[2]] / 255.0);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case OVERLAY: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] dst, int[] src, int[] result) {
                        if (dst[3] == 0) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        if (src[0] == 255 && src[1] == 255 && src[2] == 255 && src[3] == 255) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        result[0] = dst[0] < 128 ? (src[0] * dst[0] << 1) / 255 : (src[0] + dst[0] << 1) - (src[0] * dst[0] << 1) / 255 - 255;
                        result[1] = dst[1] < 128 ? (src[1] * dst[1] << 1) / 255 : (src[1] + dst[1] << 1) - (src[1] * dst[1] << 1) / 255 - 255;
                        result[2] = dst[2] < 128 ? (src[2] * dst[2] << 1) / 255 : (src[2] + dst[2] << 1) - (src[2] * dst[2] << 1) / 255 - 255;
                        result[3] = dst[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case LUMINOSITY: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        double srcRed = src[0];
                        double srcGreen = src[1];
                        double srcBlue = src[2];
                        double dstRed = dst[0];
                        double dstGreen = dst[1];
                        double dstBlue = dst[2];
                        double dstLum = RasterUtils.RGBToLuminance(dstRed, dstGreen, dstBlue);
                        double srcLum = RasterUtils.RGBToLuminance(srcRed, srcGreen, srcBlue);
                        double[] clipedColor = RasterUtils.ClipColor(dstRed += srcLum - dstLum, dstGreen += srcLum - dstLum, dstBlue += srcLum - dstLum, srcLum);
                        result[0] = (int)Math.round(clipedColor[0]);
                        result[1] = (int)Math.round(clipedColor[1]);
                        result[2] = (int)Math.round(clipedColor[2]);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case COLOR: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        double srcRed = src[0];
                        double srcGreen = src[1];
                        double srcBlue = src[2];
                        double dstRed = dst[0];
                        double dstGreen = dst[1];
                        double dstBlue = dst[2];
                        double dstLum = RasterUtils.RGBToLuminance(dstRed, dstGreen, dstBlue);
                        double srcLum = RasterUtils.RGBToLuminance(srcRed, srcGreen, srcBlue);
                        dstRed = srcRed + dstLum - srcLum;
                        dstGreen = srcGreen + dstLum - srcLum;
                        dstBlue = srcBlue + dstLum - srcLum;
                        double[] clipedColor = RasterUtils.ClipColor(dstRed, dstGreen, dstBlue, dstLum);
                        result[0] = (int)Math.round(clipedColor[0]);
                        result[1] = (int)Math.round(clipedColor[1]);
                        result[2] = (int)Math.round(clipedColor[2]);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case SATURATION: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        if (src[3] == 255) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        double srcRed = src[0];
                        double srcGreen = src[1];
                        double srcBlue = src[2];
                        double dstRed = dst[0];
                        double dstGreen = dst[1];
                        double dstBlue = dst[2];
                        double dstLum = RasterUtils.RGBToLuminance(dstRed, dstGreen, dstBlue);
                        double gap = Math.max(Math.max(srcRed, srcGreen), srcBlue) - Math.min(Math.min(srcRed, srcGreen), srcBlue);
                        double[] dstColor = new double[]{dstRed, dstGreen, dstBlue};
                        dstColor = dstRed > dstGreen ? (dstGreen > dstBlue ? RasterUtils.SetGap(dstColor, gap, 0, 1, 2) : (dstRed > dstBlue ? RasterUtils.SetGap(dstColor, gap, 0, 2, 1) : RasterUtils.SetGap(dstColor, gap, 2, 0, 1))) : (dstRed > dstBlue ? RasterUtils.SetGap(dstColor, gap, 1, 0, 2) : (dstGreen > dstBlue ? RasterUtils.SetGap(dstColor, gap, 1, 2, 0) : RasterUtils.SetGap(dstColor, gap, 2, 1, 0)));
                        dstRed = dstColor[0];
                        dstGreen = dstColor[1];
                        dstBlue = dstColor[2];
                        double gapLum = RasterUtils.RGBToLuminance(dstRed, dstGreen, dstBlue);
                        double[] clipedColor = RasterUtils.ClipColor(dstRed += dstLum - gapLum, dstGreen += dstLum - gapLum, dstBlue += dstLum - gapLum, dstLum);
                        result[0] = (int)Math.round(clipedColor[0]);
                        result[1] = (int)Math.round(clipedColor[1]);
                        result[2] = (int)Math.round(clipedColor[2]);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case HUE: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        if (src[3] == 0) {
                            result[0] = dst[0];
                            result[1] = dst[1];
                            result[2] = dst[2];
                            result[3] = dst[3];
                            return;
                        }
                        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
                            result[0] = src[0];
                            result[1] = src[1];
                            result[2] = src[2];
                            result[3] = src[3];
                            return;
                        }
                        double srcRed = src[0];
                        double srcGreen = src[1];
                        double srcBlue = src[2];
                        double dstRed = dst[0];
                        double dstGreen = dst[1];
                        double dstBlue = dst[2];
                        double dstLum = RasterUtils.RGBToLuminance(dstRed, dstGreen, dstBlue);
                        double gap = Math.max(Math.max(dstRed, dstGreen), dstBlue) - Math.min(Math.min(dstRed, dstGreen), dstBlue);
                        dstRed = srcRed;
                        dstGreen = srcGreen;
                        dstBlue = srcBlue;
                        double[] dstColor = new double[]{dstRed, dstGreen, dstBlue};
                        dstColor = dstRed > dstGreen ? (dstGreen > dstBlue ? RasterUtils.SetGap(dstColor, gap, 0, 1, 2) : (dstRed > dstBlue ? RasterUtils.SetGap(dstColor, gap, 0, 2, 1) : RasterUtils.SetGap(dstColor, gap, 2, 0, 1))) : (dstRed > dstBlue ? RasterUtils.SetGap(dstColor, gap, 1, 0, 2) : (dstGreen > dstBlue ? RasterUtils.SetGap(dstColor, gap, 1, 2, 0) : RasterUtils.SetGap(dstColor, gap, 2, 1, 0)));
                        dstRed = dstColor[0];
                        dstGreen = dstColor[1];
                        dstBlue = dstColor[2];
                        double srcLum = RasterUtils.RGBToLuminance(dstRed, dstGreen, dstBlue);
                        double[] clipedColor = RasterUtils.ClipColor(dstRed += dstLum - srcLum, dstGreen += dstLum - srcLum, dstBlue += dstLum - srcLum, dstLum);
                        result[0] = (int)Math.round(clipedColor[0]);
                        result[1] = (int)Math.round(clipedColor[1]);
                        result[2] = (int)Math.round(clipedColor[2]);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case OVERPRINTDst: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        double[] percentage = new double[]{(double)src[0] / 255.0, (double)src[1] / 255.0, (double)src[2] / 255.0, (double)src[3] / 255.0};
                        result[0] = (int)Math.round(0.95 * percentage[0] * (double)dst[0] + 0.050000000000000044 * (1.0 - percentage[0]) * (double)src[0]);
                        result[1] = (int)Math.round(0.95 * percentage[1] * (double)dst[1] + 0.050000000000000044 * (1.0 - percentage[1]) * (double)src[1]);
                        result[2] = (int)Math.round(0.95 * percentage[2] * (double)dst[2] + 0.050000000000000044 * (1.0 - percentage[2]) * (double)src[2]);
                        result[3] = (int)Math.round(0.95 * percentage[3] * (double)dst[3] + 0.050000000000000044 * (1.0 - percentage[3]) * (double)src[3]);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
            case OVERPRINTSrc: {
                return new RasterBlendingMixture(){

                    @Override
                    public void blend(int[] src, int[] dst, int[] result) {
                        double[] percentage = new double[]{(double)dst[0] / 255.0, (double)dst[1] / 255.0, (double)dst[2] / 255.0, (double)dst[3] / 255.0};
                        result[0] = (int)Math.round(0.95 * percentage[0] * (double)src[0] + 0.050000000000000044 * (1.0 - percentage[0]) * (double)dst[0]);
                        result[1] = (int)Math.round(0.95 * percentage[1] * (double)src[1] + 0.050000000000000044 * (1.0 - percentage[1]) * (double)dst[1]);
                        result[2] = (int)Math.round(0.95 * percentage[2] * (double)src[2] + 0.050000000000000044 * (1.0 - percentage[2]) * (double)dst[2]);
                        result[3] = (int)Math.round(0.95 * percentage[3] * (double)src[3] + 0.050000000000000044 * (1.0 - percentage[3]) * (double)dst[3]);
                        result[3] = src[3] == 255 ? 255 : Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                    }
                };
            }
        }
        return null;
    }
}

