/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.permissions.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReference;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReferenceList;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersDocMDP;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.util.BitwiseExpression;
import com.adobe.internal.util.BitwiseOperandEvaluator;
import com.adobe.internal.util.InvalidOperandException;
import com.adobe.internal.util.MalformedExpressionException;
import java.util.HashMap;
import java.util.Map;

public class PermissionProviderDocMDP
implements PermissionProvider,
BitwiseOperandEvaluator {
    private PDFDocument m_PDFDoc;
    static final String FILLIN_SIGN = "FillInSign";
    static final String FILLIN_SIGN_ANNOTS = "FillInSignAnnots";
    static final String DENY = "Deny";
    private static final Map<ObjectOperations, String> m_PermissionData = PermissionProviderDocMDP.initData();

    public PermissionProviderDocMDP(PDFDocument doc) {
        this.m_PDFDoc = doc;
    }

    public static Map<ObjectOperations, String> initData() {
        HashMap<ObjectOperations, String> permissionData = new HashMap<ObjectOperations, String>();
        permissionData.put(ObjectOperations.DOC_MODIFY, DENY);
        permissionData.put(ObjectOperations.DOC_SECURE, DENY);
        permissionData.put(ObjectOperations.DOC_FULLSAVE, DENY);
        permissionData.put(ObjectOperations.DOC_IMPORT, DENY);
        permissionData.put(ObjectOperations.PAGE_CREATE, DENY);
        permissionData.put(ObjectOperations.PAGE_DELETE, DENY);
        permissionData.put(ObjectOperations.PAGE_MODIFY, DENY);
        permissionData.put(ObjectOperations.PAGE_ROTATE, DENY);
        permissionData.put(ObjectOperations.PAGE_CROP, DENY);
        permissionData.put(ObjectOperations.PAGE_INSERT, DENY);
        permissionData.put(ObjectOperations.PAGE_REPLACE, DENY);
        permissionData.put(ObjectOperations.PAGE_REORDER, DENY);
        permissionData.put(ObjectOperations.LINK_CREATE, DENY);
        permissionData.put(ObjectOperations.LINK_DELETE, DENY);
        permissionData.put(ObjectOperations.LINK_MODIFY, DENY);
        permissionData.put(ObjectOperations.LINK_IMPORT, DENY);
        permissionData.put(ObjectOperations.BOOKMARK_CREATE, DENY);
        permissionData.put(ObjectOperations.BOOKMARK_DELETE, DENY);
        permissionData.put(ObjectOperations.BOOKMARK_MODIFY, DENY);
        permissionData.put(ObjectOperations.THUMBNAIL_CREATE, DENY);
        permissionData.put(ObjectOperations.THUMBNAIL_DELETE, DENY);
        permissionData.put(ObjectOperations.ANNOT_CREATE, FILLIN_SIGN_ANNOTS);
        permissionData.put(ObjectOperations.ANNOT_DELETE, FILLIN_SIGN_ANNOTS);
        permissionData.put(ObjectOperations.ANNOT_MODIFY, FILLIN_SIGN_ANNOTS);
        permissionData.put(ObjectOperations.ANNOT_IMPORT, FILLIN_SIGN_ANNOTS);
        permissionData.put(ObjectOperations.ANNOT_ONLINE, FILLIN_SIGN_ANNOTS);
        permissionData.put(ObjectOperations.FORM_CREATE, DENY);
        permissionData.put(ObjectOperations.FORM_DELETE, DENY);
        permissionData.put(ObjectOperations.FORM_MODIFY, "FillInSignAnnots|FillInSign");
        permissionData.put(ObjectOperations.FORM_FILLIN, "FillInSignAnnots|FillInSign");
        permissionData.put(ObjectOperations.FORM_IMPORT, "FillInSignAnnots|FillInSign");
        permissionData.put(ObjectOperations.FORM_SPAWN_TEMPLATE, "FillInSignAnnots|FillInSign");
        permissionData.put(ObjectOperations.SIGNATURE_CREATE, DENY);
        permissionData.put(ObjectOperations.SIGNATURE_DELETE, DENY);
        permissionData.put(ObjectOperations.SIGNATURE_MODIFY, DENY);
        permissionData.put(ObjectOperations.SIGNATURE_FILLIN, "FillInSignAnnots|FillInSign");
        permissionData.put(ObjectOperations.EF_CREATE, DENY);
        permissionData.put(ObjectOperations.EF_DELETE, DENY);
        permissionData.put(ObjectOperations.EF_MODIFY, DENY);
        permissionData.put(ObjectOperations.EF_IMPORT, DENY);
        return permissionData;
    }

    @Override
    public boolean isPermitted(ObjectOperations objOpr) throws PDFUnableToCompleteOperationException {
        String permValue = m_PermissionData.get(objOpr);
        if (permValue == null) {
            return true;
        }
        if (permValue.equals(DENY)) {
            return false;
        }
        BitwiseExpression expObj = new BitwiseExpression(this);
        boolean bRet = true;
        try {
            bRet = expObj.evaluateExpression(permValue);
        }
        catch (MalformedExpressionException e) {
            throw new RuntimeException("Gibson internal error", e);
        }
        catch (InvalidOperandException e) {
            throw new PDFUnableToCompleteOperationException("Unable to complete permissions query on " + objOpr.toString(), e);
        }
        return bRet;
    }

    @Override
    public boolean evaluate(String operandVar) throws InvalidOperandException {
        boolean bRet = false;
        try {
            if (operandVar.equals(FILLIN_SIGN_ANNOTS)) {
                bRet = this.isPermissionSet(this.m_PDFDoc, PDFDocMDPPermissions.AnnotationFormChanges);
            }
            if (operandVar.equals(FILLIN_SIGN)) {
                bRet = this.isPermissionSet(this.m_PDFDoc, PDFDocMDPPermissions.FormChanges);
            }
        }
        catch (PDFException e) {
            throw new InvalidOperandException("Unable to query permissions from DocMDP Permission provider" + e);
        }
        return bRet;
    }

    private boolean isPermissionSet(PDFDocument pdfDoc, PDFDocMDPPermissions docPermissions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSignatureReferenceList sigRefs;
        PDFSignature docMDPSig;
        boolean hasPermissionsSignature;
        PDFPermissions perms = pdfDoc.requireCatalog().getPermissions();
        boolean bl = perms != null ? perms.getDocMDP() != null || perms.getUR() != null || perms.getUR3() != null : (hasPermissionsSignature = false);
        if (hasPermissionsSignature && (docMDPSig = perms.getDocMDP()) != null && (sigRefs = docMDPSig.getSignatureReferences()) != null) {
            for (PDFSignatureReference sigRef : sigRefs) {
                if (sigRef.getTransformMethodName() != PDFSignature.k_DocMDP) continue;
                PDFTransformParametersDocMDP transformParams = (PDFTransformParametersDocMDP)sigRef.getPDFTransformParameters();
                PDFDocMDPPermissions docPerms = transformParams.getPermissions();
                return docPerms == docPermissions;
            }
        }
        return false;
    }
}

