/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAService;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.EmbeddedFilePDFA1ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.EmbeddedFilePDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2Service;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFileStructureErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorEmbeddedFileNotPDFACompliantButFileSpecDictContainsEF;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorFileSpecDictFKeyNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorFileSpecDictUFKeyNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DefaultEmbeddedFilePDFA1ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DefaultEmbeddedFilePDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.EmbeddedFileProcessor;
import java.io.IOException;
import java.util.HashSet;

class PDFA2EmbeddedFileProcessor
extends EmbeddedFileProcessor {
    private static PDFA2EmbeddedFileProcessor _instance = new PDFA2EmbeddedFileProcessor();

    private PDFA2EmbeddedFileProcessor() {
    }

    static PDFA2EmbeddedFileProcessor getInstance() {
        return _instance;
    }

    @Override
    void process(CosObject cosObj, PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> flags, PDFA2ValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, HashSet<CosObject> associatedFilesList) throws PDFIOException, PDFSecurityException, IOException {
        int objectNumber = cosObj.getObjNum();
        int genNumber = cosObj.getObjGen();
        if (cosObj instanceof CosDictionary) {
            CosDictionary cosDict = (CosDictionary)cosObj;
            try {
                CosObject typeCosObj = cosDict.get(ASName.k_Type);
                if (typeCosObj instanceof CosName && typeCosObj.nameValue() == ASName.k_Filespec) {
                    if (cosDict.containsKey(ASName.k_EF)) {
                        PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> eSet = this.validateEmbeddedFile(cosDict, validationHandler, conversionHandler, null);
                        flags.mergeErrorSet(eSet);
                    }
                    if (!cosDict.containsKey(ASName.k_F)) {
                        flags.addErrorCode(new PDFA2FileStructureErrorFileSpecDictFKeyNotPresent(objectNumber, genNumber));
                    }
                    if (!cosDict.containsKey(ASName.k_UF)) {
                        flags.addErrorCode(new PDFA2FileStructureErrorFileSpecDictUFKeyNotPresent(objectNumber, genNumber));
                    }
                }
            }
            catch (PDFInvalidDocumentException e) {
                flags.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(objectNumber, genNumber));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> validateEmbeddedFile(CosDictionary cosDict, PDFA2ValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, HashSet<CosObject> associatedFiles) throws PDFIOException, PDFSecurityException, IOException, PDFInvalidDocumentException {
        PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> eSet = new PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode>();
        CosStream embFile = cosDict.getCosDictionary(ASName.k_EF).getCosStream(ASName.k_F);
        int objectNumber = embFile.getObjNum();
        int genNumber = embFile.getObjGen();
        if (embFile != null) {
            InputByteStream ibs = null;
            InputStreamByteReader reader = null;
            PDFDocument embedDoc = null;
            try {
                PDFA2ValidationOptions embeddedFilePDFA2ValidationOptions;
                ibs = embFile.getStreamDecoded();
                reader = new InputStreamByteReader(ibs.toInputStream());
                embedDoc = PDFDocument.newInstance(reader, PDFOpenOptions.newInstance());
                EmbeddedFilePDFA2ValidationHandler embeddedFilePDFA2ValidationHandler = validationHandler.getEmbeddedFilePDFA2ValidationHandler();
                if (embeddedFilePDFA2ValidationHandler == null) {
                    embeddedFilePDFA2ValidationHandler = new DefaultEmbeddedFilePDFA2ValidationHandler();
                }
                if ((embeddedFilePDFA2ValidationOptions = embeddedFilePDFA2ValidationHandler.getEmbeddedFilePDFA2ValidationOptions()) == null) {
                    embeddedFilePDFA2ValidationOptions = new PDFA2ValidationOptions();
                }
                PDFA2Service.validate(embedDoc, PDFA2ConformanceLevel.Level_2b, embeddedFilePDFA2ValidationOptions, embeddedFilePDFA2ValidationHandler);
                if (embeddedFilePDFA2ValidationHandler.errorsFound()) {
                    PDFAValidationOptions embeddedFilePDFA1ValidationOptions;
                    EmbeddedFilePDFA1ValidationHandler embeddedFilePDFA1ValidationHandler = validationHandler.getEmbeddedFilePDFA1ValidationHandler();
                    if (embeddedFilePDFA1ValidationHandler == null) {
                        embeddedFilePDFA1ValidationHandler = new DefaultEmbeddedFilePDFA1ValidationHandler();
                    }
                    if ((embeddedFilePDFA1ValidationOptions = embeddedFilePDFA1ValidationHandler.getEmbeddedFilePDFA1ValidationOptions()) == null) {
                        embeddedFilePDFA1ValidationOptions = new PDFAValidationOptions();
                    }
                    PDFAService.validate(embedDoc, PDFAConformanceLevel.Level_1b, embeddedFilePDFA1ValidationOptions, embeddedFilePDFA1ValidationHandler);
                    if (embeddedFilePDFA1ValidationHandler.errorsFound()) {
                        eSet.addErrorCode(new PDFA2FileStructureErrorEmbeddedFileNotPDFACompliantButFileSpecDictContainsEF(objectNumber, genNumber));
                    }
                }
            }
            catch (Exception e) {
                eSet.addErrorCode(new PDFA2FileStructureErrorEmbeddedFileNotPDFACompliantButFileSpecDictContainsEF(objectNumber, genNumber));
            }
            finally {
                try {
                    try {
                        if (ibs != null) {
                            ibs.close();
                        }
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        finally {
                            if (embedDoc != null) {
                                embedDoc.close();
                            }
                        }
                    }
                }
                catch (PDFUnableToCompleteOperationException pDFUnableToCompleteOperationException) {}
            }
        }
        return eSet;
    }
}

