/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionNamed;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUnknown;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldType;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntent;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntentsList;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetAnnotation;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAAnnotationErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.SharedConstraints;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.XObjectProcessor;
import java.awt.color.ColorSpace;
import java.util.HashSet;
import java.util.Iterator;

class AnnotationProcessor {
    private static HashSet allowedAnnotTypes = new HashSet();

    AnnotationProcessor() {
    }

    static boolean process(PDFPage page, DocumentProcessor docProcessor, PDFResources parentResources, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        block8: {
            if (page == null) {
                return true;
            }
            if (!validationHandler.beginAnnotationsScan()) {
                return false;
            }
            try {
                HashSet postProcessRemovalSet = null;
                if (conversionHandler != null) {
                    postProcessRemovalSet = new HashSet();
                }
                PDFAnnotationIterator iter = page.getAnnotationsIterator();
                while (iter.hasNext()) {
                    PDFAnnotation annot = iter.next();
                    if (AnnotationProcessor.process(annot, iter, postProcessRemovalSet, docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) continue;
                    return false;
                }
                if (conversionHandler != null && !postProcessRemovalSet.isEmpty()) {
                    PDFAnnotationList annotList = page.getAnnotationList();
                    for (PDFAnnotation annot : postProcessRemovalSet) {
                        if (!annotList.contains(annot)) continue;
                        annotList.remove(annot);
                    }
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (validationHandler.annotationError(new PDFAErrorSetAnnotation(PDFAAnnotationErrorCode.pdfGeneralFailure))) break block8;
                return false;
            }
        }
        return validationHandler.endAnnotationsScan();
    }

    static boolean process(PDFAnnotation annot, PDFAnnotationIterator annotsIter, HashSet postProcessRemovalSet, DocumentProcessor docProcessor, PDFResources parentResources, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        if (annot == null) {
            return true;
        }
        if (!validationHandler.beginAnnotationScan(annot)) {
            return false;
        }
        PDFAErrorSetAnnotation errorCodes = new PDFAErrorSetAnnotation();
        try {
            if (!allowedAnnotTypes.contains(annot.getSubtype())) {
                if (conversionHandler != null && conversionOptions.getRemoveIllegalAnnotations()) {
                    annotsIter.remove();
                    if (!conversionHandler.illegalAnnotationRemoved(annot)) {
                        return false;
                    }
                    return validationHandler.endAnnotationScan();
                }
                errorCodes.addErrorCode(PDFAAnnotationErrorCode.annotNotAllowed);
            } else {
                PDFAdditionalActions aa;
                PDFAErrorSetAnnotation rgbOutputProfileErrorSet;
                Number opacity;
                PDFAnnotationMarkup markup;
                if (PDFOCObject.hasOC(annot) && conversionHandler != null && conversionOptions.getRemoveOptionalContent()) {
                    PDFOCObject oc = PDFOCObject.getOC(annot);
                    if (docProcessor.canRemovePDFOCObject(oc)) {
                        PDFOCObject.removeOC(annot);
                        if (!conversionHandler.annotOnOCEntryRemoved(annot, oc)) {
                            return false;
                        }
                    } else {
                        PDFAnnotationPopup popup;
                        if (annot instanceof PDFAnnotationMarkup) {
                            PDFAnnotationMarkup markup2 = (PDFAnnotationMarkup)annot;
                            if (markup2.hasPopup() && postProcessRemovalSet != null) {
                                postProcessRemovalSet.add(markup2.getPopup());
                            }
                        } else if (annot instanceof PDFAnnotationPopup && (popup = (PDFAnnotationPopup)annot).hasParent()) {
                            postProcessRemovalSet.add(popup.getParent());
                        }
                        annotsIter.remove();
                        return conversionHandler.annotWithOffOCRemoved(annot);
                    }
                }
                if (annot instanceof PDFAnnotationMarkup && (markup = (PDFAnnotationMarkup)annot).hasOpacity() && (opacity = markup.getOpacity()) != null && opacity.doubleValue() != 1.0) {
                    errorCodes.addErrorCode(PDFAAnnotationErrorCode.markupAnnotHasNonAllowedOpacity);
                }
                if (conversionHandler != null) {
                    int oldFlags = 0;
                    if (annot.hasFlags()) {
                        oldFlags = annot.getFlags();
                    }
                    boolean removeAnnot = false;
                    if ((oldFlags & 1) == 1 && conversionOptions.getRemoveInvisibleNonStandardAnnots() && annot instanceof PDFAnnotationUnknown) {
                        removeAnnot = true;
                    }
                    if ((oldFlags & 2) == 2 && conversionOptions.getRemoveHiddenAnnots()) {
                        removeAnnot = true;
                    }
                    if ((oldFlags & 0x20) == 32 && conversionOptions.getRemoveNoViewAnnots()) {
                        removeAnnot = true;
                    }
                    if (removeAnnot) {
                        annotsIter.remove();
                        if (!conversionHandler.invisibleHiddenOrNoViewAnnotRemoved(annot)) {
                            return false;
                        }
                        return validationHandler.endAnnotationScan();
                    }
                    if (conversionOptions.getOverrideAnnotationFlags() || !annot.hasFlags()) {
                        int newFlags = oldFlags;
                        newFlags |= 4;
                        newFlags &= 0xFFFFFFDC;
                        if (annot instanceof PDFAnnotationText) {
                            newFlags |= 0x18;
                        }
                        if (newFlags != oldFlags) {
                            annot.setFlags(newFlags);
                            if (!conversionHandler.annotationFlagsSet(annot, oldFlags, newFlags)) {
                                return false;
                            }
                        }
                    }
                } else if (annot.hasFlags()) {
                    int flags = annot.getFlags();
                    if ((flags & 4) != 4) {
                        errorCodes.addErrorCode(PDFAAnnotationErrorCode.annotFlagPrintNotSet);
                    }
                    if ((flags & 2) == 2) {
                        errorCodes.addErrorCode(PDFAAnnotationErrorCode.annotFlagHiddenSet);
                    }
                    if ((flags & 1) == 1) {
                        errorCodes.addErrorCode(PDFAAnnotationErrorCode.annotFlagInvisibleSet);
                    }
                    if ((flags & 0x20) == 32) {
                        errorCodes.addErrorCode(PDFAAnnotationErrorCode.annotFlagNoViewSet);
                    }
                    if (annot instanceof PDFAnnotationText) {
                        if ((flags & 8) != 8) {
                            errorCodes.addErrorCode(PDFAAnnotationErrorCode.textAnnotFlagNoZoomNotSet);
                        }
                        if ((flags & 0x10) != 16) {
                            errorCodes.addErrorCode(PDFAAnnotationErrorCode.textAnnotFlagNoRotateNotSet);
                        }
                    }
                } else {
                    errorCodes.addErrorCode(PDFAAnnotationErrorCode.annotFlagsMissing);
                }
                if ((annot.dictionaryContains(ASName.k_C) || annot.dictionaryContains(ASName.k_IC)) && (rgbOutputProfileErrorSet = AnnotationProcessor.processAnnotForOutputIntent(annot)).hasErrors()) {
                    if (conversionHandler != null) {
                        PDFOutputIntent outputIntent = conversionOptions.getPDFAOutputIntent();
                        if (outputIntent != null && conversionOptions.overWritePDFAOutputIntentSet() && !docProcessor.outputIntentReplaced) {
                            PDFOutputIntentsList outputIntentsList = PDFOutputIntentsList.newInstance(docProcessor.document);
                            outputIntentsList.add(outputIntent);
                            docProcessor.document.requireCatalog().setOutputIntents(outputIntentsList);
                            conversionHandler.pdfaOutputIntentSet(outputIntent);
                            PDFAErrorSetAnnotation afterReplacementErrors = AnnotationProcessor.processAnnotForOutputIntent(annot);
                            if (afterReplacementErrors.hasErrors()) {
                                errorCodes.mergeErrorSet(afterReplacementErrors);
                            }
                        } else {
                            errorCodes.mergeErrorSet(rgbOutputProfileErrorSet);
                        }
                    } else {
                        errorCodes.mergeErrorSet(rgbOutputProfileErrorSet);
                    }
                }
                PDFAppearance ap = annot.getAppearance();
                if (annot.getSubtype() == ASName.k_Widget && ap == null) {
                    if (conversionHandler != null) {
                        ASName name = null;
                        if (((PDFAnnotationWidget)annot).getField().getFieldType() == PDFFieldType.Button) {
                            name = ASName.k_OFF;
                        }
                        PDFDocument doc = annot.getPDFDocument();
                        annot.setAppearance(PDFAppearance.newInstance(doc).setAppearance(ASName.k_N, name, PDFXObjectForm.newInstance(doc, annot.getRect(), PDFResources.newInstance(doc), null)));
                    } else {
                        errorCodes.addErrorCode(PDFAAnnotationErrorCode.formFieldHasNoAppearanceDefined);
                    }
                } else if (ap != null) {
                    if (!ap.dictionaryContains(ASName.k_N)) {
                        errorCodes.addErrorCode(PDFAAnnotationErrorCode.normalAppearanceMissing);
                    } else {
                        PDFXObjectForm xObject;
                        CosObject nObj = ap.getCosDictionary().get(ASName.k_N);
                        if (annot.getSubtype() == ASName.k_Widget && ((PDFAnnotationWidget)annot).getField() instanceof PDFFieldButton) {
                            if (nObj.getType() != 6) {
                                if (conversionHandler != null) {
                                    PDFAppearance newAppearance = PDFAppearance.newInstance(annot.getPDFDocument());
                                    newAppearance.setAppearance(ASName.k_N, ASName.create("Off"), PDFXObjectForm.getInstance(nObj));
                                    annot.setAppearance(newAppearance);
                                    annot.setAppearanceState(false);
                                    if (!conversionHandler.normalAPStreamConvertedToDictForButton(annot)) {
                                        return false;
                                    }
                                } else {
                                    errorCodes.addErrorCode(PDFAAnnotationErrorCode.formFieldOfTypeBtnDoesNotHaveMultipleAppearance);
                                }
                            } else {
                                CosDictionary nObjDict = (CosDictionary)nObj;
                                Iterator<ASName> nObjKeysIter = nObjDict.keyIterator();
                                while (nObjKeysIter.hasNext()) {
                                    PDFXObjectForm xObject2;
                                    ASName nObjKey = nObjKeysIter.next();
                                    CosObject nObjValue = nObjDict.get(nObjKey);
                                    if (nObjValue.getType() != 7 || XObjectProcessor.process(ASName.k_N, xObject2 = PDFXObjectForm.getInstance(nObjValue), docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, null)) continue;
                                    return false;
                                }
                            }
                        } else {
                            if (!(nObj instanceof CosStream) && conversionHandler != null && nObj instanceof CosDictionary) {
                                CosObject asObj;
                                CosDictionary nDict = (CosDictionary)nObj;
                                CosObject nTemp = null;
                                if (nDict.size() == 1) {
                                    nTemp = nDict.get(nDict.getKeys().get(0));
                                } else if (annot.dictionaryContains(ASName.k_AS) && (asObj = annot.getCosDictionary().get(ASName.k_AS)) instanceof CosName) {
                                    ASName key = ((CosName)asObj).nameValue();
                                    nTemp = nDict.get(key);
                                }
                                if (nTemp instanceof CosStream) {
                                    nObj = nTemp;
                                    ap.getCosDictionary().put(ASName.k_N, nObj);
                                    if (!conversionHandler.normalAPDictConvertedToStream(annot)) {
                                        return false;
                                    }
                                }
                            }
                            if (nObj.getType() != 7) {
                                errorCodes.addErrorCode(PDFAAnnotationErrorCode.normalAppearanceMissing);
                            }
                        }
                        if (nObj.getType() == 7 && !XObjectProcessor.process(ASName.k_N, xObject = PDFXObjectForm.getInstance(nObj), docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, null)) {
                            return false;
                        }
                    }
                    if (ap.dictionaryContains(ASName.k_D) || ap.dictionaryContains(ASName.k_R)) {
                        if (conversionHandler != null && conversionOptions.getRemoveNonNormalAnnotApperances()) {
                            if (ap.dictionaryContains(ASName.k_D)) {
                                ap.removeValue(ASName.k_D);
                                if (!conversionHandler.nonNormalAnnotAppearanceRemoved(annot, ASName.k_D)) {
                                    return false;
                                }
                            }
                            if (ap.dictionaryContains(ASName.k_R)) {
                                ap.removeValue(ASName.k_R);
                                if (!conversionHandler.nonNormalAnnotAppearanceRemoved(annot, ASName.k_R)) {
                                    return false;
                                }
                            }
                        } else {
                            errorCodes.addErrorCode(PDFAAnnotationErrorCode.nonNormalAppearancesPresent);
                        }
                    }
                }
                if (annot.hasAction()) {
                    if (annot instanceof PDFAnnotationWidget) {
                        if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                            PDFAction action = annot.getAction();
                            annot.removeValue(ASName.k_A);
                            if (!conversionHandler.illegalActionRemoved(action)) {
                                return false;
                            }
                        } else {
                            errorCodes.addErrorCode(PDFAAnnotationErrorCode.actionNotAllowed);
                        }
                    } else {
                        PDFAction action = annot.getAction();
                        PDFAction.TreeIterator actionIter = action.treeIterator();
                        while (actionIter.hasNext()) {
                            action = actionIter.next();
                            ASName subtype = action.getSubtype();
                            if (subtype == ASName.k_Named) {
                                PDFActionNamed namedAction = (PDFActionNamed)action;
                                ASName actionName = namedAction.getName();
                                if (actionName == ASName.create("NextPage") || actionName == ASName.create("PrevPage") || actionName == ASName.create("FirstPage") || actionName == ASName.create("LastPage")) continue;
                                if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                                    annot.removeValue(ASName.k_A);
                                    if (conversionHandler.illegalActionRemoved(action)) continue;
                                    return false;
                                }
                                errorCodes.addErrorCode(PDFAAnnotationErrorCode.namedActionNotAllowed);
                                continue;
                            }
                            PDFAAnnotationErrorCode ec = PDFAAnnotationErrorCode.getErrorCode(subtype);
                            if (ec == null) continue;
                            if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                                annot.removeValue(ASName.k_A);
                                if (conversionHandler.illegalActionRemoved(action)) continue;
                                return false;
                            }
                            errorCodes.addErrorCode(ec);
                        }
                    }
                }
                if (annot instanceof PDFAnnotationWidget && (aa = annot.getAdditionalActions()) != null) {
                    if (conversionHandler != null && conversionOptions.getRemoveIllegalAdditionalActions()) {
                        annot.getCosDictionary().remove(ASName.k_AA);
                        if (!conversionHandler.illegalAdditionalActionsRemoved(aa)) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(PDFAAnnotationErrorCode.additionalActionsNotAllowed);
                    }
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(PDFAAnnotationErrorCode.pdfGeneralFailure);
        }
        if (errorCodes.hasErrors() && !validationHandler.annotationError(errorCodes)) {
            return false;
        }
        return validationHandler.endAnnotationScan();
    }

    private static ASName getAnnotFTValueFromHierarchy(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName annotFT = null;
        if (annot.dictionaryContains(ASName.k_FT)) {
            annotFT = annot.getDictionaryNameValue(ASName.k_FT);
        } else {
            CosDictionary curAnnotDict = annot.getCosDictionary();
            while (curAnnotDict.containsKey(ASName.k_Parent)) {
                CosDictionary parentAnnotDict = curAnnotDict.getCosDictionary(ASName.k_Parent);
                if (parentAnnotDict.containsKey(ASName.k_FT)) {
                    annotFT = parentAnnotDict.getName(ASName.k_FT);
                    break;
                }
                curAnnotDict = parentAnnotDict;
            }
        }
        return annotFT;
    }

    private static PDFAErrorSetAnnotation processAnnotForOutputIntent(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAErrorSetAnnotation rgbOutputProfileErrorSet = new PDFAErrorSetAnnotation();
        PDFOutputIntentsList intents = annot.getPDFDocument().requireCatalog().getOutputIntents();
        if (intents == null) {
            rgbOutputProfileErrorSet.addErrorCode(PDFAAnnotationErrorCode.rgbPDFA1DestOuputProfileNotFound);
        } else {
            boolean rgbPDFCSFound = false;
            for (PDFOutputIntent intent : intents) {
                ASName subtype = intent.getSubType();
                if (!subtype.equals(SharedConstraints.k_GTS_PDFA1)) continue;
                PDFICCProfile iccProfile = intent.getDestOutputProfile();
                if (iccProfile == null) {
                    rgbOutputProfileErrorSet.addErrorCode(PDFAAnnotationErrorCode.rgbPDFA1DestOuputProfileNotFound);
                    continue;
                }
                ColorSpace cs = iccProfile.getColorSpace();
                if (cs.getType() != 5) continue;
                rgbPDFCSFound = true;
            }
            if (!rgbPDFCSFound) {
                rgbOutputProfileErrorSet.addErrorCode(PDFAAnnotationErrorCode.rgbPDFA1DestOuputProfileNotFound);
            }
        }
        return rgbOutputProfileErrorSet;
    }

    public static void process(PDFAnnotation annot, DocumentProcessor.UseColor uc) {
        try {
            if (allowedAnnotTypes.contains(annot.getSubtype()) && (annot.dictionaryContains(ASName.k_C) || annot.dictionaryContains(ASName.k_IC))) {
                uc.found = true;
                uc.useRGB = true;
            }
        }
        catch (PDFIOException | PDFInvalidDocumentException | PDFSecurityException pDFException) {
            // empty catch block
        }
    }

    static {
        allowedAnnotTypes.add(ASName.k_Text);
        allowedAnnotTypes.add(ASName.k_Link);
        allowedAnnotTypes.add(ASName.k_FreeText);
        allowedAnnotTypes.add(ASName.k_Line);
        allowedAnnotTypes.add(ASName.k_Square);
        allowedAnnotTypes.add(ASName.k_Circle);
        allowedAnnotTypes.add(ASName.k_Highlight);
        allowedAnnotTypes.add(ASName.k_Underline);
        allowedAnnotTypes.add(ASName.k_Squiggly);
        allowedAnnotTypes.add(ASName.k_StrikeOut);
        allowedAnnotTypes.add(ASName.k_Stamp);
        allowedAnnotTypes.add(ASName.k_Ink);
        allowedAnnotTypes.add(ASName.k_Popup);
        allowedAnnotTypes.add(ASName.k_Widget);
        allowedAnnotTypes.add(ASName.k_PrinterMark);
        allowedAnnotTypes.add(ASName.k_TrapNet);
    }
}

