/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.common.BaseUnembeddedFontInfo;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.ReferencedFontInfoProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.TrueTypeFontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.Type0FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.Type1FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.Type3FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.UnembeddedFontInfo;
import com.adobe.internal.pdftoolkit.services.pdfa.font.WidthsProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.MetadataProcessor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;

public class FontProcessor {
    static final int FONT_DATA_TYPE0 = 0;
    static final int FONT_DATA_TYPE1 = 1;
    static final int FONT_DATA_TRUETYPE = 2;
    static final String NOTDEF = ".notdef";

    static void unSetErrorFlag(PDFAErrorSet errorCodes, PDFAErrorCode errorCode) {
        errorCodes.unSetErrorFlag(errorCode);
    }

    static boolean isSetErrorFlag(PDFAErrorSet errorCodes, PDFAErrorCode errorCode) {
        return errorCodes.errorCodeSet(errorCode);
    }

    private static boolean willEmbed(PDFFont pdfFont, PDFAErrorSetFont errorCodes, PDFAConversionHandler conversionHandler, PDFAConversionOptions conversionOptions) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (pdfFont instanceof PDFFontType3) {
            return false;
        }
        if (conversionHandler == null || conversionOptions == null) {
            return false;
        }
        if (!conversionOptions.getShouldEmbedFonts()) {
            return false;
        }
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.fontNotEmbedded) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.symbolicTTProgramCmapTableDoesNotHaveOneEntry) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.type2CIDFontInvalidCIDToGIDMap) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.type2CIDFontMissingCIDToGIDMap)) {
            return true;
        }
        return FontProcessor.willEmbedSimpleFontsAsType0(pdfFont, errorCodes);
    }

    static boolean willEmbedSimpleFontsAsType0(PDFFont font, PDFAErrorSetFont errorCodes) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (font instanceof PDFFontSimple && font.getSubtype() == ASName.k_TrueType && PDFFontUtils.isFontEmbedded(font)) {
            if (errorCodes.getErrorCodes().size() == 1 && (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.symbolicTrueTypeEncodingNotAllowed) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.trueTypeEmbeddedFontCouldNotMapGlyph))) {
                return true;
            }
            if (errorCodes.getErrorCodes().size() == 2 && FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.symbolicTrueTypeEncodingNotAllowed) && FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.trueTypeEmbeddedFontCouldNotMapGlyph)) {
                return true;
            }
        }
        if (font instanceof PDFFontSimple && font.getSubtype() == ASName.k_Type1 && !PDFFontUtils.isFontEmbedded(font)) {
            PDFFontSimple simpleFont = (PDFFontSimple)font;
            PDFSimpleFontEncoding encoding = simpleFont.getEncoding();
            if (encoding == null || encoding.getDifferences() == null) {
                return false;
            }
            try {
                FontData fontData;
                Font afeFont = font.getAFEFont();
                if (afeFont != null && PDFFontUtils.isFontDataTrueType(fontData = ((FontImpl)afeFont).getFontData())) {
                    return true;
                }
            }
            catch (FontLoadingException e) {
                return false;
            }
            catch (InvalidFontException e) {
                return false;
            }
            catch (UnsupportedFontException e) {
                return false;
            }
        }
        return false;
    }

    static void setTypeErrorCodes(CosDictionary obj, ASName type, PDFAConversionHandler conversionHandler, PDFAErrorSetFont errorCodes, PDFAErrorCode errorCodeWrongType, PDFAErrorCode errorCodeAbsent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (conversionHandler != null) {
            obj.put(ASName.k_Type, type);
            return;
        }
        CosObject cosType = obj.get(ASName.k_Type);
        if (cosType instanceof CosName) {
            ASName thisType = ((CosName)cosType).nameValue();
            if (thisType != type) {
                errorCodes.addErrorCode(errorCodeWrongType);
            }
        } else {
            errorCodes.addErrorCode(errorCodeAbsent);
        }
    }

    static boolean processBadFont(ASName name, PDFFontMap map, List showStringList, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        PDFAErrorSetFont errorCodes;
        block10: {
            if (showStringList == null || showStringList.isEmpty()) {
                return true;
            }
            if (!validationHandler.beginFontScan(name, null)) {
                return false;
            }
            errorCodes = new PDFAErrorSetFont();
            CosDictionary cosFonts = map.getCosDictionary();
            if (cosFonts == null) {
                errorCodes.addErrorCode(PDFAFontErrorCode.pdfGeneralFailure);
            } else {
                try {
                    CosDictionary cosFont = cosFonts.getCosDictionary(name);
                    if (cosFont == null) {
                        errorCodes.addErrorCode(PDFAFontErrorCode.pdfGeneralFailure);
                        break block10;
                    }
                    try {
                        PDFFontFactory.getInstance(cosFont);
                        throw new RuntimeException("FontProcessor.processBadFont() should not have reached here.");
                    }
                    catch (PDFInvalidDocumentException e) {
                        errorCodes.addErrorCode(PDFAFontErrorCode.malformedFontDictionary);
                    }
                }
                catch (PDFCosParseException e) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.pdfGeneralFailure);
                }
            }
        }
        if (!validationHandler.fontError(errorCodes)) {
            return false;
        }
        return validationHandler.endFontScan();
    }

    private static boolean process(ASName name, PDFFont font, List showStringList, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFontMap drFonts = docProcessor.getFontContext().getDrFonts();
        if (showStringList == null || showStringList.isEmpty()) {
            return true;
        }
        if (!validationHandler.beginFontScan(name, font)) {
            return false;
        }
        PDFAErrorSetFont errorCodes = new PDFAErrorSetFont();
        boolean willEmbed = false;
        try {
            if (font == null) {
                throw new PDFInvalidDocumentException("could not parse the font dictionary");
            }
            Map<CosObject, PDFAErrorSetFont> fontDictErrors = docProcessor.getFontContext().getFontDictErrors();
            Map<PDFFont, UnembeddedFontInfo> unembeddedFonts = docProcessor.getFontContext().getUnembeddedFonts();
            HashSet<Integer> referencedCharCodes = ReferencedFontInfoProcessor.getReferencedCharCodes(font, showStringList);
            TreeSet<Integer> tSet = new TreeSet<Integer>();
            tSet.addAll(referencedCharCodes);
            boolean detectedSkippedChars = false;
            try {
                if (font != null && showStringList != null) {
                    block6: for (ASString showString : showStringList) {
                        if (showString == null) continue;
                        List charCodes = font.getCharCodes(showString.getBytes(), false);
                        for (List charCodeInfo : charCodes) {
                            byte[] charCodeBytes = (byte[])charCodeInfo.get(0);
                            if (charCodeBytes != null) continue;
                            detectedSkippedChars = true;
                            continue block6;
                        }
                    }
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (!(e.getCause() instanceof MissingResourceException)) {
                    throw e;
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (detectedSkippedChars) {
                docProcessor.setSkippedCharacters(true);
            }
            if (font instanceof PDFFontSimple) {
                docProcessor.getFontContext().addCharcodesForsimpleFont((PDFFontSimple)font, referencedCharCodes);
            }
            if (fontDictErrors.containsKey(font.getCosObject()) && !(font instanceof PDFFontType3)) {
                PDFAErrorSetFont referencedGlyphErrorSet;
                errorCodes = fontDictErrors.get(font.getCosObject());
                if (PDFFontUtils.isFontEmbedded(font) && (referencedGlyphErrorSet = ReferencedFontInfoProcessor.getReferencedGlyphErrors(font, referencedCharCodes, conversionHandler, docProcessor.getFontContext())) != null) {
                    referencedGlyphErrorSet.mergeErrorSet(errorCodes);
                    errorCodes = referencedGlyphErrorSet;
                }
                willEmbed = FontProcessor.willEmbed(font, errorCodes, conversionHandler, conversionOptions);
            } else {
                PDFAErrorSetFont error;
                if (conversionHandler != null && drFonts != null && drFonts.containsValue(font)) {
                    CosCloneMgr cosCloneMgr = new CosCloneMgr(font.getPDFDocument().getCosDocument());
                    PDFFont newFont = null;
                    if (font instanceof PDFFontSimple) {
                        ASName subType = font.getSubtype();
                        newFont = PDFFontSimple.getInstance(cosCloneMgr.clone(font.getCosObject()), subType);
                    } else if (font instanceof PDFFontType0) {
                        newFont = PDFFontType0.getInstance(cosCloneMgr.clone(font.getCosObject()));
                    } else {
                        throw new PDFInvalidDocumentException("unknown font type");
                    }
                    drFonts.set(name, newFont);
                }
                if (!FontProcessor.processFontXMP(font, conversionHandler)) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.objectXMPMetadataInvalid);
                }
                if (!PDFFontUtils.isFontEmbedded(font)) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.fontNotEmbedded);
                } else {
                    errorCodes.mergeErrorSet(ReferencedFontInfoProcessor.getReferencedGlyphErrors(font, referencedCharCodes, conversionHandler, docProcessor.getFontContext()));
                }
                if (PDFFontUtils.isOpenTypeFontEmbedded(font)) {
                    PDFFontType0 pdfFont;
                    PDFCIDFont descendantFont;
                    errorCodes.addErrorCode(PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed);
                    if (font instanceof PDFFontType0 && (descendantFont = (pdfFont = (PDFFontType0)font).getDescendantFont()).getSubType() == ASName.k_CIDFontType2) {
                        PDFFontDescriptor fontDesc = descendantFont.getFontDescriptor();
                        PDFFontFile fontFile = fontDesc.getFontFile3();
                        if (fontDesc.getPDFCosDescriptor() != null) {
                            fontDesc.getPDFCosDescriptor().getCosDictionary().remove(ASName.k_FontFile3);
                            fontDesc.setFontFile2(fontFile);
                            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed);
                        }
                    }
                }
                if ((error = Type0FontProcessor.processType0FontErrors(font, conversionHandler, docProcessor.getFontContext().getCMapsEmbedded(), showStringList)) == null) {
                    return false;
                }
                errorCodes.mergeErrorSet(error);
                error = Type1FontProcessor.processType1FontErrors(font, conversionHandler);
                if (error == null) {
                    return false;
                }
                errorCodes.mergeErrorSet(error);
                error = TrueTypeFontProcessor.processTrueTypeFontErrors(font, conversionHandler);
                if (error == null) {
                    return false;
                }
                errorCodes.mergeErrorSet(error);
                error = Type3FontProcessor.processType3FontErrors(font, showStringList, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler);
                if (error == null) {
                    return false;
                }
                errorCodes.mergeErrorSet(error);
                willEmbed = FontProcessor.willEmbed(font, errorCodes, conversionHandler, conversionOptions);
                if (!willEmbed && (errorCodes = WidthsProcessor.fixWidths(font, tSet, showStringList, conversionHandler, errorCodes, docProcessor.getFontContext())) == null) {
                    return false;
                }
                fontDictErrors.put(font.getCosObject(), errorCodes);
            }
            if (errorCodes.hasErrors() && willEmbed) {
                if (font.getAFEFont() == null && FontProcessor.hasAtleastOneValidString(showStringList)) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.fontEmbeddingFailedFontNotInFontSet);
                    willEmbed = false;
                } else {
                    HashSet<Integer> newCharCodes = ReferencedFontInfoProcessor.getReferencedCharCodes(font, showStringList);
                    if (newCharCodes != null) {
                        BaseUnembeddedFontInfo existingUFInfo = null;
                        if (unembeddedFonts.containsKey(font)) {
                            existingUFInfo = unembeddedFonts.get(font);
                        }
                        if (existingUFInfo != null) {
                            Set<Integer> existingCharCodes = existingUFInfo.getCharCodes();
                            if (existingCharCodes != null) {
                                newCharCodes.addAll(existingCharCodes);
                            }
                            existingUFInfo.setCharCodes(newCharCodes);
                        } else {
                            UnembeddedFontInfo uFInfo = new UnembeddedFontInfo(newCharCodes, errorCodes, name);
                            unembeddedFonts.put(font, uFInfo);
                        }
                        if (unembeddedFonts.get(font).getCharCodes().isEmpty()) {
                            docProcessor.getFontContext().getFontsWithoutTextShowString().add(font);
                        }
                    }
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(PDFAFontErrorCode.pdfGeneralFailure);
            willEmbed = false;
        }
        catch (FontEngineException e) {
            errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
            willEmbed = false;
        }
        if (!willEmbed && errorCodes.hasErrors() && (conversionHandler == null || conversionOptions == null || !conversionOptions.isFallbackToRaster()) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.pdfGeneralFailure) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.fontDataCorrupt)) {
            if (conversionOptions != null && conversionOptions.isFallbackToRaster()) {
                conversionOptions.setFallbackToRaster(false);
            }
            if (!validationHandler.fontError(errorCodes)) {
                return false;
            }
        }
        return validationHandler.endFontScan();
    }

    private static boolean hasAtleastOneValidString(List<ASString> showStringList) {
        if (showStringList == null || showStringList.isEmpty()) {
            return false;
        }
        for (ASString showString : showStringList) {
            if (showString == null || showString.asString().length() == 0) continue;
            return true;
        }
        return false;
    }

    private static boolean processFontXMP(PDFFont font, PDFAConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontDescriptor pdfFontDescriptor = font.getFontDescriptor();
        if (pdfFontDescriptor == null) {
            return true;
        }
        PDFFontFile fontFile = PDFFontUtils.getFontFileFromFontDescriptor(pdfFontDescriptor);
        if (fontFile == null) {
            return true;
        }
        return MetadataProcessor.processDictionaryXMP(fontFile, conversionHandler);
    }

    public static boolean process(PDFFontMap fontMap, Map referencedFonts, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        Iterator<ASName> keyIter;
        if (fontMap == null || fontMap.isEmpty()) {
            return true;
        }
        if (validationOptions.validateUnusedResourcesEnabled()) {
            keyIter = fontMap.keySet().iterator();
        } else {
            if (referencedFonts == null || referencedFonts.isEmpty()) {
                return true;
            }
            keyIter = referencedFonts.keySet().iterator();
        }
        while (keyIter.hasNext()) {
            PDFFont font;
            List showStringList = null;
            ASName name = keyIter.next();
            if (referencedFonts != null && referencedFonts.containsKey(name)) {
                showStringList = (List)referencedFonts.get(name);
            }
            if ((font = fontMap.get(name)) == null ? !FontProcessor.processBadFont(name, fontMap, showStringList, validationHandler) : !FontProcessor.process(name, font, showStringList, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                return false;
            }
            if (referencedFonts == null || !referencedFonts.containsKey(name)) continue;
            referencedFonts.put(name, null);
        }
        return true;
    }
}

