/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.processor.SchemaCollector;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public final class PDFAXMPSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uri;
    private String prefix;
    private boolean prefixIsRequired = false;
    private String schema;
    private Map<String, PDFAXMPProperty> properties = new HashMap<String, PDFAXMPProperty>();
    private Map<String, PDFAXMPType> types = new HashMap<String, PDFAXMPType>();
    private Map<String, Set<PDFAXMPType>> typesByURI = new HashMap<String, Set<PDFAXMPType>>();

    private static final <T> boolean equalObjects(T t1, T t2) {
        if (t1 == null) {
            return t2 == null;
        }
        if (t2 == null) {
            return false;
        }
        return t1.equals(t2);
    }

    public PDFAXMPSchema() {
    }

    public PDFAXMPSchema(PDFAXMPSchema otherSchema) {
        this(otherSchema.uri, otherSchema.prefix);
        this.setDescription(otherSchema.getDescription());
        this.mergeSchema(otherSchema);
    }

    public PDFAXMPSchema(String uri, String prefix) {
        this();
        this.setURI(uri);
        this.setPrefix(prefix);
    }

    public PDFAXMPSchema(String uri, String prefix, String description) {
        this(uri, prefix);
        this.setDescription(description);
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri.trim();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix.trim();
    }

    public boolean getPrefixIsRequired() {
        return this.prefixIsRequired;
    }

    public void setPrefixIsRequired(boolean prefixRequired) {
        this.prefixIsRequired = prefixRequired;
    }

    public String getDescription() {
        return this.schema;
    }

    public void setDescription(String schema) {
        this.schema = schema;
    }

    public Map<String, PDFAXMPProperty> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public PDFAXMPProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public void addProperty(PDFAXMPProperty property) {
        this.properties.put(property.getName(), property);
    }

    public Map<String, PDFAXMPType> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    public PDFAXMPType getType(String type) {
        return this.types.get(type);
    }

    public Map<String, Set<PDFAXMPType>> getTypesByURI() {
        return Collections.unmodifiableMap(this.typesByURI);
    }

    public Set<PDFAXMPType> getTypeByURI(String uri) {
        Set<PDFAXMPType> typeSet = this.typesByURI.get(uri);
        if (typeSet == null) {
            return null;
        }
        return Collections.unmodifiableSet(typeSet);
    }

    public void addType(PDFAXMPType type) {
        this.types.put(type.getType(), type);
        Set<PDFAXMPType> typeSet = this.typesByURI.get(type.getURI());
        if (typeSet == null) {
            typeSet = new HashSet<PDFAXMPType>();
            this.typesByURI.put(type.getURI(), typeSet);
        }
        typeSet.add(type);
    }

    public boolean mergeSchema(PDFAXMPSchema otherSchema) {
        boolean changed = false;
        if (otherSchema == null) {
            return changed;
        }
        if (!otherSchema.getURI().equals(this.getURI())) {
            return false;
        }
        for (PDFAXMPProperty otherProperty : otherSchema.properties.values()) {
            PDFAXMPProperty property = this.getProperty(otherProperty.getName());
            if (property != null) {
                changed |= property.mergeProperty(otherProperty);
                continue;
            }
            property = new PDFAXMPProperty(otherProperty);
            this.addProperty(property);
        }
        for (PDFAXMPType otherType : otherSchema.types.values()) {
            PDFAXMPType type = this.getType(otherType.getType());
            if (type != null) {
                changed |= type.mergeType(otherType);
                continue;
            }
            type = new PDFAXMPType(otherType);
            this.addType(type);
        }
        return changed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.prefix);
        builder.append(", ");
        builder.append(this.uri);
        builder.append("]");
        builder.append("\n\tproperties = ");
        ArrayList<PDFAXMPProperty> propertyList = new ArrayList<PDFAXMPProperty>(this.properties.values());
        Collections.sort(propertyList);
        for (PDFAXMPProperty property : propertyList) {
            builder.append("\n");
            builder.append("\t\t");
            builder.append(property);
        }
        builder.append("\n\ttypes = ");
        ArrayList<PDFAXMPType> typeList = new ArrayList<PDFAXMPType>(this.types.values());
        Collections.sort(typeList);
        for (PDFAXMPType type : typeList) {
            builder.append("\n");
            builder.append("\t\t");
            builder.append(type);
        }
        builder.append("\n");
        return builder.toString();
    }

    public void writeXML(ContentHandler handler, NamespaceSupport namespaceSupport) throws SAXException {
        AttributesImpl parsetypeAttribute;
        if (this.schema != null) {
            SchemaCollector.PDFA_SCHEMA_SCHEMA.startElement(handler, namespaceSupport);
            XMLUtils.outputChars(handler, this.getDescription());
            SchemaCollector.PDFA_SCHEMA_SCHEMA.endElement(handler, namespaceSupport);
        }
        SchemaCollector.PDFA_SCHEMA_NAMESPACEURI.startElement(handler, namespaceSupport);
        XMLUtils.outputChars(handler, this.getURI());
        SchemaCollector.PDFA_SCHEMA_NAMESPACEURI.endElement(handler, namespaceSupport);
        SchemaCollector.PDFA_SCHEMA_PREFIX.startElement(handler, namespaceSupport);
        XMLUtils.outputChars(handler, this.getPrefix());
        SchemaCollector.PDFA_SCHEMA_PREFIX.endElement(handler, namespaceSupport);
        if (!this.properties.isEmpty()) {
            SchemaCollector.PDFA_SCHEMA_PROPERTY.startElement(handler, namespaceSupport);
            SchemaCollector.RDF_SEQ.startElement(handler, namespaceSupport);
            for (PDFAXMPProperty property : this.properties.values()) {
                parsetypeAttribute = new AttributesImpl();
                parsetypeAttribute.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", XMLUtils.getQualifiedName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", namespaceSupport), "CDATA", "Resource");
                SchemaCollector.RDF_LI.startElement(handler, namespaceSupport, parsetypeAttribute);
                property.writeXML(handler, namespaceSupport);
                SchemaCollector.RDF_LI.endElement(handler, namespaceSupport);
            }
            SchemaCollector.RDF_SEQ.endElement(handler, namespaceSupport);
            SchemaCollector.PDFA_SCHEMA_PROPERTY.endElement(handler, namespaceSupport);
        }
        if (!this.types.isEmpty()) {
            SchemaCollector.PDFA_SCHEMA_VALUETYPE.startElement(handler, namespaceSupport);
            SchemaCollector.RDF_SEQ.startElement(handler, namespaceSupport);
            for (PDFAXMPType type : this.types.values()) {
                parsetypeAttribute = new AttributesImpl();
                parsetypeAttribute.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", XMLUtils.getQualifiedName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", namespaceSupport), "CDATA", "Resource");
                SchemaCollector.RDF_LI.startElement(handler, namespaceSupport, parsetypeAttribute);
                type.writeXML(handler, namespaceSupport);
                SchemaCollector.RDF_LI.endElement(handler, namespaceSupport);
            }
            SchemaCollector.RDF_SEQ.endElement(handler, namespaceSupport);
            SchemaCollector.PDFA_SCHEMA_VALUETYPE.endElement(handler, namespaceSupport);
        }
    }

    public boolean isValid() {
        boolean valid = true;
        if (this.getURI() == null || this.getURI().equals("")) {
            valid = false;
        }
        if (this.getPrefix() == null || this.getPrefix().equals("")) {
            valid = false;
        }
        return valid;
    }

    public static final class PDFAXMPField
    implements Serializable,
    Comparable<Object> {
        private static final long serialVersionUID = 1L;
        private String name;
        private String valueType;
        private String description;

        public PDFAXMPField() {
        }

        public PDFAXMPField(PDFAXMPField otherField) {
            this.name = otherField.name;
            this.valueType = otherField.valueType;
            this.description = otherField.description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name.trim();
        }

        public String getvalueType() {
            return this.valueType;
        }

        public void setValueType(String valueType) {
            this.valueType = valueType.trim();
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[");
            buffer.append(this.name);
            buffer.append(", ");
            buffer.append(this.valueType);
            buffer.append("]");
            return buffer.toString();
        }

        @Override
        public int compareTo(Object o) {
            return this.compareTo((PDFAXMPType)o);
        }

        @Override
        public int compareTo(PDFAXMPType o) {
            return this.name.compareTo(o.type);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof PDFAXMPField)) {
                return false;
            }
            PDFAXMPField otherField = (PDFAXMPField)other;
            if (!PDFAXMPSchema.equalObjects(this.name, otherField.name)) {
                return false;
            }
            return PDFAXMPSchema.equalObjects(this.valueType, otherField.valueType);
        }

        public int hashCode() {
            return this.name.hashCode() * 31 ^ (this.valueType == null ? 0 : this.valueType.hashCode());
        }

        public boolean isValid() {
            boolean valid = true;
            if (this.getName() == null || this.getName().equals("")) {
                valid = false;
            }
            if (this.getvalueType() == null || this.getvalueType().equals("")) {
                valid = false;
            }
            if (this.getDescription() == null || this.getDescription().equals("")) {
                valid = false;
            }
            return valid;
        }

        public void writeXML(ContentHandler handler, NamespaceSupport namespaceSupport) throws SAXException {
            SchemaCollector.PDFA_SCHEMA_FIELD_NAME.startElement(handler, namespaceSupport);
            XMLUtils.outputChars(handler, this.getName());
            SchemaCollector.PDFA_SCHEMA_FIELD_NAME.endElement(handler, namespaceSupport);
            SchemaCollector.PDFA_SCHEMA_FIELD_VALUETYPE.startElement(handler, namespaceSupport);
            XMLUtils.outputChars(handler, this.getvalueType());
            SchemaCollector.PDFA_SCHEMA_FIELD_VALUETYPE.endElement(handler, namespaceSupport);
            if (this.description != null) {
                SchemaCollector.PDFA_SCHEMA_FIELD_DESCRIPTION.startElement(handler, namespaceSupport);
                XMLUtils.outputChars(handler, this.getDescription());
                SchemaCollector.PDFA_SCHEMA_FIELD_DESCRIPTION.endElement(handler, namespaceSupport);
            }
        }
    }

    public static final class PDFAXMPType
    implements Serializable,
    Comparable<Object> {
        private static final long serialVersionUID = 1L;
        private String type;
        private String uri;
        private String prefix;
        private boolean prefixIsRequired = false;
        private String description;
        private Map<String, PDFAXMPField> fields = new HashMap<String, PDFAXMPField>();

        public PDFAXMPType() {
        }

        public PDFAXMPType(PDFAXMPType otherType) {
            this();
            this.type = otherType.type;
            this.uri = otherType.uri;
            this.prefix = otherType.prefix;
            this.description = otherType.description;
            for (PDFAXMPField otherField : otherType.fields.values()) {
                PDFAXMPField field = new PDFAXMPField(otherField);
                this.addField(field);
            }
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type.trim();
        }

        public String getURI() {
            return this.uri;
        }

        public void setURI(String uri) {
            this.uri = uri.trim();
        }

        public String getPrefix() {
            return this.prefix.trim();
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix.trim();
        }

        public boolean getPrefixIsRequired() {
            return this.prefixIsRequired;
        }

        public void setPrefixIsRequired(boolean prefixRequired) {
            this.prefixIsRequired = prefixRequired;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void addField(PDFAXMPField field) {
            this.fields.put(field.getName(), field);
        }

        public Map<String, PDFAXMPField> getFields() {
            return Collections.unmodifiableMap(this.fields);
        }

        public PDFAXMPField getField(String name) {
            return this.fields.get(name);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(this.type);
            builder.append(", ");
            builder.append(this.prefix);
            builder.append(", ");
            builder.append(this.uri);
            builder.append("]");
            builder.append("\n\t fields = ");
            builder.append(this.fields);
            return builder.toString();
        }

        @Override
        public int compareTo(Object o) {
            return this.compareTo((PDFAXMPType)o);
        }

        @Override
        public int compareTo(PDFAXMPType o) {
            return this.type.compareTo(o.type);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof PDFAXMPType)) {
                return false;
            }
            PDFAXMPType otherType = (PDFAXMPType)other;
            if (!PDFAXMPSchema.equalObjects(this.prefix, otherType.prefix)) {
                return false;
            }
            if (!PDFAXMPSchema.equalObjects(this.type, otherType.type)) {
                return false;
            }
            return PDFAXMPSchema.equalObjects(this.uri, otherType.uri);
        }

        public int hashCode() {
            return (this.prefix.hashCode() * 31 ^ this.type.hashCode()) * 31 ^ this.uri.hashCode();
        }

        public void writeXML(ContentHandler handler, NamespaceSupport namespaceSupport) throws SAXException {
            SchemaCollector.PDFA_SCHEMA_TYPE_TYPE.startElement(handler, namespaceSupport);
            XMLUtils.outputChars(handler, this.getType());
            SchemaCollector.PDFA_SCHEMA_TYPE_TYPE.endElement(handler, namespaceSupport);
            SchemaCollector.PDFA_SCHEMA_TYPE_NAMESPACEURI.startElement(handler, namespaceSupport);
            XMLUtils.outputChars(handler, this.getURI());
            SchemaCollector.PDFA_SCHEMA_TYPE_NAMESPACEURI.endElement(handler, namespaceSupport);
            SchemaCollector.PDFA_SCHEMA_TYPE_PREFIX.startElement(handler, namespaceSupport);
            XMLUtils.outputChars(handler, this.getPrefix());
            SchemaCollector.PDFA_SCHEMA_TYPE_PREFIX.endElement(handler, namespaceSupport);
            SchemaCollector.PDFA_SCHEMA_TYPE_DESCRIPTION.startElement(handler, namespaceSupport);
            XMLUtils.outputChars(handler, this.getDescription());
            SchemaCollector.PDFA_SCHEMA_TYPE_DESCRIPTION.endElement(handler, namespaceSupport);
            if (!this.fields.isEmpty()) {
                SchemaCollector.PDFA_SCHEMA_TYPE_FIELD.startElement(handler, namespaceSupport);
                SchemaCollector.RDF_SEQ.startElement(handler, namespaceSupport);
                AttributesImpl parsetypeAttribute = new AttributesImpl();
                parsetypeAttribute.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", XMLUtils.getQualifiedName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", namespaceSupport), "CDATA", "Resource");
                for (PDFAXMPField field : this.fields.values()) {
                    SchemaCollector.RDF_LI.startElement(handler, namespaceSupport, parsetypeAttribute);
                    field.writeXML(handler, namespaceSupport);
                    SchemaCollector.RDF_LI.endElement(handler, namespaceSupport);
                }
                SchemaCollector.RDF_SEQ.endElement(handler, namespaceSupport);
                SchemaCollector.PDFA_SCHEMA_TYPE_FIELD.endElement(handler, namespaceSupport);
            }
        }

        public boolean isValid() {
            boolean valid = true;
            if (this.getType() == null || this.getType().equals("")) {
                valid = false;
            }
            if (this.getURI() == null || this.getURI().equals("")) {
                valid = false;
            }
            if (this.getPrefix() == null || this.getPrefix().equals("")) {
                valid = false;
            }
            if (this.getDescription() == null || this.getDescription().equals("")) {
                valid = false;
            }
            return valid;
        }

        public boolean mergeType(PDFAXMPType otherType) {
            boolean changed = false;
            if (otherType == null) {
                return changed;
            }
            if (!this.getURI().equals(otherType.getURI())) {
                return changed;
            }
            for (PDFAXMPField otherField : otherType.fields.values()) {
                PDFAXMPField field = this.getField(otherField.getName());
                if (field != null) continue;
                field = new PDFAXMPField(otherField);
                this.addField(field);
            }
            if (this.description == null || this.description.length() == 0) {
                this.setDescription(otherType.getDescription());
                changed = true;
            }
            return changed;
        }
    }

    public static final class PDFAXMPProperty
    implements Serializable,
    Comparable<Object> {
        private static final long serialVersionUID = 1L;
        private String name;
        private String valueType;
        private Category category = Category.INTERNAL;
        private String description;

        public PDFAXMPProperty() {
        }

        public PDFAXMPProperty(String name, String valueType, Category category, String description) {
            this.name = name.trim();
            this.valueType = valueType.trim();
            this.category = category;
            this.description = description;
        }

        public PDFAXMPProperty(PDFAXMPProperty otherProperty) {
            this.name = otherProperty.name;
            this.valueType = otherProperty.valueType;
            this.category = otherProperty.category;
            this.description = otherProperty.description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name.trim();
        }

        public String getType() {
            return this.valueType;
        }

        public void setType(String type) {
            this.valueType = type.trim();
        }

        public Category getCategory() {
            return this.category;
        }

        public void setCategory(Category category) {
            this.category = category;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(this.name);
            builder.append(", ");
            builder.append(this.valueType);
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int compareTo(Object o) {
            return this.compareTo((PDFAXMPProperty)o);
        }

        @Override
        public int compareTo(PDFAXMPProperty o) {
            return this.name.compareTo(o.name);
        }

        public void writeXML(ContentHandler handler, NamespaceSupport namespaceSupport) throws SAXException {
            SchemaCollector.PDFA_SCHEMA_PROPERTY_NAME.startElement(handler, namespaceSupport);
            XMLUtils.outputChars(handler, this.getName());
            SchemaCollector.PDFA_SCHEMA_PROPERTY_NAME.endElement(handler, namespaceSupport);
            if (this.valueType != null) {
                SchemaCollector.PDFA_SCHEMA_PROPERTY_TYPE.startElement(handler, namespaceSupport);
                XMLUtils.outputChars(handler, this.getType());
                SchemaCollector.PDFA_SCHEMA_PROPERTY_TYPE.endElement(handler, namespaceSupport);
            }
            SchemaCollector.PDFA_SCHEMA_PROPERTY_CATEGORY.startElement(handler, namespaceSupport);
            XMLUtils.outputChars(handler, this.getCategory().toString());
            SchemaCollector.PDFA_SCHEMA_PROPERTY_CATEGORY.endElement(handler, namespaceSupport);
            if (this.description != null) {
                SchemaCollector.PDFA_SCHEMA_PROPERTY_DESCRIPTION.startElement(handler, namespaceSupport);
                XMLUtils.outputChars(handler, this.getDescription());
                SchemaCollector.PDFA_SCHEMA_PROPERTY_DESCRIPTION.endElement(handler, namespaceSupport);
            }
        }

        public boolean isValid() {
            boolean valid = true;
            if (this.getName() == null || this.getName().equals("")) {
                valid = false;
            }
            if (this.getType() == null || this.getType().equals("")) {
                valid = false;
            }
            if (this.getCategory() == null) {
                valid = false;
            }
            if (this.getDescription() == null || this.getDescription().equals("")) {
                valid = false;
            }
            return valid;
        }

        public boolean mergeProperty(PDFAXMPProperty otherProperty) {
            boolean changed = false;
            if (otherProperty == null || this.compareTo(otherProperty) != 0) {
                return changed;
            }
            if (this.description == null || this.description.length() == 0) {
                this.setDescription(otherProperty.getDescription());
                changed = true;
            }
            if (this.valueType == null || this.valueType.length() == 0) {
                this.setType(otherProperty.getType());
                changed = true;
            }
            return changed;
        }

        public static enum Category {
            INTERNAL("internal"),
            EXTERNAL("external");

            private String name;

            private Category(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }

            public static Category parse(String name) {
                if (Category.INTERNAL.name.compareToIgnoreCase(name) == 0) {
                    return INTERNAL;
                }
                if (Category.EXTERNAL.name.compareToIgnoreCase(name) == 0) {
                    return EXTERNAL;
                }
                return null;
            }
        }
    }
}

