/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optionalcontent.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCBaseState;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderList;
import java.util.HashSet;

class OCConfig
extends PDFOCConfig {
    private OCConfig(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static OCConfig getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        OCConfig pdfObject = (OCConfig)PDFCosObject.getCachedInstance(cosObject, OCConfig.class);
        if (pdfObject == null) {
            pdfObject = new OCConfig(cosObject);
        }
        return pdfObject;
    }

    public boolean isDynamic() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCBaseState baseState = this.getBaseState();
        if (baseState != null && baseState.isEqual(PDFOCBaseState.OFF)) {
            return false;
        }
        PDFOCOrderList orderList = this.getOrderList();
        if (orderList == null) {
            return false;
        }
        PDFOCGroupArray offOCGroupList = this.getOFFList();
        if (offOCGroupList != null && offOCGroupList.size() > 0) {
            return false;
        }
        PDFOCGroupArray lockedList = this.getLocked();
        HashSet seenOCGs = new HashSet();
        return this.hasUnlockedOCG(orderList, lockedList, seenOCGs);
    }

    private boolean hasUnlockedOCG(PDFOCOrderList orderList, PDFOCGroupArray lockedList, HashSet seenOCGs) {
        if (seenOCGs.contains(orderList)) {
            return false;
        }
        seenOCGs.add(orderList);
        if (lockedList == null) {
            return false;
        }
        for (Object orderListItem : orderList) {
            if (!(orderListItem instanceof PDFOCGroup ? !lockedList.contains(orderListItem) : orderListItem instanceof PDFOCOrderList && this.hasUnlockedOCG((PDFOCOrderList)orderListItem, lockedList, seenOCGs))) continue;
            return true;
        }
        return false;
    }
}

