/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GlyphAbsoluteOutlineGenerator;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.FontSuperSetCheck;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

class GlyphComparator {
    GlyphComparator() {
    }

    public boolean compareGlyph(int gid1, FontData fontData1, Font f1, int gid2, FontData fontData2, Font f2) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        GeneralPath g2;
        Area a2;
        GeneralPath g1 = this.getGlyphsOulines(gid1, fontData1);
        Area a1 = new Area(g1);
        if (!a1.equals(a2 = new Area(g2 = this.getGlyphsOulines(gid2, fontData2)))) {
            return false;
        }
        if (a1.isEmpty()) {
            double w2;
            double w1 = f1.getPDFFontDescription().getAdvance(gid1);
            double diff = Math.abs(w1 - (w2 = f2.getPDFFontDescription().getAdvance(gid2)));
            return diff < 1.0;
        }
        return true;
    }

    public GeneralPath getGlyphsOulines(int gid, FontData fontData) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        GlyphAbsoluteOutlineGenerator glyphOutlineGenerator = new GlyphAbsoluteOutlineGenerator(null);
        fontData.getGlyphOutline(gid, glyphOutlineGenerator);
        GeneralPath glyphOutline = glyphOutlineGenerator.getOutline();
        return glyphOutline;
    }

    public static void main(String[] args) throws Exception {
        String fontPath1 = "E:/softwares/tx/CENTURY.TTF";
        String fontPath2 = "E:/softwares/tx/f1";
        File f1 = new File(fontPath1);
        File f2 = new File(fontPath2);
        FileInputStream is1 = new FileInputStream(f1);
        FileInputStream is2 = new FileInputStream(f2);
        FontLoader fl = new FontLoader();
        Font font1 = fl.load(is1, (int)f1.length(), true);
        Font font2 = fl.load(is2, (int)f2.length(), true);
        System.out.println(font1.getClass());
        System.out.println(font2.getClass());
        FontData fd1 = ((FontImpl)font1).getFontData();
        FontData fd2 = ((FontImpl)font2).getFontData();
        GlyphComparator gc = new GlyphComparator();
        System.out.println(fd2.getNumGlyphs());
        FontSuperSetCheck fcCheck = new FontSuperSetCheck(font2);
        for (int g1 = 0; g1 < fd2.getNumGlyphs(); ++g1) {
            System.out.println("Comparing glyph id : " + g1 + " " + gc.compareGlyph(g1, fd1, font1, g1, fd2, font2));
            gc.compareGlyph(g1, fd1, font1, g1, fd2, font2);
        }
        ((InputStream)is1).close();
        ((InputStream)is2).close();
        System.out.println("Done");
    }
}

