/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCosFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFToUnicodeCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.ContentRewriteInfo;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.FontSuperSetCheck;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.SimpleTypeEmbedder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class FontReEmbedder {
    private static final double WIDTH_TOLERANCE = 1.0;
    private Font afeFont;
    private ArrayList<PDFFont> pdffonts;
    private HashMap<CosDictionary, HashMap<Integer, Integer>> perFontDictOldCharCodeToOldglyphIdMap;
    private HashMap<CosDictionary, HashMap<Integer, int[]>> perFontDictOldCharCodeToUnicodeValueMap;
    private PDFFontFile pdfFontFile;
    private PDFCIDFontWidths pdfCIDFontWidths;
    private Subset fontSubset;
    private PDFToUnicodeCMap toUnicodeCMap;
    private HashMap<CosDictionary, ContentRewriteInfo> rewriteInfoMap;
    private HashSet<CosDictionary> simpleTypeFonts;
    private HashMap<CosDictionary, HashMap<Integer, Integer>> perFontOldGlyphIdToNewGlyphIdMap;
    private PDFFontDescription afeFontDesc;

    public FontReEmbedder(Font afeFont) throws PDFInvalidDocumentException {
        this.afeFont = afeFont;
        this.pdffonts = new ArrayList();
        this.perFontDictOldCharCodeToOldglyphIdMap = new HashMap();
        this.perFontDictOldCharCodeToUnicodeValueMap = new HashMap();
        this.rewriteInfoMap = new HashMap();
        this.perFontOldGlyphIdToNewGlyphIdMap = new HashMap();
        this.simpleTypeFonts = new HashSet();
        try {
            this.afeFontDesc = afeFont.getPDFFontDescription();
        }
        catch (Exception e) {
            throw new PDFInvalidDocumentException("Exception occured while getting PDFFontdescription.", e);
        }
    }

    public void addPDFFont(PDFFont pdfFont, HashMap<Integer, Integer> oldCharCodeToOldglyphIdMap, HashMap<Integer, int[]> charCodeToUnicodesMap) {
        this.pdffonts.add(pdfFont);
        HashMap<Integer, Integer> mapping = this.perFontDictOldCharCodeToOldglyphIdMap.get(pdfFont.getCosDictionary());
        if (mapping == null) {
            mapping = new HashMap();
            this.perFontDictOldCharCodeToOldglyphIdMap.put(pdfFont.getCosDictionary(), mapping);
        }
        mapping.putAll(oldCharCodeToOldglyphIdMap);
        HashMap<Integer, Object> unicodeMapping = this.perFontDictOldCharCodeToUnicodeValueMap.get(pdfFont.getCosDictionary());
        if (unicodeMapping == null) {
            unicodeMapping = new HashMap();
            this.perFontDictOldCharCodeToUnicodeValueMap.put(pdfFont.getCosDictionary(), unicodeMapping);
        }
        unicodeMapping.putAll(charCodeToUnicodesMap);
    }

    public void rembed(FontSuperSetCheck fcheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        if (this.pdffonts.size() <= 1) {
            return;
        }
        for (PDFFont font : this.pdffonts) {
            String newName = PDFFontUtils.getActualBaseFontName(font);
            this.unEmbedFont(font);
            try {
                if (font instanceof PDFFontType0) {
                    this.embedFontSubset((PDFFontType0)font, newName, fcheck);
                    continue;
                }
                if (!(font instanceof PDFFontSimple)) continue;
                this.embedFontSubset((PDFFontSimple)font, newName, fcheck);
            }
            catch (InvalidFontException e) {
                throw new PDFInvalidDocumentException("Exception occured while embedding font " + font, e);
            }
            catch (UnsupportedFontException e) {
                throw new PDFInvalidDocumentException("Exception occured while embedding font " + font, e);
            }
            catch (FontLoadingException e) {
                throw new PDFInvalidDocumentException("Exception occured while embedding font " + font, e);
            }
            catch (Exception e) {
                throw new PDFIOException("Exception occured while embedding font " + font, e);
            }
        }
    }

    private void embedFontSubset(PDFFontSimple font, String newName, FontSuperSetCheck fcheck) throws IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, FontEngineException {
        ContentRewriteInfo crInfo = new ContentRewriteInfo(font);
        this.rewriteInfoMap.put(font.getCosDictionary(), crInfo);
        this.simpleTypeFonts.add(font.getCosDictionary());
        if (this.pdfCIDFontWidths == null) {
            this.pdfCIDFontWidths = PDFCIDFontWidths.newInstance(font.getPDFDocument());
        }
        if (this.fontSubset == null) {
            this.createFontSubset(fcheck, font, 1000);
        }
        crInfo.setOldGlyphIdToNewGlyphIdMap(this.perFontOldGlyphIdToNewGlyphIdMap.get(font.getCosObject()));
        crInfo.setPerFontDictOldCharCodeToOldglyphIdMap(this.perFontDictOldCharCodeToOldglyphIdMap);
        SimpleTypeEmbedder.embedSimpleFontsAsType0Font(this.afeFont, font, this.fontSubset, this.pdfFontFile, this.pdfCIDFontWidths, newName);
        font.setToUnicodeCMap(this.toUnicodeCMap);
    }

    private void embedFontSubset(PDFFontType0 font, String newName, FontSuperSetCheck fcheck) throws InvalidFontException, UnsupportedFontException, FontLoadingException, IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ContentRewriteInfo crInfo = new ContentRewriteInfo(font);
        this.rewriteInfoMap.put(font.getCosDictionary(), crInfo);
        if (this.pdfCIDFontWidths == null) {
            this.pdfCIDFontWidths = PDFCIDFontWidths.newInstance(font.getPDFDocument());
        }
        font.setToUnicodeCMap(null);
        if (this.fontSubset == null) {
            this.createFontSubset(fcheck, font, font.getDescendantFont().getDW());
        }
        font.setToUnicodeCMap(this.toUnicodeCMap);
        crInfo.setOldGlyphIdToNewGlyphIdMap(this.perFontOldGlyphIdToNewGlyphIdMap.get(font.getCosObject()));
        crInfo.setPerFontDictOldCharCodeToOldglyphIdMap(this.perFontDictOldCharCodeToOldglyphIdMap);
        ASName subsetFontName = PDFFontUtils.generateSubsetFontName(this.fontSubset, newName);
        PDFFontDescriptor descriptor = font.getFontDescriptor();
        descriptor.setFontFile2(this.pdfFontFile);
        font.setBaseFont(subsetFontName);
        PDFCIDFont cidFont = font.getDescendantFont();
        cidFont.setBaseFont(subsetFontName);
        cidFont.setW(this.pdfCIDFontWidths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFontSubset(FontSuperSetCheck fCheck, PDFFont font, int dw) throws InvalidFontException, UnsupportedFontException, FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException {
        double[] dWidths = new double[1];
        this.fontSubset = this.afeFont.createSubset();
        TreeMap<Integer, byte[]> unicodeMap = new TreeMap<Integer, byte[]>();
        for (Map.Entry<CosDictionary, HashMap<Integer, Integer>> fEntry : this.perFontDictOldCharCodeToOldglyphIdMap.entrySet()) {
            CosDictionary fontCosDict = fEntry.getKey();
            HashMap<Integer, Integer> oldGlyphIdToNewGlyphIdMap = new HashMap<Integer, Integer>();
            this.perFontOldGlyphIdToNewGlyphIdMap.put(fontCosDict, oldGlyphIdToNewGlyphIdMap);
            HashMap<Integer, Integer> charCodeToGlyphMappings = fEntry.getValue();
            HashMap<Integer, int[]> fUnicodeMap = this.perFontDictOldCharCodeToUnicodeValueMap.get(fontCosDict);
            for (Map.Entry<Integer, Integer> entry : charCodeToGlyphMappings.entrySet()) {
                byte[] uniBytes;
                Integer glyphId = entry.getValue();
                Integer charCode = entry.getKey();
                Integer fullGid = fCheck.getFullFontGid(fontCosDict, glyphId);
                int newId = this.fontSubset.getSubsetGid(fullGid);
                oldGlyphIdToNewGlyphIdMap.put(glyphId, newId);
                dWidths[0] = this.afeFontDesc.getAdvance(fullGid);
                if (Math.abs(dWidths[0] - (double)dw) > 1.0) {
                    this.pdfCIDFontWidths.addWidths(dWidths, newId, newId);
                }
                if (fUnicodeMap == null || (uniBytes = FontReEmbedder.getByteArrayForUnicodes(fUnicodeMap.get(charCode))) == null) continue;
                unicodeMap.put(newId, uniBytes);
            }
        }
        FontResources.createToUnicodeCMap(font, unicodeMap);
        this.toUnicodeCMap = font.getToUnicodeCMap();
        OutputByteStream outStream = null;
        try {
            outStream = font.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            FontResources.getSubsettedCIDFontStream(this.afeFont, outStream.toOutputStream(), this.fontSubset, true);
        }
        finally {
            if (outStream != null) {
                InputByteStream fontFileStream = outStream.closeAndConvert();
                outStream = null;
                this.pdfFontFile = PDFFontFile.newInstance(font.getPDFDocument(), fontFileStream);
                PDFFilterFlate filter = PDFFilterFlate.newInstance(this.pdfFontFile.getPDFDocument(), null);
                this.pdfFontFile.setFilter(filter);
                fontFileStream = null;
            }
        }
    }

    private static byte[] getByteArrayForUnicodes(int[] intUnicodes) {
        if (intUnicodes == null) {
            return null;
        }
        char[] chars = new char[intUnicodes.length];
        for (int i = 0; i < intUnicodes.length; ++i) {
            chars[i] = (char)intUnicodes[i];
        }
        try {
            return new String(chars).getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private void unEmbedFont(PDFFont pdfFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosCloneMgr cloneManager = new CosCloneMgr(pdfFont.getPDFDocument().getCosDocument());
        PDFCosFontDescriptor cosDescriptor = pdfFont.getFontDescriptor().getPDFCosDescriptor();
        CosDictionary cloneFontDescriptor = (CosDictionary)cloneManager.clone(cosDescriptor.getCosObject());
        PDFFontDescriptor newFontDescriptor = PDFFontDescriptor.getInstance(cloneFontDescriptor);
        if (pdfFont instanceof PDFFontType0) {
            PDFCIDFont cidFont = ((PDFFontType0)pdfFont).getDescendantFont();
            cidFont.setDictionaryNameValue(ASName.k_CIDToGIDMap, ASName.k_Identity);
            try {
                cidFont.setFontDescriptor(newFontDescriptor);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Exception occured while setting fontdescriptor.", e);
            }
        } else if (pdfFont instanceof PDFFontSimple) {
            ((PDFFontSimple)pdfFont).setFontDescriptor(newFontDescriptor);
            pdfFont.resetAFEFont();
        }
        cloneFontDescriptor.remove(ASName.k_CharSet);
        cloneFontDescriptor.remove(ASName.k_CIDSet);
        cloneFontDescriptor.remove(ASName.k_FontFile);
        cloneFontDescriptor.remove(ASName.k_FontFile2);
        cloneFontDescriptor.remove(ASName.k_FontFile3);
    }

    public HashMap<CosDictionary, ContentRewriteInfo> getRewriteInfoMap() {
        return this.rewriteInfoMap;
    }

    public HashSet<CosDictionary> getSimpleTypeFonts() {
        return this.simpleTypeFonts;
    }
}

