/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources.subsetting;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFEncodingDifferences;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.FontSubsetter;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.SubsetUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class Type1FontSubsetter
extends FontSubsetter {
    protected Map<PDFEncodingDifferences, List<PDFFont>> fontEncodingToFontInfoMap = new HashMap<PDFEncodingDifferences, List<PDFFont>>();

    public Type1FontSubsetter(PDFDocument pdfDoc, Map<PDFFont, TreeMap<Integer, Integer>> fontToCharCodesMap) {
        super(pdfDoc, fontToCharCodesMap);
    }

    @Override
    protected void populateFontInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        for (Map.Entry fontToCharCodesEntry : this.fontToCharCodesMap.entrySet()) {
            PDFFont pdfFont = (PDFFont)fontToCharCodesEntry.getKey();
            PDFFontDescriptor fontDescriptor = pdfFont.getFontDescriptor();
            PDFFontFile fontFile = PDFFontUtils.getFontFileFromFontDescriptor(fontDescriptor);
            Type1FontInfo fontInfo = null;
            fontInfo = this.fontFileToFontInfoMap.containsKey(fontFile) ? (Type1FontInfo)this.fontFileToFontInfoMap.get(fontFile) : new Type1FontInfo();
            if (fontInfo.getFont() == null) {
                try {
                    fontInfo.setFont(pdfFont.getAFEFont());
                }
                catch (FontLoadingException e) {
                    throw new PDFFontException(e);
                }
            }
            fontInfo.getPDFFontDescSet().add(fontDescriptor);
            this.addGlyphNames((PDFFontSimple)pdfFont, fontInfo.getGlyphNamesSet(), ((TreeMap)fontToCharCodesEntry.getValue()).keySet());
            this.fontFileToFontInfoMap.put(fontFile, fontInfo);
            PDFSimpleFontEncoding fontEncoding = ((PDFFontSimple)pdfFont).getEncoding();
            if (fontEncoding == null || fontEncoding.getDifferences() == null) continue;
            List<PDFFont> fontInfoList = this.fontEncodingToFontInfoMap.get(fontEncoding.getDifferences());
            if (fontInfoList == null) {
                fontInfoList = new ArrayList<PDFFont>();
            }
            fontInfoList.add(pdfFont);
            this.fontEncodingToFontInfoMap.put(fontEncoding.getDifferences(), fontInfoList);
        }
    }

    @Override
    protected void doSubsetting() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        for (Map.Entry fontFileToFontInfoEntry : this.fontFileToFontInfoMap.entrySet()) {
            PDFFontFile fontFile = (PDFFontFile)fontFileToFontInfoEntry.getKey();
            Type1FontInfo fontInfo = (Type1FontInfo)fontFileToFontInfoEntry.getValue();
            String[] glyphNames = fontInfo.getGlyphNamesSet().toArray(new String[0]);
            Font afeFont = fontInfo.getFont();
            this.subsetType1FontStream(fontFile.getPDFDocument(), glyphNames, afeFont, fontInfo.getPDFFontDescSet());
        }
        for (Map.Entry fontToCharCodeEntry : this.fontToCharCodesMap.entrySet()) {
            SubsetUtils.cleanUpSimpleFontDict((PDFFont)fontToCharCodeEntry.getKey(), (TreeMap)fontToCharCodeEntry.getValue(), this.fontEncodingToFontInfoMap);
        }
    }

    private void addGlyphNames(PDFFontSimple pdfFont, Set<String> glyphNames, Set<Integer> charCodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        for (int charCode : charCodes) {
            String glyphName = pdfFont.charCode2glyphName(charCode);
            if (glyphName.equals(".notdef")) continue;
            glyphNames.add(glyphName);
        }
    }

    private void subsetType1FontStream(PDFDocument pdfDoc, String[] glyphNames, Font afeFont, Set<PDFFontDescriptor> fontDescriptorSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        try {
            OutputByteStream subsetStream = pdfDoc.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, 1024L);
            FontResources.getSubsettedFontType1Stream(glyphNames, afeFont, subsetStream.toOutputStream());
            InputByteStream subsetInputStream = subsetStream.closeAndConvert();
            PDFFontFile fontFile = PDFFontFile.newInstance(pdfDoc);
            fontFile.getCosStream().newDataDecoded(subsetInputStream);
            fontFile.setFilter(PDFFilterFlate.newInstance(pdfDoc, null));
            fontFile.setEmbeddedFontType(PDFFontFile.EmbeddedFontType.Type1C);
            for (PDFFontDescriptor pdfFontDescriptor : fontDescriptorSet) {
                pdfFontDescriptor.setFontFile(null);
                pdfFontDescriptor.setFontFile2(null);
                pdfFontDescriptor.setFontFile3(fontFile);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException(e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException(e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException(e);
        }
    }

    private static class Type1FontInfo
    extends FontSubsetter.FontInfo {
        private Set<String> glyphNamesSet = new LinkedHashSet<String>();
        private Set<PDFFontDescriptor> pdfFontDescriptorSet = new LinkedHashSet<PDFFontDescriptor>();

        private Type1FontInfo() {
        }

        Set<String> getGlyphNamesSet() {
            return this.glyphNamesSet;
        }

        Set<PDFFontDescriptor> getPDFFontDescSet() {
            return this.pdfFontDescriptorSet;
        }
    }
}

