/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources.subsetting;

import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.FontSubsetter;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.TrueTypeFontSubsetter;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.Type0FontSubsetter;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.Type1FontSubsetter;
import java.util.Map;
import java.util.TreeMap;

public class FontSubsetterFactory {
    public static FontSubsetter getInstance(FontType fontType, PDFDocument pdfDoc, Map<PDFFont, TreeMap<Integer, Integer>> fontToCharCodesMap) {
        FontSubsetter fontSubsetter = null;
        switch (fontType) {
            case TRUETYPE: {
                fontSubsetter = new TrueTypeFontSubsetter(pdfDoc, fontToCharCodesMap);
                break;
            }
            case TYPE0: {
                fontSubsetter = new Type0FontSubsetter(pdfDoc, fontToCharCodesMap);
                break;
            }
            case TYPE1: {
                fontSubsetter = new Type1FontSubsetter(pdfDoc, fontToCharCodesMap);
            }
        }
        return fontSubsetter;
    }

    public static enum FontType {
        TYPE1,
        TRUETYPE,
        TYPE0;

    }
}

