/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.PDFSimpleFontValuesAccessor;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFEncodingDifferences;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontStretch;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.CharSetEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.MacRomanEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.StandardCharSetEncodings;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.StandardEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.WinAnsiEncoding;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PDFSimpleFontValuesAccessorImpl
extends PDFSimpleFontValuesAccessor {
    private PDFFontSimple mFont = null;
    private PDFFontDescriptor mFontDescr = null;
    private PDFSimpleFontEncoding mEncoding = null;
    private PDFEncodingDifferences mEncodingDiff = null;
    private int[] mWidthArray;
    private double mMissingWidth;
    private static final Pattern subsetPattern = Pattern.compile("[A-Z]{6}[+](.*)");

    public PDFSimpleFontValuesAccessorImpl(PDFDocument pdfDoc, PDFFontSimple font, PDFFontDescriptor fontDescr) throws InvalidFontException {
        this.mFont = font;
        this.mFontDescr = fontDescr;
        try {
            CharSetEncoding baseEncoding;
            PDFSimpleFontEncoding encodingObj = font.getEncoding();
            if (!(encodingObj == null || (baseEncoding = encodingObj.getBaseEncoding()) == null || baseEncoding instanceof MacRomanEncoding || baseEncoding instanceof WinAnsiEncoding || baseEncoding instanceof StandardEncoding)) {
                throw new InvalidFontException("Unable to create a simple font. Encoding " + baseEncoding.getName().asString(true) + " is not one of the standard base encoding for a simple font.");
            }
            if (encodingObj == null) {
                if ((fontDescr.getFlags() & 4) != 0) {
                    throw new InvalidFontException("Unable to create a simple font. Cannot find a base encoding for the symbolic font " + font.getBaseFont().asString(true) + ".");
                }
                encodingObj = PDFSimpleFontEncoding.newInstance(pdfDoc, StandardCharSetEncodings.get(ASName.k_StandardEncoding));
            }
            PDFEncodingDifferences diff = encodingObj.getDifferences();
            this.mEncoding = encodingObj;
            if (diff != null) {
                this.mEncodingDiff = diff;
            }
            this.mWidthArray = this.mFont.getWidths();
            this.mMissingWidth = this.mFontDescr.getMissingWidth();
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to create a simple font.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to create a simple font.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new InvalidFontException("Unable to create a simple font.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to create a simple font.", e);
        }
        catch (PDFInvalidParameterException e) {
            throw new InvalidFontException("Unable to create a simple font.", e);
        }
    }

    @Override
    public String getFontFamily() throws InvalidFontException, UnsupportedFontException {
        try {
            ASString n = this.mFontDescr.getFontFamily();
            return n == null ? null : n.toString();
        }
        catch (PDFInvalidDocumentException e) {
            return null;
        }
        catch (PDFIOException e) {
            return null;
        }
        catch (PDFUnsupportedFeatureException e) {
            return null;
        }
        catch (PDFSecurityException e) {
            return null;
        }
    }

    @Override
    public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
        try {
            String name = this.mFontDescr.getFontName().asString(true);
            Matcher m = subsetPattern.matcher(name);
            return m.matches() ? m.group(1) : name;
        }
        catch (PDFInvalidDocumentException e) {
            return null;
        }
        catch (PDFIOException e) {
            return null;
        }
        catch (PDFUnsupportedFeatureException e) {
            return null;
        }
        catch (PDFSecurityException e) {
            return null;
        }
    }

    @Override
    public String getGlyphName(int charCode) throws InvalidFontException, UnsupportedFontException {
        ASName glyphASName;
        String name = null;
        if (this.mEncodingDiff != null && (glyphASName = this.mEncodingDiff.toGlyphName(charCode)) != null) {
            name = glyphASName.asString(true);
        }
        if (name == null && this.mEncoding != null) {
            try {
                name = this.mEncoding.getGlyphName(charCode);
            }
            catch (PDFException e) {
                throw new UnsupportedFontException("Unable to get glyph name for character code " + charCode + ".", e);
            }
        }
        return name;
    }

    @Override
    public double getGlyphWidth(int charCode) throws InvalidFontException, UnsupportedFontException {
        try {
            int firstChar = this.mFont.getFirstChar();
            int lastChar = this.mFont.getLastChar();
            if (firstChar <= charCode && charCode <= lastChar && charCode - firstChar < this.mWidthArray.length) {
                return this.mWidthArray[charCode - firstChar];
            }
            return this.mMissingWidth;
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get Glyph width.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get Glyph width.", e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get Glyph width.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get Glyph width.", e);
        }
    }

    @Override
    public double getAscent() throws InvalidFontException, UnsupportedFontException {
        try {
            return this.mFontDescr.getAscent();
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font Ascent.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font Ascent.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font Ascent.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font Ascent.", e);
        }
    }

    @Override
    public double getDescent() throws InvalidFontException, UnsupportedFontException {
        try {
            return this.mFontDescr.getDescent();
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font Descent.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font Descent.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font Descent.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font Descent.", e);
        }
    }

    @Override
    public double getLeading() throws InvalidFontException, UnsupportedFontException {
        try {
            return this.mFontDescr.getLeading();
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font Leading.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font Leading.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font Leading.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font Leading.", e);
        }
    }

    @Override
    public double getCapHeight() throws InvalidFontException, UnsupportedFontException {
        try {
            return this.mFontDescr.getCapHeight();
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
    }

    @Override
    public double getXHeight() throws InvalidFontException, UnsupportedFontException {
        try {
            return this.mFontDescr.getXHeight();
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
    }

    @Override
    public int getFontWeight() throws InvalidFontException, UnsupportedFontException {
        try {
            return this.mFontDescr.getFontWeight();
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
    }

    private static CSS20Attribute.CSSStretchValue getCSSStretchValue(PDFFontStretch stretch) {
        if (stretch == PDFFontStretch.ULTRA_CONDENSED) {
            return CSS20Attribute.CSSStretchValue.ULTRACONDENSED;
        }
        if (stretch == PDFFontStretch.EXTRA_CONDENSED) {
            return CSS20Attribute.CSSStretchValue.EXTRACONDENSED;
        }
        if (stretch == PDFFontStretch.CONDENSED) {
            return CSS20Attribute.CSSStretchValue.CONDENSED;
        }
        if (stretch == PDFFontStretch.SEMI_CONDENSED) {
            return CSS20Attribute.CSSStretchValue.SEMICONDENSED;
        }
        if (stretch == PDFFontStretch.NORMAL) {
            return CSS20Attribute.CSSStretchValue.NORMAL;
        }
        if (stretch == PDFFontStretch.SEMI_EXPANDED) {
            return CSS20Attribute.CSSStretchValue.SEMIEXPANDED;
        }
        if (stretch == PDFFontStretch.EXPANDED) {
            return CSS20Attribute.CSSStretchValue.EXPANDED;
        }
        if (stretch == PDFFontStretch.EXTRA_EXPANDED) {
            return CSS20Attribute.CSSStretchValue.EXTRAEXPANDED;
        }
        if (stretch == PDFFontStretch.ULTRA_EXPANDED) {
            return CSS20Attribute.CSSStretchValue.ULTRAEXPANDED;
        }
        return CSS20Attribute.CSSStretchValue.NORMAL;
    }

    @Override
    public CSS20Attribute.CSSStretchValue getFontStretch() throws InvalidFontException, UnsupportedFontException {
        try {
            return PDFSimpleFontValuesAccessorImpl.getCSSStretchValue(this.mFontDescr.getFontStretch());
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font Cap Height.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font Cap Height.", e);
        }
    }

    @Override
    public int getFlags() throws InvalidFontException, UnsupportedFontException {
        try {
            return this.mFontDescr.getFlags();
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font flags.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font flags.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font flags.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font flags.", e);
        }
    }

    @Override
    public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
        try {
            ASRectangle bBox = this.mFontDescr.getFontBBox();
            if (bBox == null) {
                return null;
            }
            return new Rect(bBox.left(), bBox.bottom(), bBox.right(), bBox.top());
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font bounding box.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font bounding box.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font bounding box.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font bounding box.", e);
        }
    }

    @Override
    public double getItalicAngle() throws InvalidFontException, UnsupportedFontException {
        try {
            return this.mFontDescr.getItalicAngle();
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font italic angle.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font italic angle.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font italic angle.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font italic angle.", e);
        }
    }

    @Override
    public double getStemV() throws InvalidFontException, UnsupportedFontException {
        try {
            return this.mFontDescr.getStemV();
        }
        catch (PDFInvalidDocumentException e) {
            throw new InvalidFontException("Unable to get font StemV.", e);
        }
        catch (PDFIOException e) {
            throw new InvalidFontException("Unable to get font StemV.", e);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new UnsupportedFontException("Unable to get font StemV.", e);
        }
        catch (PDFSecurityException e) {
            throw new InvalidFontException("Unable to get font StemV.", e);
        }
    }
}

