/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.EnumeratedContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import java.security.cert.X509Certificate;

public final class UBCertParser {
    private X509Certificate ubCert;
    private static final String UBOID = "1.2.840.113583.1.1.7.1";
    private static final int formFillInAndSave = 7;
    private static final int formImportExport = 6;
    private static final int formAddDelete = 5;
    private static final int submitStandalone = 4;
    private static final int spawnTemplate = 3;
    private static final int signing = 2;
    private static final int annotModify = 1;
    private static final int annotImportExport = 0;
    private static final int barcodePlaintext = 7;
    private static final int annotOnline = 6;
    private static final int formOnline = 5;
    private static final int EFModify = 4;
    private boolean formFillInAndSaveEnabled = false;
    private boolean formImportExportEnabled = false;
    private boolean formAddDeleteEnabled = false;
    private boolean submitStandaloneEnabled = false;
    private boolean spawnTemplateEnabled = false;
    private boolean signingEnabled = false;
    private boolean annotModifyEnabled = false;
    private boolean annotImportExportEnabled = false;
    private boolean barcodePlainTextEnabled = false;
    private boolean annotOnlineEnabled = false;
    private boolean formOnlineEnabled = false;
    private boolean EFModifyEnabled = false;
    private boolean debug = false;
    private int version;
    private int deploymentMode;
    private byte[] subrights;

    public UBCertParser(X509Certificate ubCert) throws ASN_Exception {
        this.ubCert = ubCert;
        this.parse();
    }

    public int getVersion() {
        return this.version;
    }

    void setVersion(int version) {
        this.version = version;
    }

    public int getDeploymentMode() {
        return this.deploymentMode;
    }

    void setDeploymentMode(int deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public byte[] getSubrights() {
        return this.subrights;
    }

    void parse() throws ASN_Exception {
        this.parseUBCert(this.ubCert.getExtensionValue(UBOID));
    }

    private void parseUBCert(byte[] extensionValue) throws ASN_Exception {
        byte[] ubData;
        OctetStringContainer outerOctetContainer = new OctetStringContainer(0);
        ASN1Container[] asn1Definition = new ASN1Container[]{outerOctetContainer};
        ASN1.berDecode((byte[])extensionValue, (int)0, (ASN1Container[])asn1Definition);
        if (this.debug) {
            System.out.println("Outer Octet Container Data: " + new String(outerOctetContainer.data, outerOctetContainer.dataOffset, outerOctetContainer.dataLen));
        }
        if ((ubData = new byte[outerOctetContainer.dataLen]).length > 0) {
            System.arraycopy(outerOctetContainer.data, outerOctetContainer.dataOffset, ubData, 0, outerOctetContainer.dataLen);
        }
        SequenceContainer decodeContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        IntegerContainer versionContainer = new IntegerContainer(0);
        BitStringContainer subrightsContainer = new BitStringContainer(0, 12);
        EnumeratedContainer deploymentModeContainer = new EnumeratedContainer(0);
        ASN1Container[] ubDefinition = new ASN1Container[]{decodeContainer, versionContainer, subrightsContainer, deploymentModeContainer, endContainer};
        ASN1.berDecode((byte[])ubData, (int)0, (ASN1Container[])ubDefinition);
        this.setVersion(versionContainer.getValueAsInt());
        this.setDeploymentMode(deploymentModeContainer.getValueAsInt());
        if (this.debug) {
            System.out.println("Version - " + versionContainer.getValueAsInt());
            System.out.println("Deployment Mode - " + deploymentModeContainer.getValueAsInt());
        }
        byte[] subrightData = new byte[subrightsContainer.dataLen];
        System.arraycopy(subrightsContainer.data, subrightsContainer.dataOffset, subrightData, 0, subrightsContainer.dataLen);
        this.setSubrights(subrightData);
        byte subrights = subrightsContainer.data[subrightsContainer.dataOffset];
        if (this.subrightSet(subrights, 7)) {
            this.setFormFillInAndSaveEnabled(true);
        }
        if (this.subrightSet(subrights, 6)) {
            this.setFormImportExportEnabled(true);
        }
        if (this.subrightSet(subrights, 5)) {
            this.setFormAddDeleteEnabled(true);
        }
        if (this.subrightSet(subrights, 4)) {
            this.setSubmitStandaloneEnabled(true);
        }
        if (this.subrightSet(subrights, 3)) {
            this.setSpawnTemplateEnabled(true);
        }
        if (this.subrightSet(subrights, 2)) {
            this.setSigningEnabled(true);
        }
        if (this.subrightSet(subrights, 1)) {
            this.setAnnotModifyEnabled(true);
        }
        if (this.subrightSet(subrights, 0)) {
            this.setAnnotImportExportEnabled(true);
        }
        if (subrightsContainer.dataLen <= 1) {
            return;
        }
        subrights = subrightsContainer.data[subrightsContainer.dataOffset + 1];
        if (this.subrightSet(subrights, 7)) {
            this.setBarcodePlainTextEnabled(true);
        }
        if (this.subrightSet(subrights, 6)) {
            this.setAnnotOnlineEnabled(true);
        }
        if (this.subrightSet(subrights, 5)) {
            this.setFormOnlineEnabled(true);
        }
        if (this.subrightSet(subrights, 4)) {
            this.setEFModifyEnabled(true);
        }
    }

    private boolean subrightSet(int subrights, int bitPositionToCheck) {
        return (subrights & 1 << bitPositionToCheck) != 0;
    }

    public boolean isAnnotImportExportEnabled() {
        return this.annotImportExportEnabled;
    }

    public boolean isFormFillInAndSaveEnabled() {
        return this.formFillInAndSaveEnabled;
    }

    public boolean isFormImportExportEnabled() {
        return this.formImportExportEnabled;
    }

    public boolean isFormAddDeleteEnabled() {
        return this.formAddDeleteEnabled;
    }

    public boolean isSubmitStandaloneEnabled() {
        return this.submitStandaloneEnabled;
    }

    public boolean isSpawnTemplateEnabled() {
        return this.spawnTemplateEnabled;
    }

    public boolean isSigningEnabled() {
        return this.signingEnabled;
    }

    public boolean isAnnotModifyEnabled() {
        return this.annotModifyEnabled;
    }

    public boolean isBarcodePlainTextEnabled() {
        return this.barcodePlainTextEnabled;
    }

    public boolean isAnnotOnlineEnabled() {
        return this.annotOnlineEnabled;
    }

    public boolean isFormOnlineEnabled() {
        return this.formOnlineEnabled;
    }

    public boolean isEFModifyEnabled() {
        return this.EFModifyEnabled;
    }

    public void setUbCert(X509Certificate ubCert) {
        this.ubCert = ubCert;
    }

    void setFormFillInAndSaveEnabled(boolean formFillInAndSaveEnabled) {
        this.formFillInAndSaveEnabled = formFillInAndSaveEnabled;
    }

    void setFormImportExportEnabled(boolean formImportExportEnabled) {
        this.formImportExportEnabled = formImportExportEnabled;
    }

    void setFormAddDeleteEnabled(boolean formAddDeleteEnabled) {
        this.formAddDeleteEnabled = formAddDeleteEnabled;
    }

    void setSubmitStandaloneEnabled(boolean submitStandaloneEnabled) {
        this.submitStandaloneEnabled = submitStandaloneEnabled;
    }

    void setSpawnTemplateEnabled(boolean spawnTemplateEnabled) {
        this.spawnTemplateEnabled = spawnTemplateEnabled;
    }

    void setSigningEnabled(boolean signingEnabled) {
        this.signingEnabled = signingEnabled;
    }

    void setAnnotModifyEnabled(boolean annotModifyEnabled) {
        this.annotModifyEnabled = annotModifyEnabled;
    }

    void setAnnotImportExportEnabled(boolean annotImportExportEnabled) {
        this.annotImportExportEnabled = annotImportExportEnabled;
    }

    void setBarcodePlainTextEnabled(boolean barcodePlaintextEnabled) {
        this.barcodePlainTextEnabled = barcodePlaintextEnabled;
    }

    void setAnnotOnlineEnabled(boolean annotOnlineEnabled) {
        this.annotOnlineEnabled = annotOnlineEnabled;
    }

    void setFormOnlineEnabled(boolean formOnlineEnabled) {
        this.formOnlineEnabled = formOnlineEnabled;
    }

    void setEFModifyEnabled(boolean modifyEnabled) {
        this.EFModifyEnabled = modifyEnabled;
    }

    void setSubrights(byte[] subrights) {
        this.subrights = subrights;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void printCertificateInformation() {
        System.out.println("Version - " + this.version);
        System.out.println("Deployment Mode - " + this.deploymentMode);
        if (this.isFormFillInAndSaveEnabled()) {
            System.out.println("FormFillInAndSave enabled");
        } else {
            System.out.println("FormFillInAndSave disabled");
        }
        if (this.isFormImportExportEnabled()) {
            System.out.println("FormImportExport enabled");
        } else {
            System.out.println("FormImportExport disabled");
        }
        if (this.isFormAddDeleteEnabled()) {
            System.out.println("FormAddDelete enabled");
        } else {
            System.out.println("FormAddDelete disabled");
        }
        if (this.isSubmitStandaloneEnabled()) {
            System.out.println("SubmitStandalone enabled");
        } else {
            System.out.println("SubmitStandalone disabled");
        }
        if (this.isSpawnTemplateEnabled()) {
            System.out.println("SpawnTemplate enabled");
        } else {
            System.out.println("SpawnTemplate disabled");
        }
        if (this.isSigningEnabled()) {
            System.out.println("Signing enabled");
        } else {
            System.out.println("Signing disabled");
        }
        if (this.isAnnotModifyEnabled()) {
            System.out.println("AnnotModify enabled");
        } else {
            System.out.println("AnnotModify disabled");
        }
        if (this.isAnnotImportExportEnabled()) {
            System.out.println("AnnotImportExport enabled");
        } else {
            System.out.println("AnnotImportExport disabled");
        }
        if (this.isBarcodePlainTextEnabled()) {
            System.out.println("Barcode PlainText enabled");
        } else {
            System.out.println("Barcode PlainText disabled");
        }
        if (this.isAnnotOnlineEnabled()) {
            System.out.println("Annot Online enabled");
        } else {
            System.out.println("Annot Online disabled");
        }
        if (this.isFormOnlineEnabled()) {
            System.out.println("Form Online enabled");
        } else {
            System.out.println("Form Online disabled");
        }
        if (this.isEFModifyEnabled()) {
            System.out.println("EFModify enabled");
        } else {
            System.out.println("EFModify disabled");
        }
    }
}

