/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCECredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocumentTimeStampSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFilterBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFLegalAttestation;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureFilter;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReference;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReferenceList;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureSubFilter;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParameters;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersDocMDP;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveIncrementalOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.services.digsig.LegalScrubber;
import com.adobe.internal.pdftoolkit.services.digsig.ObjectDigestMode;
import com.adobe.internal.pdftoolkit.services.digsig.SigSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsDocMDP;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.SigningStatus;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.SignatureServiceProvider;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSASigningUtils;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.SignatureHandler;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.SignatureHandlerFactory;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.SignatureHandlerPPKLite;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.XFADigSigWorkFlow;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SeedValueEnforcer;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureDocumentProxy;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureFlags;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.XFAPlugin;
import com.rsa.certj.cert.CertificateException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SigningUtils {
    public static SignatureOptions performPreSignValidations(XFADigSigWorkFlow workFlow, Credentials credentials, SignatureOptions sigOptions, SigningType signingType) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] byteRangeDigestMethodsDetached = new String[]{PDFSignature.k_MD5.asString(true), PDFSignature.k_SHA1.asString(true), PDFSignature.k_SHA256.asString(true), PDFSignature.k_SHA384.asString(true), PDFSignature.k_SHA512.asString(true), PDFSignature.k_RIPEMD160.asString(true)};
        SignatureFieldInterface sigField = workFlow.getSignatureField();
        if (sigField == null) {
            throw new PDFInvalidParameterException("Signing requires a signature field.");
        }
        if (credentials == null) {
            throw new PDFInvalidParameterException("Signing requires credentials.");
        }
        if (!SigningUtils.isSupportedCredentialType(credentials)) {
            throw new PDFInvalidParameterException("Signing does not support this credential type");
        }
        PDFDocument pdfDoc = sigField.getPDFDocument();
        if (pdfDoc.requireCatalog().procureInteractiveForm().getNeedAppearances()) {
            throw new PDFInvalidDocumentException("Appearances need to be generated before the signing process and the NeedAppearances flag turned off.");
        }
        if (sigField.isReadOnly()) {
            throw new PDFInvalidParameterException("Supplied signature field is read only. Cannot proceed with signing.");
        }
        if (credentials instanceof RSACredentials && ((RSACredentials)credentials).getJSAFEPrivateKey().getAlgorithm().equals("EC")) {
            try {
                sigOptions.setDigestMethod(((RSACredentials)credentials).getRSAX509Cert().getSignatureAlgorithm().split("/")[0]);
            }
            catch (CertificateException e) {
                throw new PDFInvalidParameterException("Digest method in ECDSA signature has invalid format.");
            }
        }
        if (credentials instanceof JCECredentials && ((JCECredentials)credentials).getPrivateKey().getAlgorithm().equalsIgnoreCase("EC")) {
            String algorithm = ((JCECredentials)credentials).getCertificate().getSigAlgName();
            for (int i = 0; i < byteRangeDigestMethodsDetached.length; ++i) {
                if (!algorithm.contains(byteRangeDigestMethodsDetached[i])) continue;
                sigOptions.setDigestMethod(byteRangeDigestMethodsDetached[i]);
                break;
            }
        }
        if (sigOptions == null) {
            if (signingType == SigningType.OrdinaryCertification) {
                sigOptions = SignatureOptionsDocMDP.newInstance();
                ((SignatureOptionsDocMDP)sigOptions).setDocMDPPermissions(PDFDocMDPPermissions.FormChanges);
                if (XFAService.getDocumentType(sigField.getPDFDocument()).isDynamic()) {
                    ((SignatureOptionsDocMDP)sigOptions).enableLeanDocumentGeneration();
                }
            } else {
                sigOptions = SignatureOptions.newInstance();
            }
        }
        if (sigOptions.getSigningType() == null) {
            sigOptions.setSigningType(signingType);
        }
        SigSeedValue sigSeed = sigField.getSeedValue();
        if (SigningUtils.isCertification(sigOptions)) {
            if (SignatureManager.newInstance(sigField.getPDFDocument()).isDocCertified()) {
                throw new PDFInvalidParameterException("Document is already certified.");
            }
            PDFDocMDPPermissions allowedMDP = SigningUtils.getMDPSeedValue(sigSeed);
            PDFDocMDPPermissions clientMDP = ((SignatureOptionsDocMDP)sigOptions).getDocMDPPermissions();
            if (allowedMDP != null && allowedMDP != clientMDP) {
                throw new PDFInvalidParameterException("Signature field seed value does not allow DocMDP \"" + (Object)((Object)clientMDP) + "\" setting.");
            }
            if (!SigningUtils.seedAllowsAuthorSignature(sigSeed)) {
                throw new PDFInvalidParameterException("Signature field seed value does not allow certifying.");
            }
        } else if (!SigningUtils.seedAllowsOrdinarySignature(sigSeed)) {
            throw new PDFInvalidParameterException("Signature field seed value does not allow ordinary signing.");
        }
        return sigOptions;
    }

    private static boolean seedAllowsOrdinarySignature(SigSeedValue sigSeed) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (sigSeed == null) {
            return true;
        }
        Integer mdp = sigSeed.getMDP();
        if (mdp != null) {
            return mdp == 0;
        }
        return true;
    }

    private static boolean seedAllowsAuthorSignature(SigSeedValue sigSeed) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (sigSeed == null) {
            return true;
        }
        Integer mdp = sigSeed.getMDP();
        if (mdp != null) {
            int mdpVal = mdp;
            return mdpVal >= 1 && mdpVal <= 3;
        }
        return true;
    }

    private static PDFDocMDPPermissions getMDPSeedValue(SigSeedValue sigSeed) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (sigSeed == null) {
            return null;
        }
        Integer mdp = sigSeed.getMDP();
        if (mdp != null) {
            int mdpVal = mdp;
            return PDFDocMDPPermissions.getInstance(mdpVal);
        }
        return null;
    }

    private static void validateSubFilter(SignatureOptions sigOptions) throws PDFInvalidParameterException {
        if (SigningUtils.isCades(sigOptions)) {
            if (sigOptions.getSubFilter() != PDFSignatureSubFilter.ETSICADESDetached) {
                throw new PDFInvalidParameterException("sigOptions contains sub filter which has a subfilter different than that for CADES");
            }
        } else if (sigOptions.getSigningType() == SigningType.DocumentTimeStamp && sigOptions.getSubFilter() != PDFSignatureSubFilter.ETSIRFC3161) {
            throw new PDFInvalidParameterException("sigOptions contains sub filter which has a subfilter different than that for DTS");
        }
    }

    private static SignatureHandler performCommonValidations(SignatureFieldInterface sigField, SignatureOptions sigOptions, ByteWriter byteWriter, Credentials credentials, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFInvalidParameterException, PDFSignatureException {
        SeedValueEnforcer svEnforcer;
        PDFSignatureSubFilter subFilter;
        SigSeedValue sigSeed = null;
        if (sigField != null) {
            sigSeed = sigField.getSeedValue();
        }
        if ((subFilter = (svEnforcer = new SeedValueEnforcer()).enforceSignatureHandlerSeed(sigSeed, sigOptions.getSubFilter())) == null) {
            subFilter = SigningUtils.getSignatureSubFilter(sigField, sigOptions);
        }
        sigOptions.setSubFilter(subFilter);
        SigningUtils.validateSubFilter(sigOptions);
        SignatureHandlerFactory handlerFactory = SignatureHandlerFactory.getSignatureHandlerFactory(PDFSignature.k_Adobe_PPKLite.asString(true));
        SignatureHandler sigHandler = handlerFactory.getSignatureHandler(subFilter.getValue());
        if (sigOptions.isApplyTimestamp()) {
            SigningUtils.checkTSSupport(sigHandler, subFilter);
            sigHandler.setTimeStampProvider(sigOptions.getTimeStampProvider());
        }
        if (sigOptions.embedRevocationInfo()) {
            SigningUtils.checkRevocationSupport(sigHandler, subFilter);
            sigHandler.setRevocationInfoProvider(sigOptions.getRevocationInfoProvider());
        }
        String digestToApply = SigningUtils.computeByteRangeDigestToApply(sigHandler, sigOptions.getDigestMethod(), subFilter);
        sigOptions.setDigestMethod(digestToApply);
        if (subFilter != PDFSignatureSubFilter.ETSIRFC3161) {
            String signatureAlg = SigningUtils.getSignatureAlgorithmValue(credentials, sigHandler, subFilter);
            sigOptions.setSignatureAlgorithm(signatureAlg);
            if (sigOptions.getSignatureAlgorithm().equalsIgnoreCase("DSA")) {
                sigOptions.setDigestMethod(PDFSignature.k_SHA1.asString(true));
            }
            svEnforcer.enforceSignatureSeedValue(sigSeed, credentials, sigOptions, subFilter, pdfDoc);
        }
        SigningUtils.validateSaveOptions(sigOptions, byteWriter, pdfDoc);
        PDFVersion toSaveVersion = SigningUtils.assertValidPDFVersion(sigOptions, pdfDoc);
        if (toSaveVersion.lessThan(PDFVersion.v1_5) && sigOptions.getAppBuildData() != null) {
            throw new PDFInvalidParameterException("Build data dictionary can be set only for PDF 1.5 and higher");
        }
        return sigHandler;
    }

    private static String computeByteRangeDigestToApply(SignatureHandler sigHandler, String digestToApply, PDFSignatureSubFilter subFilter) throws PDFSignatureException {
        if (digestToApply != null) {
            if (!sigHandler.isDigestMethodSupported(subFilter.getValue(), digestToApply)) {
                throw new PDFSignatureException("The subfilter " + (Object)((Object)subFilter) + " does not support requested byte range digest " + digestToApply);
            }
            return digestToApply;
        }
        return sigHandler.getDefaultDigestMethod();
    }

    private static String getSignatureAlgorithmValue(Credentials credentials, SignatureHandler sigHandler, PDFSignatureSubFilter subFilter) throws PDFInvalidParameterException, PDFSignatureException {
        String sigAlg = "RSA";
        if (credentials instanceof RSACredentials) {
            sigAlg = RSASigningUtils.getKeyAlgorithm(((RSACredentials)credentials).getRSAX509Cert());
        } else if (credentials instanceof JCECredentials) {
            sigAlg = ((JCECredentials)credentials).getPrivateKey().getAlgorithm();
            sigAlg = sigAlg.indexOf("DSA") != -1 ? "DSA" : (sigAlg.indexOf("EC") != -1 ? "EC" : "RSA");
        }
        if (!sigHandler.isSignatureAlgorithmSupported(subFilter.getValue(), sigAlg)) {
            throw new PDFSignatureException("The subfilter " + (Object)((Object)subFilter) + " does not support signature algorithm " + sigAlg);
        }
        return sigAlg;
    }

    private static void checkRevocationSupport(SignatureHandler sigHandler, PDFSignatureSubFilter subFilter) throws PDFSignatureException {
        if (!sigHandler.supportsEmbeddingRevocationInfo(subFilter.getValue())) {
            throw new PDFSignatureException("The subfilter " + (Object)((Object)subFilter) + " does not support embedding of revocation information");
        }
    }

    private static void checkTSSupport(SignatureHandler sigHandler, PDFSignatureSubFilter subFilter) throws PDFSignatureException {
        if (!sigHandler.supportsTimeStamping(subFilter.getValue())) {
            throw new PDFSignatureException("The subfilter " + (Object)((Object)subFilter) + " does not support timestamping");
        }
    }

    private static void validateSaveOptions(SignatureOptions sigOptions, ByteWriter byteWriter, PDFDocument pdfDoc) throws PDFInvalidParameterException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFVersion toSaveVersion;
        PDFSaveOptions saveOptions = sigOptions.getSaveOptions();
        if (saveOptions == null) {
            saveOptions = PDFSaveIncrementalOptions.newInstance();
        }
        sigOptions.setSaveOptions(saveOptions);
        if (!(byteWriter != null || saveOptions instanceof PDFSaveIncrementalOptions && pdfDoc.canIncrementallySaveInPlace())) {
            throw new PDFInvalidParameterException("All signing operations require an output ByteWriter when not using \"in place\" incremental save.");
        }
        if (sigOptions.getSigningType() == SigningType.UsageRights && (toSaveVersion = saveOptions.containsVersion() ? saveOptions.getVersion() : pdfDoc.getOriginalVersion()).lessThan(PDFVersion.v1_6)) {
            throw new PDFInvalidParameterException("Document must be saved to PDF 1.6 in order to apply UR3 usage rights.");
        }
    }

    private static PDFSignature createSignature(SignatureOptions sigOptions, PDFDocument pdfDoc, Object transformParamsUR) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFSignature signature = null;
        signature = sigOptions.getSubFilter() == PDFSignatureSubFilter.ETSIRFC3161 ? PDFDocumentTimeStampSignature.newInstance(pdfDoc) : PDFSignature.newInstance(pdfDoc, PDFSignatureFilter.AdobePPKLite, sigOptions.getSubFilter());
        if (SigningUtils.isCertification(sigOptions)) {
            if (!SignatureUtils.isAuthorSignature(signature)) {
                PDFDocMDPPermissions docMDPPermissions = null;
                if (((SignatureOptionsDocMDP)sigOptions).hasPermissions()) {
                    docMDPPermissions = ((SignatureOptionsDocMDP)sigOptions).getDocMDPPermissions();
                }
                String transformDigestMethod = null;
                if (((SignatureOptionsDocMDP)sigOptions).hasTransformDigestMethod()) {
                    transformDigestMethod = ((SignatureOptionsDocMDP)sigOptions).getTransformDigestMethod();
                }
                SigningUtils.createDocMDPTransform(signature, transformDigestMethod, docMDPPermissions, pdfDoc, sigOptions);
            }
        } else if (sigOptions.getSigningType() == SigningType.UsageRights && transformParamsUR != null) {
            PDFSignatureReference reference = PDFSignatureReference.newInstance(pdfDoc, PDFSignature.k_UR3);
            PDFSignatureReferenceList referenceList = PDFSignatureReferenceList.newInstance(pdfDoc);
            referenceList.add(reference);
            signature.setReferences(referenceList);
            reference.setPDFTransformParameters((PDFTransformParameters)transformParamsUR);
        }
        return signature;
    }

    private static void createDocMDPTransform(PDFSignature signature, String digestMethod, PDFDocMDPPermissions docMDPPermissions, PDFDocument pdfDoc, SignatureOptions sigOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSignatureReference reference = PDFSignatureReference.newInstance(pdfDoc, PDFSignature.k_DocMDP);
        PDFSignatureReferenceList referenceList = PDFSignatureReferenceList.newInstance(pdfDoc);
        referenceList.add(reference);
        signature.setReferences(referenceList);
        if (sigOptions.hasObjectDigestMode() && sigOptions.getObjectDigestMode() != ObjectDigestMode.None) {
            if (digestMethod == null) {
                digestMethod = PDFSignature.k_MD5.asString(true);
            }
            reference.setDigestMethod(digestMethod);
        }
        PDFTransformParametersDocMDP transformParams = PDFTransformParametersDocMDP.newInstance(pdfDoc, docMDPPermissions);
        transformParams.setVersion("1.2");
        reference.setPDFTransformParameters(transformParams);
    }

    private static PDFSignatureSubFilter getSignatureSubFilter(SignatureFieldInterface sigField, SignatureOptions sigOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        switch (sigOptions.getSigningType()) {
            case DocumentTimeStamp: {
                return PDFSignatureSubFilter.ETSIRFC3161;
            }
            case CADESDetachedSigning: 
            case CADESDetachedCertification: {
                return PDFSignatureSubFilter.ETSICADESDetached;
            }
            case OrdinaryCertification: {
                return SigningUtils.getDefaultSubFilter(sigField.getSeedValue());
            }
            case OrdinarySigning: {
                return SigningUtils.getDefaultSubFilter(sigField.getSeedValue());
            }
            case UsageRights: {
                return SigningUtils.getDefaultSubFilter(null);
            }
        }
        return null;
    }

    private static PDFSignatureSubFilter getDefaultSubFilter(SigSeedValue sigSeed) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFSignatureSubFilter subFilter = null;
        if (sigSeed != null) {
            ASName[] subFilters;
            int flags = sigSeed.getFlags();
            List<ASName> subFiltersList = sigSeed.getSubFilters();
            ASName[] aSNameArray = subFilters = subFiltersList != null ? subFiltersList.toArray(new ASName[0]) : null;
            if (subFilters != null && (flags & 2) == 2) {
                for (int i = 0; i < subFilters.length; ++i) {
                    if (subFilters[i] == null || !SignatureHandlerPPKLite.isSubFilterSupported(subFilters[i])) continue;
                    subFilter = PDFSignatureSubFilter.getInstance(subFilters[i]);
                    break;
                }
                if (subFilter == null) {
                    throw new PDFInvalidParameterException("None of the subfilters specified by the signature seed value are available.");
                }
            }
        }
        if (subFilter == null) {
            subFilter = PDFSignatureSubFilter.PKCS7Detached;
        }
        return subFilter;
    }

    private static boolean execEvent(SignatureFieldInterface sigField, SignatureOptions sigOptions, XFAProcessingOptions.SigningEvent event, PDFDocument pdfDoc) throws PDFSecurityException, PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException {
        EnumSet<XFAProcessingOptions.SigningEvent> eventsList = sigOptions.getSigningEventsList();
        if (eventsList == null || !eventsList.contains((Object)event)) {
            return true;
        }
        if (!XFAService.getDocumentType(pdfDoc).isXFA()) {
            return true;
        }
        if (event == XFAProcessingOptions.SigningEvent.PRESAVE) {
            XFAPlugin.PDDocWillSaveExProc(pdfDoc);
        } else if (event == XFAProcessingOptions.SigningEvent.POSTSAVE) {
            XFAPlugin.PDDocDidSaveProc(pdfDoc);
        } else {
            DocumentContext docContext = DocumentContext.find(pdfDoc, true, null);
            if (docContext == null || !XFADOMService.isFormDomCreated(pdfDoc)) {
                return true;
            }
            DocumentContext.SignEventInfo info = new DocumentContext.SignEventInfo(docContext);
            info.sigField = sigField;
            info.notificationID = event == XFAProcessingOptions.SigningEvent.PRESIGN ? DocumentContext.DSNotificationType.DSWillSign : DocumentContext.DSNotificationType.DSDidSign;
            return docContext.dispatchEvents(info);
        }
        return true;
    }

    private static PDFVersion computeToSaveVersion(PDFSaveOptions saveOptions, PDFDocument pdfDoc) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFVersion toSaveVersion = pdfDoc.getToSaveVersion();
        if (toSaveVersion == null) {
            toSaveVersion = saveOptions != null && saveOptions.containsVersion() ? saveOptions.getVersion() : pdfDoc.getOriginalVersion();
        }
        return toSaveVersion;
    }

    private static PDFVersion assertValidPDFVersion(SignatureOptions sigOptions, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFVersion toSaveVersion = SigningUtils.computeToSaveVersion(sigOptions.getSaveOptions(), pdfDoc);
        if (toSaveVersion.lessThan(PDFVersion.v1_3)) {
            throw new PDFInvalidParameterException("Digital signatures are only supported in PDF version 1.3 and later");
        }
        if (SigningUtils.isCertification(sigOptions) && toSaveVersion.lessThan(PDFVersion.v1_5)) {
            throw new PDFInvalidParameterException("Signature transforms are only supported in PDF version 1.5 and later");
        }
        return toSaveVersion;
    }

    private static void setUpBuildPropDict(SignatureHandler sigHandler, PDFVersion toSaveVersion, SignatureOptions sigOptions, PDFSignature signature) throws PDFInvalidParameterException, PDFSignatureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!toSaveVersion.lessThan(PDFVersion.v1_5)) {
            PDFFilterBuildData filterDict = sigHandler.setUpPDFFilterBuildPropValues();
            signature.setPDFBuildPropDictionary(filterDict, sigOptions.getAppBuildData(), null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SigningStatus doSigning(XFADigSigWorkFlow workFlow, SignatureOptions sigOptions, Credentials credentials, ByteWriter byteWriter, SignatureServiceProvider sigServiceProvider, PDFDocument pdfDoc, Object transformParamsUR) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFSignatureException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        workFlow.removeSigningEventsIfNotRequired(sigOptions);
        SignatureFieldInterface sigField = workFlow.getSignatureField();
        SignatureHandler sigHandler = SigningUtils.performCommonValidations(sigField, sigOptions, byteWriter, credentials, pdfDoc);
        if (sigServiceProvider != null) {
            sigOptions.registerSignatureServiceProvider(sigServiceProvider);
        }
        SigningStatus signingStatus = new SigningStatus();
        try {
            if (!SigningUtils.execEvent(sigField, sigOptions, XFAProcessingOptions.SigningEvent.PRESIGN, pdfDoc)) {
                signingStatus.setStatus(SigningStatus.Status.CANCELLED);
                SigningStatus signingStatus2 = signingStatus;
                return signingStatus2;
            }
            if (sigField != null && (pdfDoc.getInteractiveForm().getSigFlags() & 1) == 0) {
                SignatureFlags.signatureFieldAdded(pdfDoc);
            }
            PDFSignature signature = SigningUtils.createSignature(sigOptions, pdfDoc, transformParamsUR);
            workFlow.prepareToSign(sigHandler, pdfDoc, sigField, signature, sigOptions, credentials);
            PDFVersion toSaveVersion = SigningUtils.computeToSaveVersion(sigOptions.getSaveOptions(), pdfDoc);
            SigningUtils.setUpBuildPropDict(sigHandler, toSaveVersion, sigOptions, signature);
            if (SignatureUtils.isAuthorSignature(signature)) {
                String legalAttestationStr;
                PDFLegalAttestation attest;
                SignatureOptionsDocMDP docMDPOptions = null;
                if (sigOptions instanceof SignatureOptionsDocMDP) {
                    docMDPOptions = (SignatureOptionsDocMDP)sigOptions;
                }
                if (toSaveVersion.lessThan(PDFVersion.v1_7)) {
                    LegalScrubber scrubber = LegalScrubber.newInstance(pdfDoc);
                    attest = scrubber.generateLegalAttestation();
                } else {
                    attest = PDFLegalAttestation.newInstance(pdfDoc);
                }
                if (docMDPOptions != null && docMDPOptions.hasLegalAttestation() && (legalAttestationStr = docMDPOptions.getLegalAttestation()).trim().length() > 0) {
                    attest.setAttestation(legalAttestationStr);
                }
                if (!attest.isEmpty()) {
                    pdfDoc.requireCatalog().setLegalAttestation(attest);
                }
            }
            if (byteWriter == null) {
                byteWriter = pdfDoc.getCosDocument().getInPlaceByteWriter();
            }
            SignatureDocumentProxy pdfDocProxy = null;
            OutputByteStream outputByteStream = null;
            InputByteStream inputByteStream = null;
            PDFSaveOptions saveOptions = sigOptions.getSaveOptions();
            try {
                SigningUtils.execEvent(sigField, sigOptions, XFAProcessingOptions.SigningEvent.PRESAVE, pdfDoc);
                pdfDocProxy = new SignatureDocumentProxy(pdfDoc);
                pdfDocProxy.preSave(sigOptions, workFlow);
                pdfDocProxy.doSave(byteWriter, saveOptions);
                outputByteStream = pdfDoc.getStreamManager().getOutputByteStream(byteWriter);
                outputByteStream.flush();
                inputByteStream = pdfDoc.getCosDocument().getStream();
                sigHandler.calculateOffsetsAfterSave(inputByteStream);
                sigHandler.writeSignatureAfterSave(sigOptions, outputByteStream);
                pdfDoc.getCosDocument().markNotDirty();
            }
            catch (IOException e) {
                throw new PDFIOException("IO exception with the PDF document to be signed", e);
            }
            finally {
                try {
                    if (inputByteStream != null) {
                        inputByteStream.close();
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (pdfDocProxy != null) {
                            pdfDocProxy.postSave(saveOptions);
                        }
                    }
                    finally {
                        SigningUtils.execEvent(sigField, sigOptions, XFAProcessingOptions.SigningEvent.POSTSAVE, pdfDoc);
                    }
                }
                finally {
                    try {
                        if (pdfDocProxy != null) {
                            pdfDocProxy.postSave(saveOptions);
                        }
                    }
                    finally {
                        SigningUtils.execEvent(sigField, sigOptions, XFAProcessingOptions.SigningEvent.POSTSAVE, pdfDoc);
                    }
                }
            }
        }
        finally {
            try {
                SigningUtils.execEvent(sigField, sigOptions, XFAProcessingOptions.SigningEvent.POSTSIGN, pdfDoc);
            }
            finally {
                sigOptions.setSigningType(null);
            }
        }
        return signingStatus;
    }

    public static boolean isSupportedCredentialType(Credentials credential) {
        return credential instanceof JCECredentials || credential instanceof RSACredentials;
    }

    public static Map computeAllDigestOffsetsOnce(CosContainer indirectContainer) throws PDFIOException {
        HashMap<ASName, Integer> objMap = new HashMap<ASName, Integer>();
        objMap.put(PDFSignatureReference.k_DigestLocation, 2);
        objMap.put(PDFSignatureReference.k_DigestValue, 2);
        objMap.put(PDFSignature.k_DocMDP, 1);
        objMap.put(PDFSignature.k_FieldMDP, 1);
        return indirectContainer.findObjPos(objMap);
    }

    public static Map<ASName, Integer> computeAllOffsetsOnce(PDFSignature pdfSignature) throws PDFIOException {
        HashMap<ASName, Integer> objMap = new HashMap<ASName, Integer>();
        objMap.put(ASName.k_ByteRange, 1);
        objMap.put(ASName.k_Contents, 1);
        return pdfSignature.getCosDictionary().findObjPos(objMap);
    }

    public static long getByteRangesOffset(Map resultMap) throws PDFIOException {
        long retVal = 0L;
        Long[] offsets = (Long[])resultMap.get(ASName.k_ByteRange);
        if (offsets != null) {
            retVal = offsets[0];
        }
        return retVal;
    }

    public static long getContentsOffset(Map resultMap) throws PDFIOException {
        long retVal = 0L;
        Long[] offsets = (Long[])resultMap.get(ASName.k_Contents);
        if (offsets != null) {
            retVal = offsets[0];
        }
        return retVal;
    }

    public static long getDigestLocationArrayOffset(PDFSignatureReference sigRef, long baseLoc, Map resultMap, ASName transformMethod) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        long[] digestLocation = sigRef.getDigestLocation();
        if (digestLocation == null) {
            return 0L;
        }
        long digestLocation1 = ((Long[])resultMap.get(PDFSignatureReference.k_DigestLocation))[0];
        long digestLocation2 = ((Long[])resultMap.get(PDFSignatureReference.k_DigestLocation))[1];
        long docMDPLocation = ((Long[])resultMap.get(PDFSignature.k_DocMDP))[0];
        long fieldMDPLocation = ((Long[])resultMap.get(PDFSignature.k_FieldMDP))[0];
        if (digestLocation2 < baseLoc) {
            return digestLocation1;
        }
        if (transformMethod == PDFSignature.k_DocMDP) {
            return docMDPLocation < fieldMDPLocation ? digestLocation1 : digestLocation2;
        }
        if (transformMethod == PDFSignature.k_FieldMDP) {
            return fieldMDPLocation < docMDPLocation ? digestLocation1 : digestLocation2;
        }
        return digestLocation1;
    }

    public static long getDigestStringOffset(PDFSignatureReference sigRef, long baseLoc, Map resultMap, ASName transformMethod) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        byte[] digestValue = sigRef.getDigest();
        if (digestValue == null) {
            return 0L;
        }
        long digestValue1 = ((Long[])resultMap.get(PDFSignatureReference.k_DigestValue))[0];
        long digestValue2 = ((Long[])resultMap.get(PDFSignatureReference.k_DigestValue))[1];
        long docMDPLocation = ((Long[])resultMap.get(PDFSignature.k_DocMDP))[0];
        long fieldMDPLocation = ((Long[])resultMap.get(PDFSignature.k_FieldMDP))[0];
        if (digestValue2 < baseLoc) {
            return digestValue1;
        }
        if (transformMethod == PDFSignature.k_DocMDP) {
            return docMDPLocation < fieldMDPLocation ? digestValue1 : digestValue2;
        }
        if (transformMethod == PDFSignature.k_FieldMDP) {
            return fieldMDPLocation < docMDPLocation ? digestValue1 : digestValue2;
        }
        return digestValue1;
    }

    public static boolean isCertification(SignatureOptions sigOptions) {
        return sigOptions.getSigningType() == SigningType.OrdinaryCertification || sigOptions.getSigningType() == SigningType.CADESDetachedCertification;
    }

    private static boolean isCades(SignatureOptions sigOptions) {
        return sigOptions.getSigningType() == SigningType.CADESDetachedSigning || sigOptions.getSigningType() == SigningType.CADESDetachedCertification;
    }

    public static SignatureFieldInterface getSignatureFieldInterface(PDFFieldSignature sigFieldPDF) throws PDFInvalidParameterException {
        if (sigFieldPDF == null) {
            return null;
        }
        return new SignatureFieldPDF(sigFieldPDF);
    }

    public static enum SigningType {
        UsageRights,
        DocumentTimeStamp,
        CADESDetachedSigning,
        CADESDetachedCertification,
        OrdinaryCertification,
        OrdinarySigning;

    }
}

