/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.PDFFormSupport;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFACanonicalizer;
import java.io.IOException;
import java.util.HashMap;

public final class XFATemplateDigester
extends ObjectDigester {
    private PDFDocument document;

    public XFATemplateDigester(PDFDocument document, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        super(document, digesterFactory, digestCache, selector, sigField);
        this.document = document;
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDocument cosDoc = this.document.getCosDocument();
        StreamManager streamManager = cosDoc.getStreamManager();
        OutputByteStream canonicalOBS = null;
        InputByteStream xfaStream = null;
        try {
            PDFCatalog pdfCatalog = this.document.requireCatalog();
            PDFInteractiveForm pdfInteractiveForm = pdfCatalog.getInteractiveForm();
            if (XFAService.getDocumentType(this.pdfDoc).isXFA()) {
                int amtRead;
                xfaStream = PDFFormSupport.getFullXFAStream(pdfInteractiveForm);
                canonicalOBS = streamManager.getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, xfaStream.length());
                XFADOM xfaDOM = XFADOMService.ensureXFADOMCreated(this.document);
                XFACanonicalizer.canonicalize(XFAUtils.g_packets_CommentsAndDefault, xfaDOM.getXFADocument(), xfaDOM.getAppModel(), xfaStream, canonicalOBS);
                InputByteStream ibs = canonicalOBS.closeAndConvert();
                canonicalOBS = null;
                byte[] buffer = new byte[4096];
                for (long amtToDigest = ibs.length(); amtToDigest > 0L; amtToDigest -= (long)amtRead) {
                    amtRead = ibs.read(buffer);
                    this.digester.update(buffer, 0, amtRead);
                }
                ibs.close();
            }
        }
        catch (IOException e) {
            throw new PDFIOException("IO exception encountered when creating outputByteStream for canonicalization", e);
        }
        catch (PDFIOException e) {
            throw new PDFIOException("IO exception encountered when creating outputByteStream for canonicalization", e);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFInvalidDocumentException("Invalid xml exception encountered when canonicalizing the xfa data.Possible invalid document", e);
        }
        finally {
            try {
                if (canonicalOBS != null) {
                    canonicalOBS.close();
                }
                if (xfaStream != null) {
                    xfaStream.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException("Issue closing the OutputByteStream/InputByteStream created for canonicalization", e);
            }
        }
        byte[] digest = super.digest();
        return digest;
    }
}

