/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.credentials.impl.HSMCredentials;
import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Date;
import java.util.Vector;

final class CustomProviderImpl
extends ProviderImplementation
implements DatabaseInterface {
    HSMCredentials credentials = null;

    public CustomProviderImpl(CertJ certJ, String name) throws InvalidParameterException {
        super(certJ, name);
    }

    public void setCredentials(HSMCredentials credentials) {
        this.credentials = credentials;
    }

    public int selectCertificateByIssuerAndSerialNumber(X500Name arg0, byte[] arg1, Vector certList) throws NotSupportedException, DatabaseException {
        try {
            if (certList != null) {
                certList.add(this.credentials.getRSAX509Cert().clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new DatabaseException("Unable to clone a certificate in the CustomDBProvider " + e.getMessage());
        }
        return 1;
    }

    public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate arg0) throws NotSupportedException, DatabaseException {
        try {
            return (JSAFE_PrivateKey)this.credentials.getJSAFEPrivateKey().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DatabaseException("Unable to clone the private key in the CustomDBProvider " + e.getMessage());
        }
    }

    public void insertCertificate(Certificate arg0) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the insertCertificate functionality");
    }

    public void insertCRL(CRL arg0) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the insertCRL functionality");
    }

    public void insertPrivateKeyByCertificate(Certificate arg0, JSAFE_PrivateKey arg1) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the insertPrivateKeyByCertificate functionality");
    }

    public void insertPrivateKeyByPublicKey(JSAFE_PublicKey arg0, JSAFE_PrivateKey arg1) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the insertPrivateKeyByPublicKey functionality");
    }

    public int selectCertificateBySubject(X500Name arg0, Vector arg1) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the selectCertificateBySubject functionality");
    }

    public int selectCertificateByExtensions(X500Name arg0, X509V3Extensions arg1, Vector arg2) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the selectCertificateByExtensions functionality");
    }

    public boolean isCertificateIteratorSetup() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the isCertificateIteratorSetup functionality");
    }

    public void setupCertificateIterator() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the setupCertificateIterator functionality");
    }

    public Certificate firstCertificate() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the firstCertificate functionality");
    }

    public Certificate nextCertificate() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the nextCertificate functionality");
    }

    public boolean hasMoreCertificates() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the hasMoreCertificates functionality");
    }

    public int selectCRLByIssuerAndTime(X500Name arg0, Date arg1, Vector arg2) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the selectCRLByIssuerAndTime functionality");
    }

    public boolean isCRLIteratorSetup() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the insertPrivateKeyByCertificate functionality");
    }

    public void setupCRLIterator() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the setupCRLIterator functionality");
    }

    public CRL firstCRL() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the firstCRL functionality");
    }

    public CRL nextCRL() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the hasMoreCRLs functionality");
    }

    public boolean hasMoreCRLs() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the insertPrivateKeyByCertificate functionality");
    }

    public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey arg0) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the selectPrivateKeyByPublicKey functionality");
    }

    public boolean isPrivateKeyIteratorSetup() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the isPrivateKeyIteratorSetup functionality");
    }

    public void setupPrivateKeyIterator() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the setupPrivateKeyIterator functionality");
    }

    public JSAFE_PrivateKey firstPrivateKey() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the firstPrivateKey functionality");
    }

    public JSAFE_PrivateKey nextPrivateKey() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the nextPrivateKey functionality");
    }

    public boolean hasMorePrivateKeys() throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the hasMorePrivateKeys functionality");
    }

    public void deleteCertificate(X500Name arg0, byte[] arg1) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the deleteCertificate( functionality");
    }

    public void deleteCRL(X500Name arg0, Date arg1) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the deleteCRL functionality");
    }

    public void deletePrivateKeyByCertificate(Certificate arg0) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the deletePrivateKeyByCertificate functionality");
    }

    public void deletePrivateKeyByPublicKey(JSAFE_PublicKey arg0) throws NotSupportedException, DatabaseException {
        throw new NotSupportedException("This custom db  implementation does not provide the deletePrivateKeyByPublicKey functionality");
    }
}

