/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.impl.PDFDefaultAppearanceWrapper;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.StyleAttributes;
import com.adobe.internal.pdftoolkit.services.ap.TextFormatterImpl;
import com.adobe.internal.pdftoolkit.services.ap.impl.DefaultFont;
import com.adobe.internal.pdftoolkit.services.ap.impl.TextAppearance;
import com.adobe.internal.pdftoolkit.services.ap.spi.TextFormatter;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontSetUtil;
import com.adobe.internal.pdftoolkit.services.impl.ServicesUtil;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

public class AppearanceUtils {
    private static final int DEFAULT_QUADDING = 0;
    private static final String PARA_NAME_STARTTAG_START = "<p";
    private static final String PARA_NAME_STARTTAG_END = ">";
    private static final String STYLE_NAME = "style=\"";
    public static final String BACKGROUND_HIGHLIGHT_COLOR_RED = "153";
    public static final String BACKGROUND_HIGHLIGHT_COLOR_GREEN = "193";
    public static final String BACKGROUND_HIGHLIGHT_COLOR_BLUE = "218";

    private AppearanceUtils() {
    }

    public static ASMatrix getRotationMatrix(ASMatrix appearanceXObjectMatrix, PDFAppearanceCharacteristics fieldAppearanceCharacteristics, PDFRectangle fieldBBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRotation widgetRotation;
        if (fieldAppearanceCharacteristics != null && fieldAppearanceCharacteristics.hasRotation() && ((widgetRotation = fieldAppearanceCharacteristics.getRotation()) == PDFRotation.ROTATE_90 || widgetRotation == PDFRotation.ROTATE_180 || widgetRotation == PDFRotation.ROTATE_270)) {
            appearanceXObjectMatrix = appearanceXObjectMatrix.translate(-(fieldBBox.left() + fieldBBox.right()) / 2.0, -(fieldBBox.bottom() + fieldBBox.top()) / 2.0);
            appearanceXObjectMatrix = appearanceXObjectMatrix.rotate(Math.toRadians(widgetRotation.getValue()));
            appearanceXObjectMatrix = widgetRotation == PDFRotation.ROTATE_180 ? appearanceXObjectMatrix.translate((fieldBBox.left() + fieldBBox.right()) / 2.0, (fieldBBox.bottom() + fieldBBox.top()) / 2.0) : appearanceXObjectMatrix.translate((fieldBBox.bottom() + fieldBBox.top()) / 2.0, (fieldBBox.left() + fieldBBox.right()) / 2.0);
            appearanceXObjectMatrix = appearanceXObjectMatrix.translate(-fieldBBox.left(), -fieldBBox.bottom());
        }
        return appearanceXObjectMatrix;
    }

    public static StyleAttributes makeStyle(PDFDocument doc, PDFField field, PDFAnnotationWidget annot, Locale locale, RCGOptions options) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFInteractiveForm acroForm = doc.getInteractiveForm();
        PDFResources resources = acroForm.getResources();
        StyleAttributes formDefStyle = AppearanceUtils.makeStyle(doc, null, acroForm.getDefaultAppearance(), 0, resources, locale);
        PDFVariableText varText = PDFVariableText.getInstance(field.getCosObject());
        if (varText != null) {
            boolean autoSize;
            StyleAttributes newStyle = null;
            if (varText.getDefaultAppearance() != null) {
                newStyle = AppearanceUtils.makeStyle(doc, formDefStyle, varText.getDefaultAppearance().asString(), varText.getQuadding(), resources, locale);
            }
            boolean bl = autoSize = (newStyle = AppearanceUtils.makeStyle(doc, newStyle, varText.getDefaultStyle(), varText.getQuadding(), resources, locale)).getFontSize() == 0.0;
            if (autoSize) {
                StyleAttributes defaultStyle = AppearanceUtils.getDefaultStyle(locale);
                defaultStyle.setFontColor(newStyle.getFontColor());
                defaultStyle.setFontName(newStyle.getFontName());
                defaultStyle.setRealFontName(newStyle.getRealFontName());
                newStyle = defaultStyle;
            }
            if (field instanceof PDFFieldText && ((PDFFieldText)field).isComb()) {
                AppearanceUtils.addCombFontSize((PDFFieldText)field, annot, autoSize, options, newStyle);
            }
            return newStyle;
        }
        return AppearanceUtils.getDefaultStyle(locale);
    }

    public static StyleAttributes makeStyle(PDFDocument pdfDocument, StyleAttributes formDefStyle, String defAp, int quadding, PDFResources resources, Locale locale) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (defAp == null || defAp.trim().length() == 0) {
            StyleAttributes newStyle = null;
            if (formDefStyle != null) {
                newStyle = new StyleAttributes(formDefStyle);
            } else {
                newStyle = new StyleAttributes();
                newStyle.setFontName(DefaultFont.getDefaultFontName());
                newStyle.setRealFontName(DefaultFont.getDefaultRealFontName());
            }
            newStyle.setTextAlignment(quadding);
            return newStyle;
        }
        PDFDefaultAppearance defaultAp = PDFDefaultAppearance.newInstance(pdfDocument, defAp);
        String fontName = null;
        String realFontName = null;
        double fontSize = -1.0;
        double[] fontColor = null;
        boolean isCMYKColorspace = false;
        PDFDefaultAppearanceWrapper defaultApImpl = null;
        try {
            defaultApImpl = new PDFDefaultAppearanceWrapper(defaultAp);
        }
        catch (PDFUnableToCompleteOperationException e1) {
            throw new PDFInvalidDocumentException("Can't parse default appearance /DA.", e1);
        }
        try {
            fontName = defaultApImpl.getFontName();
            fontSize = defaultApImpl.getFontSize();
            fontColor = defaultApImpl.getFontColor();
        }
        catch (PDFUnableToCompleteOperationException e1) {
            throw new PDFInvalidDocumentException("Can't parse default appearance /DA.", e1);
        }
        if (resources != null) {
            PDFFontMap fontMap = resources.getFontMap();
            if (fontMap != null) {
                PDFFont defFont = fontMap.get(ASName.create(fontName));
                if (defFont != null) {
                    ASName baseFont;
                    PDFText textName;
                    PDFFontDescriptor fontDescr = PDFFontUtils.getPDFFontDescriptor(defFont);
                    ASString familyName = null;
                    if (fontDescr != null) {
                        familyName = fontDescr.getFontFamily();
                        if (fontDescr.getLang() != null) {
                            locale = AppearanceUtils.convertStringToLocale(fontDescr.getLang().asString(true));
                        }
                    }
                    if (familyName != null && (textName = PDFText.newInstance(defFont.getPDFDocument(), familyName)) != null) {
                        realFontName = textName.stringValue();
                    }
                    if (realFontName == null && (baseFont = defFont.getBaseFont()) != null) {
                        realFontName = baseFont.asString(true);
                    }
                    if (realFontName == null) {
                        realFontName = DefaultFont.getDefaultRealFontName();
                    }
                } else {
                    realFontName = DefaultFont.getDefaultRealFontName();
                }
            } else {
                realFontName = DefaultFont.getDefaultRealFontName();
            }
        } else {
            realFontName = DefaultFont.getDefaultRealFontName();
        }
        if (fontSize == -1.0) {
            fontSize = DefaultFont.getDefaultSize(locale);
        }
        if (fontColor == null) {
            fontColor = new double[3];
            fontColor[1] = fontColor[2] = (double)DefaultFont.getDefaultColor();
            fontColor[0] = fontColor[2];
        }
        if (fontColor.length == 1) {
            double[] rgbFontColor = new double[3];
            rgbFontColor[1] = rgbFontColor[2] = fontColor[0];
            rgbFontColor[0] = rgbFontColor[2];
            fontColor = rgbFontColor;
        }
        if (fontColor.length == 4) {
            isCMYKColorspace = true;
        }
        byte[] colorBytes = new byte[fontColor.length];
        for (int colorIndex = 0; colorIndex < fontColor.length; ++colorIndex) {
            colorBytes[colorIndex] = (byte)(fontColor[colorIndex] * 255.0);
        }
        String fontColorStr = ServicesUtil.toHexString(colorBytes);
        if (isCMYKColorspace) {
            fontColorStr = "$" + fontColorStr;
        }
        StyleAttributes newStyleAttr = new StyleAttributes(fontSize, fontName, realFontName);
        newStyleAttr.setFontName(fontName);
        newStyleAttr.setRealFontName(realFontName);
        newStyleAttr.setFontColor(fontColorStr);
        newStyleAttr.setFontSize(fontSize);
        newStyleAttr.setTextAlignment(quadding);
        if (fontSize == 0.0) {
            fontSize = DefaultFont.getDefaultSize(locale);
        }
        if (defaultApImpl.getRise() != null) {
            newStyleAttr.setBaselineShift(defaultApImpl.getRise().toString());
        }
        if (defaultApImpl.getLeading() != null) {
            newStyleAttr.setLineHeight(defaultApImpl.getLeading().toString());
        }
        if (defaultApImpl.getCharSpacing() != null) {
            newStyleAttr.setLetterSpacing(String.valueOf(defaultApImpl.getCharSpacing()));
        }
        if (defaultApImpl.getWordSpacing() != null) {
            newStyleAttr.setWordSpacing(String.valueOf(defaultApImpl.getWordSpacing() / fontSize));
        }
        if (defaultApImpl.getScale() != null) {
            newStyleAttr.setFontStretchFactor(defaultApImpl.getScale().toString());
        }
        if (locale != null) {
            newStyleAttr.setLocale(locale.toString());
        }
        return newStyleAttr;
    }

    public static void addCombFontSize(PDFFieldText field, PDFAnnotationWidget annot, boolean autoSize, RCGOptions options, StyleAttributes styleAttr) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (field.isComb()) {
            double combSingleWidth = AppearanceUtils.getFieldTextCombSingleWidth(field, annot);
            double widgetUsableHeight = annot.getRect().height() - (options.getPaddingTop() + options.getPaddingBottom());
            double combFontSize = combSingleWidth;
            if (autoSize) {
                combFontSize = Math.min(combSingleWidth * 0.8, widgetUsableHeight);
                styleAttr.setFontSize(combFontSize);
            }
            styleAttr.setFontForceMonospacePitch(String.valueOf(combSingleWidth));
            try {
                options.setPaddingLeft(0.0);
                options.setPaddingRight(0.0);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Cannot set RCGOptions.", e);
            }
        }
    }

    static StyleAttributes getDefaultStyle(Locale locale) {
        return DefaultFont.getDefaultFont(locale);
    }

    public static Locale convertStringToLocale(String locale) {
        return new Locale(locale);
    }

    static double getFieldTextCombSingleWidth(PDFField field, PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double combSingleWidth = 0.0;
        if (field instanceof PDFFieldText && annot instanceof PDFAnnotationWidget && ((PDFFieldText)field).isComb()) {
            combSingleWidth = ((PDFAnnotationWidget)annot).getRect().width() / (double)((PDFFieldText)field).getMaxLen();
        }
        return combSingleWidth;
    }

    public static PDFRectangle getBBoxRectangle(PDFAnnotationWidget annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRotation widgetRotation;
        PDFAppearanceCharacteristics apCharact;
        PDFRectangle bBoxRect = null;
        PDFRectangle annotRect = annot.getRect();
        double bBoxWidth = annotRect.width();
        double bBoxHeight = annotRect.height();
        if (annot.hasAppearanceCharacteristics() && (apCharact = annot.getAppearanceCharacteristics()).hasRotation() && ((widgetRotation = apCharact.getRotation()) == PDFRotation.ROTATE_90 || widgetRotation == PDFRotation.ROTATE_270)) {
            double temp = bBoxWidth;
            bBoxWidth = bBoxHeight;
            bBoxHeight = temp;
        }
        bBoxRect = PDFRectangle.newInstance(annot.getPDFDocument(), 0.0, 0.0, bBoxWidth, bBoxHeight);
        return bBoxRect;
    }

    public static double getBorderWidth(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!(annot instanceof PDFAnnotationWidget)) {
            return 0.0;
        }
        PDFBorderStyle borderStyle = annot.getBorderStyle();
        double borderWidth = 1.0;
        PDFBorderStyle.Style style = PDFBorderStyle.Style.Solid;
        if (borderStyle != null) {
            if (borderStyle.hasWidth()) {
                borderWidth = borderStyle.getWidth();
            }
            if (borderStyle.hasStyle()) {
                style = borderStyle.getStyle();
            }
        }
        if (borderWidth <= 0.0) {
            borderWidth = 1.0;
        }
        if (style == PDFBorderStyle.Style.Beveled || style == PDFBorderStyle.Style.Inset) {
            borderWidth *= 2.0;
        }
        return borderWidth;
    }

    public static String insertStyleAttribute(String plainTextString, String cssAttribute, String normalAttribute, int[] indexArray, int idxOffset) {
        StringBuilder newString = new StringBuilder();
        String selItem = null;
        String[] paraArray = plainTextString.split(PARA_NAME_STARTTAG_START);
        newString.append(paraArray[0]);
        for (int idxSel = 0; idxSel < indexArray.length; ++idxSel) {
            selItem = paraArray[indexArray[idxSel] + 1];
            int idxStyle = selItem.indexOf(STYLE_NAME);
            if (idxStyle > -1) {
                int idxStyleEnd = selItem.indexOf(62);
                if (idxStyleEnd > -1) {
                    selItem = selItem.substring(0, idxStyleEnd - 1) + " " + cssAttribute + "\">" + selItem.substring(idxStyleEnd + 1);
                }
            } else {
                int startTag_end = selItem.indexOf(PARA_NAME_STARTTAG_END);
                if (startTag_end > -1) {
                    selItem = selItem.substring(0, startTag_end) + " " + normalAttribute + PARA_NAME_STARTTAG_END + selItem.substring(startTag_end + 1);
                }
            }
            paraArray[indexArray[idxSel] + 1] = selItem;
        }
        for (int idxPara = idxOffset + 1; idxPara < paraArray.length; ++idxPara) {
            newString.append(PARA_NAME_STARTTAG_START + paraArray[idxPara]);
        }
        plainTextString = newString.toString();
        return plainTextString;
    }

    public static PDFXObjectForm generateTextLayout(PDFDocument doc, PDFFontSet systemFonts, RCGOptions options, StyleAttributes styleAttr, String textString, Locale locale, boolean isRichText, boolean buildFontSet, HashMap afePDFFontMap, boolean isMultiLine, boolean autoSize, TextFormatter textFormatter) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException {
        try {
            PDFFontSet pdfFonts = null;
            pdfFonts = buildFontSet ? PDFFontSetUtil.buildWorkingFontSet(doc, systemFonts, locale, afePDFFontMap) : systemFonts;
            if (textFormatter == null) {
                textFormatter = new TextFormatterImpl(doc);
            }
            PDFXObjectForm appearance = PDFXObjectForm.newInstance(doc);
            PDFResources resources = PDFResources.newInstance(doc);
            OutputByteStream xobjectContents = doc.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            ContentWriter xobjectContentWriter = ContentWriter.newInstance(doc, xobjectContents);
            AppearanceAttributes appearanceAttributes = new AppearanceAttributes(styleAttr, options);
            appearanceAttributes.setAutoSize(autoSize);
            appearanceAttributes.setMultiLine(isMultiLine);
            appearanceAttributes.setRichText(isRichText);
            appearanceAttributes.setTextValue(textString);
            TextAppearance.formatText(xobjectContentWriter, doc, resources, pdfFonts, afePDFFontMap, appearanceAttributes, textFormatter);
            if (xobjectContents.length() == 0L) {
                xobjectContents.close();
                xobjectContents = null;
                return null;
            }
            InputByteStream streamData = xobjectContents.closeAndConvert();
            xobjectContents = null;
            appearance.setResources(resources);
            appearance.setStream(streamData);
            streamData = null;
            return appearance;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }
}

