/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;
import java.math.BigInteger;

public class FragmentListBox
extends Jpeg2000Box {
    private int numberOfFragments;
    private BigInteger[] offsetsList;
    private long[] lengthsOfFragments;
    private int[] dataReferencesList;

    FragmentListBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getNumberOfFragments() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfFragments;
    }

    public BigInteger[] getOffsetsList() throws IOException {
        this.lazilyPopulateFields();
        return this.offsetsList;
    }

    public long[] getLengthsOfFragments() throws IOException {
        this.lazilyPopulateFields();
        return this.lengthsOfFragments;
    }

    public int[] getDataReferencesList() throws IOException {
        this.lazilyPopulateFields();
        return this.dataReferencesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.numberOfFragments = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.offsetsList = new BigInteger[this.numberOfFragments];
            this.lengthsOfFragments = new long[this.numberOfFragments];
            this.dataReferencesList = new int[this.numberOfFragments];
            byte[] offsetBytes = new byte[8];
            for (int i = 0; i < this.numberOfFragments; ++i) {
                boxContents.read(offsetBytes);
                this.offsetsList[i] = new BigInteger(offsetBytes);
                this.lengthsOfFragments[i] = Jpeg2000Utils.bytesToLong(boxContents, 4);
                this.dataReferencesList[i] = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

