/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class DataEntryURLBox
extends Jpeg2000Box {
    private int versionNumber;
    private int flag;
    private InputByteStream location;

    DataEntryURLBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getVersionNumber() throws IOException {
        this.lazilyPopulateFields();
        return this.versionNumber;
    }

    public int getFlag() throws IOException {
        this.lazilyPopulateFields();
        return this.flag;
    }

    public InputByteStream getLocation() throws IOException {
        this.lazilyPopulateFields();
        return this.location != null ? this.location.slice() : null;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.versionNumber = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            this.flag = Jpeg2000Utils.bytesToInteger(boxContents, 3);
            this.location = boxContents.slice(boxContents.getPosition(), boxContents.bytesAvailable());
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        try {
            if (this.location != null) {
                this.location.close();
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

