/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;
import java.util.ArrayList;

public class CodestreamRegistrationBox
extends Jpeg2000Box {
    private int horizontalGridSize;
    private int verticalGridSize;
    private ArrayList<Integer> codestreamNumbersList;
    private ArrayList<Integer> horizontalResolutionsList;
    private ArrayList<Integer> verticalResolutionsList;
    private ArrayList<Integer> horizontalOffsetsList;
    private ArrayList<Integer> verticalOffsetsList;

    CodestreamRegistrationBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getHorizontalGridSize() throws IOException {
        this.lazilyPopulateFields();
        return this.horizontalGridSize;
    }

    public int getVerticalGridSize() throws IOException {
        this.lazilyPopulateFields();
        return this.verticalGridSize;
    }

    public ArrayList<Integer> getCodestreamNumbersList() throws IOException {
        this.lazilyPopulateFields();
        return this.codestreamNumbersList;
    }

    public ArrayList<Integer> getHorizontalResolutionsList() throws IOException {
        this.lazilyPopulateFields();
        return this.horizontalResolutionsList;
    }

    public ArrayList<Integer> getVerticalResolutionsList() throws IOException {
        this.lazilyPopulateFields();
        return this.verticalResolutionsList;
    }

    public ArrayList<Integer> getHorizontalOffsetsList() throws IOException {
        this.lazilyPopulateFields();
        return this.horizontalOffsetsList;
    }

    public ArrayList<Integer> getVerticalOffsetsList() throws IOException {
        this.lazilyPopulateFields();
        return this.verticalOffsetsList;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.horizontalGridSize = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.verticalGridSize = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.codestreamNumbersList = new ArrayList();
            this.horizontalResolutionsList = new ArrayList();
            this.verticalResolutionsList = new ArrayList();
            this.horizontalOffsetsList = new ArrayList();
            this.verticalOffsetsList = new ArrayList();
            while (boxContents.bytesAvailable() > 0L) {
                this.codestreamNumbersList.add(Jpeg2000Utils.bytesToInteger(boxContents, 2));
                this.horizontalResolutionsList.add(Jpeg2000Utils.bytesToInteger(boxContents, 1));
                this.verticalResolutionsList.add(Jpeg2000Utils.bytesToInteger(boxContents, 1));
                this.horizontalOffsetsList.add(Jpeg2000Utils.bytesToInteger(boxContents, 1));
                this.verticalOffsetsList.add(Jpeg2000Utils.bytesToInteger(boxContents, 1));
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

