/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaInstance;

public class PDFRichMediaInstanceList
extends PDFCosArrayList<PDFRichMediaInstance> {
    private PDFRichMediaInstanceList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaInstanceList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaInstanceList pdfObject = (PDFRichMediaInstanceList)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaInstanceList.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaInstanceList(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFRichMediaInstance itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaInstance.getInstance(cosObject);
    }

    public static PDFRichMediaInstanceList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFRichMediaInstanceList pdfObject = new PDFRichMediaInstanceList(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaInstanceList newInstance(PDFDocument pdfDocument, PDFRichMediaInstanceList instances) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (instances.size() > 0) {
            CosArray cosObject = PDFCosObject.makeCosArray(pdfDocument, instances);
            return PDFRichMediaInstanceList.getInstance(cosObject);
        }
        return PDFRichMediaInstanceList.newInstance(pdfDocument);
    }
}

