/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaInstanceList;

public class PDFRichMediaConfiguration
extends PDFCosDictionary {
    public static final ASName k_Name = ASName.create("Name");
    public static final ASName k_Instances = ASName.create("Instances");
    public static final ASName k_RichMediaConfiguration = ASName.create("RichMediaConfiguration");
    public static final ASName k_3D = ASName.create("3D");
    public static final ASName k_Flash = ASName.create("Flash");
    public static final ASName k_Sound = ASName.create("Sound");
    public static final ASName k_Video = ASName.create("Video");

    private PDFRichMediaConfiguration(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaConfiguration newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaConfiguration pdfObject = new PDFRichMediaConfiguration(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaConfiguration getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaConfiguration pdfObject = (PDFRichMediaConfiguration)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaConfiguration.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaConfiguration(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(k_RichMediaConfiguration)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidDocumentException("Type value is not valid. " + k_RichMediaConfiguration + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Subtype);
    }

    public void setSubtype(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Subtype);
        } else if (value.equals(k_3D) || value.equals(k_Flash) || value.equals(k_Sound) || value.equals(k_Video)) {
            this.setDictionaryNameValue(ASName.k_Subtype, value);
        } else {
            throw new PDFInvalidParameterException("Subtype value is out of bound.");
        }
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Subtype);
    }

    public PDFText getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_Name));
    }

    public void setName(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Name, value);
    }

    public boolean hasName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Name);
    }

    public PDFRichMediaInstanceList getInstances() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_Instances);
        return PDFRichMediaInstanceList.getInstance(cosObject);
    }

    public void setInstances(PDFRichMediaInstanceList value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Instances, value);
    }

    public boolean hasInstances() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Instances);
    }
}

