/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFBestEffortMediaScreenParams;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMustHonorMediaScreenParams;

public class PDFMediaScreenParams
extends PDFCosDictionary {
    private PDFMediaScreenParams(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMediaScreenParams newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMediaScreenParams pdfObject = new PDFMediaScreenParams(cosObject);
        pdfObject.setType();
        return pdfObject;
    }

    public static PDFMediaScreenParams getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMediaScreenParams pdfObject = (PDFMediaScreenParams)PDFCosObject.getCachedInstance(cosObject, PDFMediaScreenParams.class);
        if (pdfObject == null) {
            pdfObject = new PDFMediaScreenParams(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_MediaScreenParams);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFBestEffortMediaScreenParams getBE() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBestEffortMediaScreenParams.getInstance(this.getDictionaryCosObjectValue(ASName.k_BE));
    }

    public void setBE(PDFBestEffortMediaScreenParams value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_BE, value);
    }

    public boolean hasBE() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BE);
    }

    public PDFMustHonorMediaScreenParams getMH() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMustHonorMediaScreenParams.getInstance(this.getDictionaryCosObjectValue(ASName.k_MH));
    }

    public void setMH(PDFMustHonorMediaScreenParams value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_MH, value);
    }

    public boolean hasMH() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MH);
    }
}

