/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurement;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVPDict;

public class PDF3DMeasurement3DC
extends PDF3DMeasurement {
    public static final ASName k_3DC = ASName.create("3DC");
    public static final ASName k_A1 = ASName.create("A1");
    public static final ASName k_N1 = ASName.create("N1");
    public static final ASName k_TP = ASName.create("TP");
    public static final ASName k_TB = ASName.create("TB");
    public static final ASName k_TS = ASName.create("TS");
    public static final ASName k_C = ASName.create("C");
    public static final ASName k_UT = ASName.create("UT");
    public static final ASName k_S = ASName.create("S");

    private PDF3DMeasurement3DC(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DMeasurement3DC newInstance(PDFDocument pdfDocument, double[] a1, double[] tp) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDF3DMeasurement3DC pdfObject = new PDF3DMeasurement3DC(cosObject);
        try {
            pdfObject.setSubtype(k_3DC);
        }
        catch (PDFInvalidParameterException pDFInvalidParameterException) {
            // empty catch block
        }
        pdfObject.setA1(a1);
        pdfObject.setTP(tp);
        return pdfObject;
    }

    public static PDF3DMeasurement3DC getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DMeasurement3DC pdfObject = (PDF3DMeasurement3DC)PDFCosObject.getCachedInstance(cosObject, PDF3DMeasurement3DC.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DMeasurement3DC(cosObject);
        }
        return pdfObject;
    }

    public double[] getA1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_A1);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble();
    }

    public void setA1(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("A1 is a required key.");
        }
        this.setDictionaryArrayValue(k_A1, value);
    }

    public boolean hasA1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_A1);
    }

    public PDFText getN1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_N1));
    }

    public void setN1(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryTextValue(k_N1, value);
    }

    public boolean hasN1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_N1);
    }

    public double[] getTP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_TP);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble();
    }

    public void setTP(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("TP is a required key.");
        }
        this.setDictionaryArrayValue(k_TP, value);
    }

    public boolean hasTP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TP);
    }

    public double[] getTB() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_TB);
        if (cosObject != null) {
            return cosObject.getArrayDouble();
        }
        return null;
    }

    public void setTB(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(k_TB, value);
    }

    public boolean hasTB() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TB);
    }

    public double getTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_TS);
    }

    public void setTS(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_TS, value);
    }

    public boolean hasTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TS);
    }

    public double[] getC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_C);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble(1, 3);
    }

    public void setC(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(k_C);
        } else {
            CosArray array = this.setDictionaryArrayValue(k_C, 1, value);
            array.setName(0, ASName.k_DeviceRGB);
        }
    }

    public boolean hasC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_C);
    }

    public PDFText getUT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_UT));
    }

    public void setUT(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryTextValue(k_UT, value);
    }

    public boolean hasUT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_UT);
    }

    public PDF3DVPDict getS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DVPDict.getInstance(this.getDictionaryCosObjectValue(k_S));
    }

    public void setS(CosDictionary cosDictionary) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_S, cosDictionary);
    }

    public boolean hasS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_S);
    }
}

