/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.metadata;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.PaddedInputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PDFMetadata
extends PDFCosStream {
    private static final byte[] xmptag = new byte[]{60, 120, 58, 120, 109, 112, 109, 101, 116, 97};
    private static final byte[] xaptag = new byte[]{60, 120, 58, 120, 97, 112, 109, 101, 116, 97};
    private static final byte[] xmpendtag = new byte[]{60, 47, 120, 58, 120, 109, 112, 109, 101, 116, 97};
    private static final byte[] xapendtag = new byte[]{60, 47, 120, 58, 120, 97, 112, 109, 101, 116, 97};
    private static final byte[] closetag = new byte[]{62};

    private PDFMetadata(CosObject cosStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosStream);
    }

    public static PDFMetadata getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMetadata pdfObject = (PDFMetadata)PDFCosObject.getCachedInstance(cosObject, PDFMetadata.class);
        if (pdfObject == null) {
            pdfObject = new PDFMetadata(cosObject);
        }
        return pdfObject;
    }

    private static PDFMetadata newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosStream cosObject = PDFCosObject.newCosStream(pdfDocument);
        PDFMetadata pdfObject = new PDFMetadata(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_Metadata);
        pdfObject.setDictionaryNameValue(ASName.k_Subtype, ASName.k_XML);
        return pdfObject;
    }

    public static PDFMetadata newInstance(PDFDocument pdfDocument, InputByteStream metadata) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (metadata == null) {
            return null;
        }
        PDFMetadata pdfMetadata = PDFMetadata.newInstance(pdfDocument);
        try {
            pdfMetadata.setStreamData(metadata.toInputStream());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return pdfMetadata;
    }

    public static PDFMetadata newInstance(PDFDocument pdfDocument, InputStream metadata, int padding) throws PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFMetadata pdfMetadata = PDFMetadata.newInstance(pdfDocument);
        pdfMetadata.setData(metadata, padding);
        return pdfMetadata;
    }

    private InputByteStream getData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            CosStream cosMetadata = this.getCosStream();
            InputByteStream metaData = cosMetadata.getStreamDecoded();
            long[] xmpStartEndIndex = this.getXMPMetadata(metaData);
            if (xmpStartEndIndex != null && xmpStartEndIndex.length == 2 && xmpStartEndIndex[0] != -1L && xmpStartEndIndex[1] != -1L) {
                InputByteStream metaDataSlice = metaData.slice(xmpStartEndIndex[0], xmpStartEndIndex[1] - xmpStartEndIndex[0] + 1L);
                metaData.close();
                metaData = null;
                return metaDataSlice;
            }
            return null;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public boolean getData(OutputStream dataStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            InputByteStream returnData = this.getData();
            if (returnData == null) {
                return false;
            }
            IO.copy(returnData, dataStream);
            returnData.close();
            returnData = null;
            return true;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private long[] getXMPMetadata(InputByteStream searchStm) throws IOException {
        long[] startEndIndex = new long[]{-1L, -1L};
        startEndIndex = this.findXMPTag(searchStm, xmptag, xmpendtag);
        if (startEndIndex == null || startEndIndex.length != 2 || startEndIndex[0] == -1L || startEndIndex[1] == -1L) {
            startEndIndex = this.findXMPTag(searchStm, xaptag, xapendtag);
        }
        return startEndIndex;
    }

    private long[] findXMPTag(InputByteStream searchStm, byte[] startTag, byte[] endTag) throws IOException {
        long[] startEndIndex = new long[]{-1L, -1L};
        searchStm.seek(0L);
        int[] startTagKMPArray = Utility.ComputeKMPNextArray(startTag);
        long metastart = Utility.KMPFindFirst(startTag, startTagKMPArray, searchStm);
        if (metastart != -1L) {
            int[] endTagKMPArray = Utility.ComputeKMPNextArray(endTag);
            long metaend = Utility.KMPFindFirst(endTag, endTagKMPArray, searchStm);
            long dataend = -1L;
            if (metaend != -1L) {
                searchStm.seek(metaend);
                int[] closeTagKMPArray = Utility.ComputeKMPNextArray(closetag);
                dataend = Utility.KMPFindFirst(closetag, closeTagKMPArray, searchStm);
            }
            if (dataend == -1L) {
                dataend = searchStm.length() - 1L;
            }
            startEndIndex[0] = metastart;
            startEndIndex[1] = dataend;
        }
        return startEndIndex;
    }

    public void setData(InputStream metadata, int padding) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        try {
            OutputByteStream obs = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, metadata.available());
            IO.copy(metadata, obs);
            PaddedInputByteStream newData = new PaddedInputByteStream(obs.closeAndConvert(), 32, padding);
            obs = null;
            this.getCosStream().newDataDecoded(newData);
            newData = null;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public boolean getXMLData(OutputStream dataStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosStream().copyStream(dataStream, false);
    }
}

