/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionColors;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFolder;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionItem;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNavigator;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionResourcesTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSchema;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSort;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSplit;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionUtil;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionView;
import java.util.ArrayList;
import java.util.Iterator;

public class PDFPortableCollection
extends PDFCosDictionary {
    public static final ASName k_Collection = ASName.create("Collection");
    public static final ASName k_Schema = ASName.create("Schema");
    public static final ASName k_Sort = ASName.create("Sort");
    public static final ASName k_Split = ASName.create("Split");
    public static final ASName k_Colors = ASName.create("Colors");
    public static final ASName k_Navigator = ASName.create("Navigator");
    public static final ASName k_Folders = ASName.create("Folders");

    private PDFPortableCollection(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPortableCollection getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPortableCollection pdfObject = (PDFPortableCollection)PDFCosObject.getCachedInstance(cosObject, PDFPortableCollection.class);
        if (pdfObject == null) {
            pdfObject = new PDFPortableCollection(cosObject);
        }
        return pdfObject;
    }

    public static PDFPortableCollection newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFPortableCollection pdfObject = new PDFPortableCollection(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_Collection);
        return pdfObject;
    }

    public PDFCollectionSchema getSchema() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionSchema.getInstance(this.getDictionaryDictionaryValue(k_Schema));
    }

    public void setSchema(PDFCollectionSchema schema) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (schema != null) {
            this.setDictionaryValue(k_Schema, schema);
        } else {
            this.removeValue(k_Schema);
        }
    }

    public PDFCollectionSchema procureSchema() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionSchema schema = this.getSchema();
        if (schema == null) {
            schema = PDFCollectionSchema.newInstance(this.getPDFDocument());
            this.setSchema(schema);
        }
        return schema;
    }

    public PDFCollectionSort getSort() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionSort.getInstance(this.getDictionaryDictionaryValue(k_Sort));
    }

    public void setSort(PDFCollectionSort sort) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (sort != null) {
            this.setDictionaryValue(k_Sort, sort);
        } else {
            this.removeValue(k_Sort);
        }
    }

    public PDFCollectionSort procureSort() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionSort sort = this.getSort();
        if (sort == null) {
            try {
                sort = PDFCollectionSort.newInstance(this.getPDFDocument(), new ASName[1]);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException(e);
            }
            this.setSort(sort);
        }
        return sort;
    }

    public PDFCollectionView getView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionView.getInstance(this.getDictionaryNameValue(ASName.k_View));
    }

    public void setView(PDFCollectionView view) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (view == null) {
            this.removeValue(ASName.k_View);
        } else {
            this.setDictionaryNameValue(ASName.k_View, view.getView());
        }
    }

    public PDFCollectionSplit getSplit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionSplit.getInstance(this.getDictionaryDictionaryValue(k_Split));
    }

    public void setSplit(PDFCollectionSplit split) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (split == null) {
            this.removeValue(k_Split);
        } else {
            this.setDictionaryValue(k_Split, split);
        }
    }

    public PDFCollectionColors getColors() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionColors.getInstance(this.getDictionaryDictionaryValue(k_Colors));
    }

    public void setColors(PDFCollectionColors colors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (colors == null) {
            this.removeValue(k_Colors);
        } else {
            this.setDictionaryValue(k_Colors, colors);
        }
    }

    public PDFCollectionNavigator getNavigator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionNavigator.getInstance(this.getDictionaryDictionaryValue(k_Navigator));
    }

    public void setNavigator(PDFCollectionNavigator navigator) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (navigator == null) {
            this.removeValue(k_Navigator);
        } else {
            this.setDictionaryValue(k_Navigator, navigator);
        }
    }

    public PDFCollectionResourcesTree getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionResourcesTree.getInstance(this.getDictionaryDictionaryValue(ASName.k_Resources));
    }

    public void setResources(PDFCollectionResourcesTree resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (resources == null) {
            this.removeValue(ASName.k_Resources);
        } else {
            this.setDictionaryValue(ASName.k_Resources, resources);
        }
    }

    public ASString getInitialDocumentName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_D);
    }

    public void setInitialDocumentName(ASString name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (name != null) {
            this.setDictionaryASStringValue(ASName.k_D, name);
        } else {
            this.removeValue(ASName.k_D);
        }
    }

    public PDFCollectionFolder setRootFolder(String name, String desc, ASDate creationDate, ASDate modDate, PDFXObject thumb, PDFCollectionItem ci) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionFolder root = this.setRootFolder(name);
        root.setDescription(desc);
        root.setCreationDate(creationDate);
        root.setModificationDate(modDate);
        root.setThumb(thumb);
        root.setCollectionItem(ci);
        this.setDictionaryValue(k_Folders, root);
        return root;
    }

    public PDFCollectionFolder setRootFolder(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (name == null) {
            this.removeValue(k_Folders);
            return null;
        }
        long newID = 0L;
        PDFCollectionFolder root = PDFCollectionFolder.newInstanceFolderRoot(this.getPDFDocument(), name, newID);
        CosDocument cosDoc = this.getPDFDocument().getCosDocument();
        ArrayList<CosNumeric> freeList = new ArrayList<CosNumeric>();
        freeList.add(cosDoc.createCosNumeric(1L));
        freeList.add(cosDoc.createCosNumeric((long)Integer.MAX_VALUE));
        CosArray newFreeObj = this.getPDFDocument().getCosDocument().createCosArray(freeList);
        root.setFree(newFreeObj);
        this.setDictionaryValue(k_Folders, root);
        return root;
    }

    public PDFCollectionFolder getFolder(String[] path) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (path == null || path.length == 0) {
            return this.getRootFolder();
        }
        if (this.dictionaryContains(k_Folders)) {
            PDFCollectionFolder folder = this.getRootFolder();
            for (int i = 0; i < path.length; ++i) {
                ArrayList<PDFCollectionFolder> children = folder.getChildren();
                Iterator<PDFCollectionFolder> iter = children.iterator();
                boolean found = false;
                while (iter.hasNext()) {
                    PDFCollectionFolder f = iter.next();
                    if (!f.getName().equals(path[i])) continue;
                    folder = f;
                    found = true;
                    break;
                }
                if (found) continue;
                return null;
            }
            return folder;
        }
        return null;
    }

    public PDFCollectionFolder getRootFolder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_Folders)) {
            return PDFCollectionFolder.getInstance(this.getDictionaryValue(k_Folders));
        }
        return null;
    }

    public void removeRootFolder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFParseException {
        if (this.dictionaryContains(k_Folders)) {
            PDFCollectionUtil.removePDFCollectionFolder(this.getRootFolder());
        }
    }
}

