/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.agl.text.Collator;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFile;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFileInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionField;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionItem;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSchema;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSort;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSortItem;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSortIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFPortableCollection;
import java.util.Comparator;

public class PDFCollectionItemComparator
implements Comparator {
    private PDFCollectionSortItem[] mSortItems;
    private PDFCollectionSchema mSchema = null;
    private Collator mCollator;

    public PDFCollectionItemComparator(PDFCollectionSort sort, Collator collator) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int sortInd = 0;
        this.mCollator = collator;
        PDFCollectionSortIterator nameIter = sort.getSortIterator();
        this.mSortItems = new PDFCollectionSortItem[nameIter.size()];
        while (nameIter.hasNext()) {
            this.mSortItems[sortInd++] = nameIter.nextItem();
        }
        PDFPortableCollection collection = sort.getPDFDocument().requireCatalog().getCollection();
        if (collection == null) {
            throw new PDFInvalidDocumentException("Collection is not defined");
        }
        this.mSchema = collection.getSchema();
        if (this.mSchema == null) {
            throw new PDFInvalidDocumentException("Collection Schema is not defined");
        }
    }

    public PDFCollectionItemComparator(PDFCollectionSort sort) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this(sort, null);
    }

    public int compare(Object arg0, Object arg1) {
        PDFTree.Entry first = (PDFTree.Entry)arg0;
        PDFTree.Entry second = (PDFTree.Entry)arg1;
        int compared = 0;
        PDFFileSpecification firstSpec = (PDFFileSpecification)first.getValue();
        PDFFileSpecification secondSpec = (PDFFileSpecification)second.getValue();
        int sortInd = 0;
        while (sortInd < this.mSortItems.length && compared == 0) {
            try {
                compared = this.compareSpecs(firstSpec, secondSpec, sortInd++);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return compared;
    }

    private int compareSpecs(PDFFileSpecification first, PDFFileSpecification second, int sortInd) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int compared = 0;
        PDFCollectionSortItem sortItem = this.mSortItems[sortInd];
        int direction = sortItem.getOrder() ? 1 : -1;
        ASName key = sortItem.getName();
        PDFCollectionField field = this.mSchema.get(key);
        if (field == null) {
            return -direction;
        }
        PDFCollectionFieldType fieldType = field.getFieldType();
        if (fieldType.isInCollectionItem()) {
            PDFCollectionItem firstItem = first.getCollectionItem();
            PDFCollectionItem secondItem = second.getCollectionItem();
            if (firstItem == null) {
                if (secondItem == null) {
                    return 0;
                }
                return -1 * direction;
            }
            if (secondItem == null) {
                return 1 * direction;
            }
            if (firstItem.containsKey((Object)key) && !secondItem.containsKey((Object)key)) {
                return 1 * direction;
            }
            if (!firstItem.containsKey((Object)key) && secondItem.containsKey((Object)key)) {
                return -1 * direction;
            }
            if (!firstItem.containsKey((Object)key) && !secondItem.containsKey((Object)key)) {
                return 0;
            }
            if (fieldType.equal(PDFCollectionFieldType.date)) {
                compared = PDFCollectionItemComparator.compareDates(firstItem.getItemData(key).getDate(), secondItem.getItemData(key).getDate());
            } else if (fieldType.equal(PDFCollectionFieldType.number)) {
                compared = PDFCollectionItemComparator.compareNumbers(firstItem.getItemData(key).getNumber(), secondItem.getItemData(key).getNumber());
            } else if (fieldType.equal(PDFCollectionFieldType.text)) {
                String firstText = firstItem.getItemData(key).getText();
                String secondText = secondItem.getItemData(key).getText();
                compared = PDFCollectionItemComparator.compareText(firstText, secondText, this.mCollator);
            }
        } else if (fieldType.isInFileSpec()) {
            if (fieldType.equal(PDFCollectionFieldType.file)) {
                String text1 = first.getUnicodeName();
                String text2 = second.getUnicodeName();
                if (text1 != null && text2 != null) {
                    compared = PDFCollectionItemComparator.compareText(text1, text2, null);
                } else {
                    ASString name1 = text1 == null ? first.getFilename() : new ASString(text1);
                    ASString name2 = text2 == null ? first.getFilename() : new ASString(text2);
                    compared = PDFCollectionItemComparator.compareStrings(name1, name2);
                }
            } else if (fieldType.equal(PDFCollectionFieldType.Desc)) {
                String desc1 = first.getDescription();
                String desc2 = second.getDescription();
                compared = PDFCollectionItemComparator.compareText(desc1, desc2, null);
            }
        } else if (fieldType.isInEmbeddedFile()) {
            PDFEmbeddedFile firstFile = first.getEmbeddedFile();
            PDFEmbeddedFile secondFile = second.getEmbeddedFile();
            if (firstFile != null && secondFile != null) {
                PDFEmbeddedFileInfo firstInfo = firstFile.getFileInfo();
                PDFEmbeddedFileInfo secondInfo = secondFile.getFileInfo();
                if (firstInfo != null && secondInfo != null) {
                    if (fieldType.equal(PDFCollectionFieldType.CreationDate)) {
                        compared = PDFCollectionItemComparator.compareDates(firstInfo.getCreationDate(), secondInfo.getCreationDate());
                    } else if (fieldType.equal(PDFCollectionFieldType.ModDate)) {
                        compared = PDFCollectionItemComparator.compareDates(firstInfo.getModificationDate(), secondInfo.getModificationDate());
                    } else if (fieldType.equal(PDFCollectionFieldType.size)) {
                        compared = PDFCollectionItemComparator.compareNumbers(firstInfo.getSize(), secondInfo.getSize());
                    } else if (fieldType.equal(PDFCollectionFieldType.compressedSize)) {
                        compared = PDFCollectionItemComparator.compareNumbers(new Double(first.getCosStream().getLong(ASName.k_Length).longValue()), new Double(second.getCosStream().getLong(ASName.k_Length).longValue()));
                    }
                }
            }
        }
        return compared * direction;
    }

    protected static int compareDates(ASDate first, ASDate second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return first.compareTo(second);
    }

    protected static int compareNumbers(Number first, Number second) {
        long num2;
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        long num1 = Double.doubleToLongBits(first.doubleValue());
        if (num1 == (num2 = Double.doubleToLongBits(second.doubleValue()))) {
            return 0;
        }
        return num1 < num2 ? -1 : 1;
    }

    protected static int compareText(String first, String second, Collator collator) {
        if (first == null && second != null) {
            return -1;
        }
        if (first != null && second == null) {
            return 1;
        }
        if (first == null && second == null) {
            return 0;
        }
        return collator == null ? first.compareTo(second) : collator.compare(first, second);
    }

    protected static int compareStrings(ASString first, ASString second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return first.compareTo(second);
    }
}

