/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionData;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionItemData;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNameIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSubItem;

public class PDFCollectionItem
extends PDFCosDictionaryMap<PDFCollectionData> {
    public static final ASName k_CollectionItem = ASName.create("CollectionItem");
    private ASName mFieldKey = null;

    private PDFCollectionItem(CosObject cosDict) throws PDFInvalidDocumentException {
        super(cosDict);
    }

    public static PDFCollectionItem getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCollectionItem pdfObject = (PDFCollectionItem)PDFCosObject.getCachedInstance(cosObject, PDFCollectionItem.class);
        if (pdfObject == null) {
            pdfObject = new PDFCollectionItem(cosObject);
        }
        return pdfObject;
    }

    public static PDFCollectionItem newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFCollectionItem pdfObject = new PDFCollectionItem(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_CollectionItem);
        return pdfObject;
    }

    @Override
    protected PDFCollectionData itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return cosObject == null ? null : (cosObject.getType() == 6 ? PDFCollectionSubItem.getInstance(cosObject, this.mFieldKey) : PDFCollectionItemData.getInstance(cosObject, this.mFieldKey));
    }

    public PDFCollectionNameIterator getKeyIterator() {
        return new PDFCollectionNameIterator(this);
    }

    private PDFCollectionData getItemsData(ASName key) {
        this.mFieldKey = key;
        PDFCollectionData itemData = (PDFCollectionData)super.get(key);
        this.mFieldKey = null;
        return itemData;
    }

    public boolean isData(ASName fieldKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return fieldKey.equals(ASName.k_Type) ? false : !this.isSubItem(fieldKey);
    }

    public boolean isSubItem(ASName fieldKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject item = this.getDictionaryValue(fieldKey);
        return item != null && item.getType() == 6;
    }

    public PDFCollectionItemData getData(ASName fieldKey) throws PDFInvalidDocumentException {
        PDFCollectionData itemData = this.getItemsData(fieldKey);
        if (!(itemData instanceof PDFCollectionItemData)) {
            throw new PDFInvalidDocumentException("Collection item's entry is not data");
        }
        return (PDFCollectionItemData)itemData;
    }

    public PDFCollectionItemData getItemData(ASName fieldKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.isSubItem(fieldKey) ? this.getSubItem(fieldKey).getData() : (this.isData(fieldKey) ? this.getData(fieldKey) : null);
    }

    public PDFCollectionSubItem getSubItem(ASName fieldKey) throws PDFInvalidDocumentException {
        PDFCollectionData itemData = this.getItemsData(fieldKey);
        if (!(itemData instanceof PDFCollectionSubItem)) {
            throw new PDFInvalidDocumentException("Collection item's entry is not subItem");
        }
        return (PDFCollectionSubItem)itemData;
    }

    public void setSubItem(ASName key, PDFCollectionSubItem item) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super.put(key, item);
    }

    public void setData(ASName key, PDFCollectionItemData data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (data != null) {
            super.put(key, data);
        } else {
            this.removeData(key);
        }
    }

    public PDFCollectionItemData removeData(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionData oldValue = this.getItemsData(key);
        if (oldValue != null && !(oldValue instanceof PDFCollectionItemData)) {
            throw new PDFInvalidDocumentException("Collection item's entry is not data");
        }
        super.removeValue(key);
        return (PDFCollectionItemData)oldValue;
    }

    public PDFCollectionSubItem removeSubItem(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionData oldValue = this.getItemsData(key);
        if (!(oldValue instanceof PDFCollectionSubItem)) {
            throw new PDFInvalidDocumentException("Collection item's entry is not SubItem");
        }
        super.removeValue(key);
        return (PDFCollectionSubItem)oldValue;
    }

    public boolean containsElement(Object key) {
        return this.containsKey(key);
    }
}

