/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.types.ASName;

public enum PDFCollectionFieldType {
    text(ASName.k_S, 1),
    date(ASName.k_D, 1),
    number(ASName.k_N, 1),
    file(ASName.k_F, 2),
    Desc(ASName.k_Desc, 2),
    ModDate(ASName.k_ModDate, 3),
    CreationDate(ASName.k_CreationDate, 3),
    size(ASName.k_Size, 3),
    compressedSize(ASName.k_CompressedSize, 3);

    private ASName mType;
    private int mInItem;

    private PDFCollectionFieldType(ASName type, int inItem) {
        this.mType = type;
        this.mInItem = inItem;
    }

    public static PDFCollectionFieldType getInstance(ASName view) {
        return ASName.k_D.equals(view) ? date : (ASName.k_S.equals(view) ? text : (ASName.k_N.equals(view) ? number : (ASName.k_F.equals(view) ? file : (ASName.k_Desc.equals(view) ? Desc : (ASName.k_ModDate.equals(view) ? ModDate : (ASName.k_CreationDate.equals(view) ? CreationDate : (ASName.k_CompressedSize.equals(view) ? compressedSize : (ASName.k_Size.equals(view) ? size : null))))))));
    }

    ASName getView() {
        return this.mType;
    }

    public boolean isInCollectionItem() {
        return this.mInItem == 1;
    }

    public boolean isInFileSpec() {
        return this.mInItem == 2;
    }

    public boolean isInEmbeddedFile() {
        return this.mInItem == 3;
    }

    public boolean equal(PDFCollectionFieldType view) {
        return this.mType.equals(view.getView());
    }

    public String toString() {
        return this.mType.toString();
    }
}

