/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;

public class PDFBookmarkUtils {
    public static void appendLastKid(PDFBookmark bookmark, PDFBookmarkNode parentBookmarkNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmark lastKid = parentBookmarkNode.getLastKid();
        if (!parentBookmarkNode.dictionaryContains(ASName.k_First)) {
            parentBookmarkNode.setFirst(bookmark);
        }
        if (lastKid != null) {
            lastKid.setNext(bookmark);
        }
        bookmark.setPrevious(lastKid);
        parentBookmarkNode.setLast(bookmark);
        bookmark.setDictionaryValue(ASName.k_Parent, parentBookmarkNode);
    }

    public static void insertAfterKid(PDFBookmark insertAfter, PDFBookmark toInsert, PDFBookmarkNode parentBookmark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmark insertBefore;
        if (toInsert == null) {
            return;
        }
        if (insertAfter == null) {
            insertBefore = parentBookmark.getFirstKid();
            parentBookmark.setFirst(toInsert);
        } else {
            insertBefore = insertAfter.getNext();
            insertAfter.setNext(toInsert);
            toInsert.setPrevious(insertAfter);
        }
        PDFBookmark lastToInsert = null;
        for (PDFBookmark b = toInsert; b != null; b = b.getNext()) {
            b.setParent(parentBookmark);
            lastToInsert = b;
        }
        if (insertBefore == null) {
            parentBookmark.setLast(lastToInsert);
        } else {
            lastToInsert.setNext(insertBefore);
            insertBefore.setPrevious(lastToInsert);
        }
    }

    public static void replaceKid(PDFBookmark toReplace, PDFBookmark toInsert, PDFBookmarkNode parentBookmark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmark previous = toReplace.getPrevious();
        PDFBookmark following = toReplace.getNext();
        if (toInsert == null) {
            if (previous == null) {
                parentBookmark.setFirst(following);
            } else {
                previous.setNext(following);
            }
            if (following == null) {
                parentBookmark.setLast(previous);
            } else {
                following.setPrevious(previous);
            }
            return;
        }
        toInsert.setPrevious(previous);
        if (previous == null) {
            parentBookmark.setFirst(toInsert);
        } else {
            previous.setNext(toInsert);
        }
        PDFBookmark lastToInsert = null;
        for (PDFBookmark b = toInsert; b != null; b = b.getNext()) {
            b.setParent(parentBookmark);
            lastToInsert = b;
        }
        lastToInsert.setNext(following);
        if (following == null) {
            parentBookmark.setLast(lastToInsert);
        } else {
            following.setPrevious(lastToInsert);
        }
    }
}

