/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldWithOptions;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class PDFFieldButton
extends PDFFieldWithOptions {
    static final int kNoToggleToOff = 16384;
    static final int kRadioButton = 32768;
    static final int kPushButton = 65536;
    static final int kRadiosInUnison = 0x2000000;
    public static final ASName offState = ASName.create("Off");
    public static final ASName neutralState = ASName.create("Neutral");
    private static final String DEFAULT_BUTTONNAME = "Button";
    public static final ASName DEFAULT_ON_STATE_NAME = ASName.create("Yes");

    private PDFFieldButton(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFieldButton newInstance(String qualifiedFieldName, PDFPage page, PDFRectangle annotRect, PDFDefaultAppearance da, boolean combineFieldAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (page == null) {
            throw new PDFInvalidParameterException("A page must be provided for the annotation when creating fields.");
        }
        if (annotRect == null) {
            throw new PDFInvalidParameterException("An annotation rectangle must be specified when creating fields.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(page.getPDFDocument());
        PDFFieldButton field = new PDFFieldButton(cosObject);
        PDFInteractiveForm iform = page.getPDFDocument().requireCatalog().procureInteractiveForm();
        PDFFieldNode parent = iform.procureIntermediateFieldNodes(qualifiedFieldName);
        String fieldName = PDFFieldUtils.getTerminalFieldName(qualifiedFieldName);
        field.init(parent, fieldName, page, annotRect, combineFieldAnnot, da);
        return field;
    }

    public static PDFFieldButton newInstance(PDFFieldNode parent, PDFPage page, PDFRectangle annotRect, PDFDefaultAppearance da, boolean combineFieldAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (parent == null) {
            throw new PDFInvalidParameterException("A parent field node must be specified when creating fields.");
        }
        if (page == null) {
            throw new PDFInvalidParameterException("A page must be provided for the annotation when creating fields.");
        }
        if (annotRect == null) {
            throw new PDFInvalidParameterException("An annotation rectangle must be specified when creating fields.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(page.getPDFDocument());
        PDFFieldButton field = new PDFFieldButton(cosObject);
        field.init(parent, null, page, annotRect, combineFieldAnnot, da);
        return field;
    }

    private void init(PDFFieldNode parent, String fieldName, PDFPage page, PDFRectangle annotRect, boolean combineFieldAnnot, PDFDefaultAppearance da) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.init(parent, fieldName, DEFAULT_BUTTONNAME, da, false);
        PDFAnnotationWidget widget = this.initWidgetAnnot(page, annotRect, combineFieldAnnot);
        this.initButtonAttributes(widget);
    }

    private void initButtonAttributes(PDFAnnotationWidget widget) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_FT, ASName.k_Btn);
        this.setNameValue(ASName.create("Yes"));
        widget.setAppearanceState(true);
    }

    public static PDFFieldButton getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFieldButton pdfObject = (PDFFieldButton)PDFCosObject.getCachedInstance(cosObject, PDFFieldButton.class);
        if (pdfObject == null) {
            pdfObject = new PDFFieldButton(cosObject);
        }
        return pdfObject;
    }

    public boolean isPushButton() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (super.getFlags() & 0x10000) != 0;
    }

    public boolean isCheckBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return !this.isPushButton() && !this.isRadioButton();
    }

    public boolean isRadioButton() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (super.getFlags() & 0x8000) != 0;
    }

    public void setRadioButton() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int flg = this.getFlags();
        this.setFlags(flg |= 0x8000);
    }

    public void setPushButon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int flg = this.getFlags();
        this.setFlags(flg |= 0x10000);
    }

    public void setCheckBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int flags = this.getFlags();
        int mask = -32769;
        flags &= mask;
        mask = -65537;
        this.setFlags(flags &= mask);
    }

    public boolean isRadiosInUnison() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x2000000) != 0;
    }

    public void setRadiosInUnison(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            int flg = this.getFlags();
            this.setFlags(flg |= 0x2000000);
        } else {
            int flags = this.getFlags();
            int mask = -33554433;
            this.setFlags(flags &= mask);
        }
    }

    public Object getValue() throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_AS).asString();
    }

    public void setStateFromValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject values = this.getCosDictionary().get(ASName.k_V);
        if (values == null || !(values instanceof CosName) || this.isPushButton()) {
            return;
        }
        PDFAnnotationIterator widgetsIterator = this.getAnnotationsIterator();
        ASName onState = ((CosName)values).nameValue();
        boolean oneTime = false;
        if (widgetsIterator != null) {
            while (widgetsIterator.hasNext()) {
                PDFAnnotationWidget widget = (PDFAnnotationWidget)widgetsIterator.next();
                PDFAppearance widgetAppearance = widget.getAppearance();
                CosObject normalAppearance = widgetAppearance.getCosDictionary().get(ASName.k_N);
                if (normalAppearance == null) {
                    normalAppearance = widgetAppearance.getCosDictionary().get(ASName.k_D);
                }
                if (normalAppearance == null || normalAppearance.getType() != 6) continue;
                widget.setDictionaryNameValue(ASName.k_AS, offState);
                if (!((CosDictionary)normalAppearance).containsKey(onState) || oneTime) continue;
                widget.setDictionaryNameValue(ASName.k_AS, onState);
                if (!this.isRadioButton() || this.isRadiosInUnison()) continue;
                oneTime = true;
            }
        }
    }
}

