/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsField;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsPage;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsWidget;
import java.util.List;

public abstract class PDFAdditionalActions
extends PDFCosDictionaryMap<PDFAction> {
    private static final ASName[] widgetActions = new ASName[]{ASName.k_E, ASName.k_X, ASName.k_D, ASName.k_U, ASName.k_Fo, ASName.k_BI, ASName.k_PO, ASName.k_PC, ASName.k_PV, ASName.k_PI};

    protected PDFAdditionalActions(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFAdditionalActions getInstance(CosObject cosObject, PDFAdditionalActions type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        if (type == null) {
            return PDFAdditionalActions.guessType(cosObject);
        }
        if (type instanceof PDFAdditionalActionsDocument) {
            return PDFAdditionalActionsDocument.getInstance(cosObject);
        }
        if (type instanceof PDFAdditionalActionsPage) {
            return PDFAdditionalActionsPage.getInstance(cosObject);
        }
        if (type instanceof PDFAdditionalActionsField) {
            return PDFAdditionalActionsField.getInstance(cosObject);
        }
        if (type instanceof PDFAdditionalActionsAnnotation) {
            return PDFAdditionalActionsAnnotation.getInstance(cosObject);
        }
        if (type instanceof PDFAdditionalActionsWidget) {
            PDFAdditionalActionsWidget.getInstance(cosObject);
        }
        return null;
    }

    private static PDFAdditionalActions guessType(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!(cosObject instanceof CosDictionary)) {
            return null;
        }
        CosDictionary actionDict = (CosDictionary)cosObject;
        boolean isWidget = false;
        List<ASName> allKeys = actionDict.getKeys();
        if (allKeys == null) {
            return null;
        }
        for (ASName curKey : allKeys) {
            if (!Utility.nameInArray(curKey, widgetActions)) continue;
            isWidget = true;
            break;
        }
        return isWidget ? PDFAdditionalActionsWidget.getInstance(actionDict) : PDFAdditionalActionsField.getInstance(actionDict);
    }
}

