/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFTransition;

public class PDFActionTransition
extends PDFAction {
    private PDFActionTransition(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionTransition(PDFDocument pdfDocument, PDFTransition key_Trans) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(pdfDocument);
        this.setSubtype(ASName.create("Trans"));
        this.setTrans(key_Trans);
    }

    public static PDFActionTransition newInstance(PDFDocument pdfDocument, PDFTransition key_Trans) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Trans == null) {
            throw new PDFInvalidParameterException("Trans is required when creating newInstance of PDFActionTransition.");
        }
        return new PDFActionTransition(pdfDocument, key_Trans);
    }

    public static PDFActionTransition getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionTransition pdfObject = (PDFActionTransition)PDFCosObject.getCachedInstance(cosObject, PDFActionTransition.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionTransition(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionTransition newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionTrans = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionTrans.put(ASName.k_Type, ASName.k_Action);
        cosActionTrans.put(ASName.k_S, ASName.k_Trans);
        return PDFActionTransition.getInstance(cosActionTrans);
    }

    public PDFTransition getTrans() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFTransition.getInstance(this.getDictionaryCosObjectValue(ASName.k_Trans));
    }

    public void setTrans(PDFTransition value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Trans is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Trans, value);
    }

    public PDFTransition requireTrans() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFTransition pdfObject = PDFTransition.getInstance(this.getDictionaryCosObjectValue(ASName.k_Trans));
        if (pdfObject == null) {
            throw new PDFInvalidDocumentException("Could not get Trans");
        }
        return pdfObject;
    }

    public boolean hasTrans() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Trans);
    }
}

