/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;

public class PDFActionSetOCGState
extends PDFAction {
    private PDFActionSetOCGState(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionSetOCGState(PDFDocument pdfDocument, ASName key_Subtype, CosArray key_State) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(pdfDocument);
        this.setSubtype(key_Subtype);
        this.setState(key_State);
    }

    public static PDFActionSetOCGState newInstance(PDFDocument pdfDocument, ASName key_Subtype, CosArray key_State) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Subtype == null) {
            throw new PDFInvalidParameterException("Subtype is required when creating newInstance of PDFActionSetOCGState.");
        }
        if (key_State == null) {
            throw new PDFInvalidParameterException("State is required when creating newInstance of PDFActionSetOCGState.");
        }
        return new PDFActionSetOCGState(pdfDocument, key_Subtype, key_State);
    }

    public static PDFActionSetOCGState getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionSetOCGState pdfObject = (PDFActionSetOCGState)PDFCosObject.getCachedInstance(cosObject, PDFActionSetOCGState.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionSetOCGState(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionSetOCGState newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionSetOCGState = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionSetOCGState.put(ASName.k_Type, ASName.k_Action);
        cosActionSetOCGState.put(ASName.k_S, ASName.k_SetOCGState);
        return PDFActionSetOCGState.getInstance(cosActionSetOCGState);
    }

    public CosArray getState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_State);
    }

    public void setState(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("State is a required key therefore cannot be removed.");
        }
        this.setDictionaryArrayValue(ASName.k_State, value);
    }

    public boolean hasState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_State);
    }

    public boolean getPreserveRB() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_PreserveRB);
    }

    public void setPreserveRB(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_PreserveRB, value);
    }

    public boolean hasPreserveRB() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PreserveRB);
    }
}

