/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.document.PDFValueContainer;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;

public class PDFActionHide
extends PDFAction {
    private PDFActionHide(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionHide(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_Hide);
    }

    public static PDFActionHide getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionHide pdfObject = (PDFActionHide)PDFCosObject.getCachedInstance(cosObject, PDFActionHide.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionHide(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionHide newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFActionHide(pdfDocument);
    }

    public PDFFileSpecification getFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    public void setDestination(PDFFileSpecification pdfFileSpecification) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_F, pdfFileSpecification);
    }

    public boolean hasHide() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_H);
    }

    public boolean getHide() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_H);
    }

    public void setHide(boolean hide) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_H, hide);
    }

    public PDFValueContainer<PDFValueContainer.Type, Object> getT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getCosDictionary().get(ASName.k_T);
        PDFValueContainer<PDFValueContainer.Type, Object> container = null;
        if (cosObject instanceof CosString) {
            container = new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.String, cosObject.textValue());
        } else if (cosObject instanceof CosDictionary) {
            container = new PDFValueContainer<PDFValueContainer.Type, PDFAnnotation>(PDFValueContainer.Type.Annotation, PDFAnnotationFactory.getInstance(cosObject));
        } else if (cosObject instanceof CosArray) {
            CosArray array = (CosArray)cosObject;
            int count = array.size();
            CosObject element = array.get(0);
            if (element instanceof CosString) {
                String[] names = new String[count];
                for (int i = 0; i < count; ++i) {
                    names[i] = array.getText(i);
                }
                container = new PDFValueContainer<PDFValueContainer.Type, String[]>(PDFValueContainer.Type.StringArray, names);
            } else if (element instanceof CosDictionary) {
                PDFAnnotationList annotationList = PDFAnnotationList.newInstance(this.getPDFDocument());
                for (int i = 0; i < count; ++i) {
                    annotationList.add(PDFAnnotationFactory.getInstance(array.getCosDictionary(i)));
                }
                container = new PDFValueContainer<PDFValueContainer.Type, PDFAnnotationList>(PDFValueContainer.Type.AnnotationArray, annotationList);
            }
        }
        return container;
    }

    public void setT(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_T, value);
    }

    public void setT(String value, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_T, value, unicode);
    }

    public void setT(PDFAnnotation value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_T, value);
    }

    public void setT(PDFAnnotationList value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_T, value);
    }

    public void setT(String[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = null;
        if (value != null) {
            cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            int addAtIndex = 0;
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == null) continue;
                cosArray.addText(addAtIndex++, value[i]);
            }
        }
        this.setDictionaryArrayValue(ASName.k_T, cosArray);
    }
}

