/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFactory;
import java.util.Set;

public class PDFFontMap
extends PDFCosDictionaryMap<PDFFont> {
    private PDFFontMap(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFontMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFontMap pdfObject = (PDFFontMap)PDFCosObject.getCachedInstance(cosObject, PDFFontMap.class);
        if (pdfObject == null) {
            pdfObject = new PDFFontMap(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFFont itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Object fontObj = PDFFontFactory.getInstance(cosObject);
        if (fontObj instanceof PDFFont) {
            return (PDFFont)fontObj;
        }
        return null;
    }

    public static PDFFontMap newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFFontMap pdfObject = new PDFFontMap(cosObject);
        return pdfObject;
    }

    public PDFFont get(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (super.containsKey(name)) {
            return (PDFFont)super.get(name);
        }
        return null;
    }

    public ASName getNewName(String prefix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (prefix == null) {
            prefix = "F";
        } else {
            ASName retVal = ASName.create(prefix);
            if (this.get(retVal) == null) {
                return retVal;
            }
        }
        int i = 0;
        ASName retVal = ASName.create(prefix + i);
        while (this.get(retVal) != null) {
            retVal = ASName.create(prefix + ++i);
        }
        return retVal;
    }

    public void set(ASName name, PDFFont font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(name, font);
    }

    public boolean containsValue(PDFFont font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (font == null) {
            return false;
        }
        Set<ASName> keySet = this.keySet();
        for (ASName fontName : keySet) {
            PDFFont nextFont = this.get(fontName);
            if (font != nextFont) continue;
            return true;
        }
        return false;
    }

    public boolean containsValueNoThrow(PDFFont font) {
        if (font == null) {
            return false;
        }
        Set<ASName> keySet = this.keySet();
        for (ASName fontName : keySet) {
            try {
                PDFFont nextFont = this.get(fontName);
                if (font != nextFont) continue;
                return true;
            }
            catch (Exception e) {
            }
        }
        return false;
    }
}

