/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;

public class PDFColorSpaceMap
extends PDFCosDictionaryMap<PDFColorSpace> {
    private PDFColorSpaceMap(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceMap pdfObject = (PDFColorSpaceMap)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceMap.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceMap(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFColorSpace itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFColorSpaceFactory.getInstance(cosObject);
    }

    public static PDFColorSpaceMap newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFColorSpaceMap pdfObject = new PDFColorSpaceMap(cosObject);
        return pdfObject;
    }

    public PDFColorSpace get(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (super.containsKey(name)) {
            return (PDFColorSpace)super.get(name);
        }
        return null;
    }

    public void set(ASName name, PDFColorSpace colorspace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(name, colorspace);
    }
}

