/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCIEBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;

public class PDFColorSpaceCalGray
extends PDFColorSpaceCIEBased {
    private PDFColorSpaceCalGray(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceCalGray getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceCalGray pdfObject = (PDFColorSpaceCalGray)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceCalGray.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceCalGray(cosObject);
        }
        return pdfObject;
    }

    public static PDFColorSpaceCalGray newInstance(PDFDocument pdfDocument, double xw, double zw) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFColorSpaceCalGray pdfObject = new PDFColorSpaceCalGray(cosObject);
        cosObject.addName(0, ASName.k_CalGray);
        CosArray xyzSpaceObj = pdfObject.createCIEWhitePointArray(pdfDocument, xw, zw);
        CosDictionary csDict = pdfDocument.getCosDocument().createDirectCosDictionary();
        csDict.put(PDFColorSpace.k_WhitePoint, xyzSpaceObj);
        cosObject.add(1, csDict);
        return pdfObject;
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public ASName getName() {
        return ASName.k_CalGray;
    }

    @Override
    public ColorSpace createColorSpace() {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    @Override
    public double[] getRange() {
        return PDFColorSpaceDeviceGray.componentsRange;
    }

    @Override
    public double[] getWhitePoint() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return super.getWhitePoint();
    }

    @Override
    public void setWhitePoint(double[] whitePoint) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        super.setWhitePoint(whitePoint);
    }

    @Override
    public double[] getBlackPoint() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return super.getBlackPoint();
    }

    @Override
    public void setBlackPoint(double[] blackPoint) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        super.setBlackPoint(blackPoint);
    }

    public double getGamma() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        Double gamma = this.getDictionary().getCosDictionary().getDouble(ASName.k_Gamma);
        return gamma == null ? 1.0 : gamma;
    }

    public void setGamma(double gamma) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (gamma <= 0.0) {
            throw new PDFInvalidParameterException("gamma should be positive.");
        }
        this.getDictionary().setDictionaryDoubleValue(ASName.k_Gamma, gamma);
    }

    @Override
    public double[] toRGB(double[] gray) {
        gray = super.toRGB(gray);
        try {
            return ColorManager.calGrayToRGB(gray, this.getWhitePoint(), this.getGamma());
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
    }

    @Override
    public double[] getDefaultColor() {
        return PDFColorSpaceDeviceGray.defaultColor;
    }
}

