/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFExtension;
import java.util.HashMap;
import java.util.Map;

public final class PDFVersion {
    private static final int k_0 = 0;
    private static final int k_1 = 1;
    private static final int k_2 = 2;
    private static final int k_3 = 3;
    private static final int k_4 = 4;
    private static final int k_5 = 5;
    private static final int k_6 = 6;
    private static final int k_7 = 7;
    private static final int k_Ext_3 = 3;
    private static final int k_Ext_5 = 5;
    private static final int k_Ext_7 = 7;
    private static final int k_Ext_8 = 8;
    private static final int k_Ext_10 = 10;
    private static final int k_Ext_11 = 11;
    public static final PDFVersion v1_0 = new PDFVersion(1, 0);
    public static final PDFVersion v1_1 = new PDFVersion(1, 1);
    public static final PDFVersion v1_2 = new PDFVersion(1, 2);
    public static final PDFVersion v1_3 = new PDFVersion(1, 3);
    public static final PDFVersion v1_4 = new PDFVersion(1, 4);
    public static final PDFVersion v1_5 = new PDFVersion(1, 5);
    public static final PDFVersion v1_6 = new PDFVersion(1, 6);
    public static final PDFVersion v1_7 = new PDFVersion(1, 7);
    public static final PDFVersion v1_7_e3 = new PDFVersion(1, 7, 3);
    public static final PDFVersion v1_7_e5 = new PDFVersion(1, 7, 5);
    public static final PDFVersion v1_7_e7 = new PDFVersion(1, 7, 7);
    public static final PDFVersion v1_7_e8 = new PDFVersion(1, 7, 8);
    public static final PDFVersion v1_7_e10 = new PDFVersion(1, 7, 10);
    public static final PDFVersion v1_7_e11 = new PDFVersion(1, 7, 11);
    public static final PDFVersion v2_0 = new PDFVersion(2, 0);
    public static final PDFVersion vLatest = v1_7_e10;
    private final int majorversion;
    private final int minorversion;
    private final Map extensions;

    private PDFVersion(String version) {
        String[] thisParts = version.split("\\.");
        this.majorversion = Integer.parseInt(thisParts[0]);
        this.minorversion = Integer.parseInt(thisParts[1]);
        this.extensions = null;
    }

    private PDFVersion(String version, Map extensions) {
        String[] thisParts = version.split("\\.");
        this.majorversion = Integer.parseInt(thisParts[0]);
        this.minorversion = Integer.parseInt(thisParts[1]);
        this.extensions = extensions;
    }

    private PDFVersion() {
        this.majorversion = 1;
        this.minorversion = 0;
        this.extensions = null;
    }

    private PDFVersion(int majorversion, int minorversion) {
        this.majorversion = majorversion;
        this.minorversion = minorversion;
        this.extensions = null;
    }

    private PDFVersion(int majorversion, int minorversion, int adobeExtensionLevel) {
        this.majorversion = majorversion;
        this.minorversion = minorversion;
        this.extensions = new HashMap();
        Map adbeExtension = PDFExtension.asMap(PDFVersion.newInstance(majorversion, minorversion), adobeExtensionLevel);
        this.extensions.put(ASName.k_ADBE, adbeExtension);
    }

    private PDFVersion(int majorversion, int minorversion, Map extensions) {
        this.majorversion = majorversion;
        this.minorversion = minorversion;
        this.extensions = extensions;
    }

    public static PDFVersion newInstance(int majorversion, int minorversion) {
        return new PDFVersion(majorversion, minorversion);
    }

    public static PDFVersion newInstance(int majorversion, int minorversion, int adobeExtension) {
        return new PDFVersion(majorversion, minorversion, adobeExtension);
    }

    public static PDFVersion newInstance(int majorversion, int minorversion, Map extensions) {
        return new PDFVersion(majorversion, minorversion, extensions);
    }

    static PDFVersion getInstance(String version) {
        return new PDFVersion(version);
    }

    static PDFVersion getInstance(String version, Map extensions) {
        return new PDFVersion(version, extensions);
    }

    public static PDFVersion getSupportedInstance(int majorversion, int minorversion) {
        if (majorversion == 1) {
            if (minorversion == 0) {
                return v1_0;
            }
            if (minorversion == 1) {
                return v1_1;
            }
            if (minorversion == 2) {
                return v1_2;
            }
            if (minorversion == 3) {
                return v1_3;
            }
            if (minorversion == 4) {
                return v1_4;
            }
            if (minorversion == 5) {
                return v1_5;
            }
            if (minorversion == 6) {
                return v1_6;
            }
            if (minorversion == 7) {
                return v1_7;
            }
            return null;
        }
        if (majorversion == 2) {
            if (minorversion == 0) {
                return v2_0;
            }
            return null;
        }
        return null;
    }

    public static PDFVersion getSupportedInstance(int majorversion, int minorversion, int adobeExtensionLevel) {
        if (adobeExtensionLevel == 0) {
            if (majorversion == 1) {
                if (minorversion == 0) {
                    return v1_0;
                }
                if (minorversion == 1) {
                    return v1_1;
                }
                if (minorversion == 2) {
                    return v1_2;
                }
                if (minorversion == 3) {
                    return v1_3;
                }
                if (minorversion == 4) {
                    return v1_4;
                }
                if (minorversion == 5) {
                    return v1_5;
                }
                if (minorversion == 6) {
                    return v1_6;
                }
                if (minorversion == 7) {
                    return v1_7;
                }
                return null;
            }
            return null;
        }
        if (majorversion == 1) {
            if (minorversion == 7) {
                if (adobeExtensionLevel == 3) {
                    return v1_7_e3;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static PDFVersion getSupportedInstance(String version) {
        String[] thisParts = version.split("\\.");
        int majorversion = Integer.parseInt(thisParts[0]);
        int minorversion = Integer.parseInt(thisParts[1]);
        return PDFVersion.getSupportedInstance(majorversion, minorversion);
    }

    public String getVersionValue() {
        return this.majorversion + "." + this.minorversion;
    }

    public String toString() {
        return this.majorversion + "." + this.minorversion + (this.extensions == null ? "" : "(Extensions: " + this.extensions + ")");
    }

    public String asString() {
        return this.majorversion + "." + this.minorversion;
    }

    public boolean equalTo(PDFVersion version, ASName name) {
        return this.compareTo(version, name) == 0;
    }

    public boolean equalTo(PDFVersion version) {
        return this.equalTo(version, ASName.k_ADBE);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PDFVersion)) {
            return false;
        }
        return this.equalTo((PDFVersion)object);
    }

    private static int hash(int x) {
        int h = x;
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public int hashCode() {
        int h = PDFVersion.hash(this.getMajorversion());
        h *= 31;
        h ^= PDFVersion.hash(this.getMinorversion());
        h *= 31;
        return h ^= PDFVersion.hash(this.getAdobeExtensionLevel());
    }

    public boolean greaterThan(PDFVersion version, ASName name) {
        return this.compareTo(version, name) > 0;
    }

    public boolean greaterThan(PDFVersion version) {
        return this.greaterThan(version, ASName.k_ADBE);
    }

    public boolean lessThan(PDFVersion version, ASName name) {
        return this.compareTo(version, name) < 0;
    }

    public boolean lessThan(PDFVersion version) {
        return this.lessThan(version, ASName.k_ADBE);
    }

    private int compareTo(PDFVersion version, ASName name) {
        if (version == null) {
            throw new RuntimeException("Cannot compare PDFVersion to a null value.");
        }
        if (version == this) {
            return 0;
        }
        int thisMajVal = this.getMajorversion();
        int thisMinVal = this.getMinorversion();
        int thisExtCal = this.getExtensionLevel(name);
        int versMajVal = version.getMajorversion();
        int versMinVal = version.getMinorversion();
        int versExtVal = version.getExtensionLevel(name);
        if (thisMajVal < versMajVal) {
            return -1;
        }
        if (thisMajVal > versMajVal) {
            return 1;
        }
        if (thisMinVal < versMinVal) {
            return -1;
        }
        if (thisMinVal > versMinVal) {
            return 1;
        }
        if (thisExtCal < versExtVal) {
            return -1;
        }
        if (thisExtCal > versExtVal) {
            return 1;
        }
        return 0;
    }

    public int getMajorversion() {
        return this.majorversion;
    }

    public int getMinorversion() {
        return this.minorversion;
    }

    public int getExtensionLevel(ASName name) {
        Map adobeExtension;
        Object extLevel;
        Object adobeEntry;
        if (this.extensions != null && (adobeEntry = this.extensions.get(name)) instanceof Map && (extLevel = (adobeExtension = (Map)adobeEntry).get(ASName.k_ExtensionLevel)) instanceof Integer) {
            return (Integer)extLevel;
        }
        return 0;
    }

    public int getAdobeExtensionLevel() {
        return this.getExtensionLevel(ASName.k_ADBE);
    }

    public Map getExtensions() {
        return this.extensions;
    }
}

