/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosOpenOptions;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFExtension;
import java.util.HashMap;
import java.util.Map;

public class PDFExtensions
extends PDFCosDictionaryMap<PDFExtension> {
    private PDFExtensions(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFExtensions getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFExtensions pdfObject = (PDFExtensions)PDFCosObject.getCachedInstance(cosObject, PDFExtensions.class);
        if (pdfObject == null) {
            pdfObject = new PDFExtensions(cosObject);
        }
        return pdfObject;
    }

    protected Map asMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashMap<ASName, Map> extensions = null;
        for (ASName key : this.keySet()) {
            if (!(key instanceof ASName)) continue;
            ASName name = key;
            CosObject cosObj = this.getDictionaryCosObjectValue(name);
            if (!(cosObj instanceof CosDictionary)) {
                CosOpenOptions options = this.getPDFDocument().getCosDocument().getOptions();
                if (options.skipCorruptObjects() || !name.asString().equals("Type") || !(cosObj instanceof CosName)) continue;
                if (extensions == null) {
                    extensions = new HashMap();
                }
                extensions.put(name, (Map)((Object)cosObj));
                continue;
            }
            PDFExtension pdfExtension = this.get(name);
            Map extension = pdfExtension.asMap();
            if (extensions == null) {
                extensions = new HashMap<ASName, Map>();
            }
            extensions.put(name, extension);
        }
        return extensions;
    }

    public static PDFExtensions newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        return new PDFExtensions(cosObject);
    }

    public static PDFExtensions newInstance(PDFDocument pdfDocument, ASName name, PDFExtension pdfExtension) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFExtensions pdfObject = PDFExtensions.newInstance(pdfDocument);
        pdfObject.set(name, pdfExtension);
        return pdfObject;
    }

    public static PDFExtensions newInstance(PDFDocument pdfDocument, Map extensions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFExtensions pdfExtensions = PDFExtensions.newInstance(pdfDocument);
        for (Map.Entry entry : extensions.entrySet()) {
            if (!(entry.getKey() instanceof ASName) || !(entry.getValue() instanceof Map)) continue;
            ASName name = (ASName)entry.getKey();
            Map extension = (Map)entry.getValue();
            PDFExtension pdfExtension = PDFExtension.newInstance(pdfDocument, extension);
            if (pdfExtension == null) continue;
            pdfExtensions.set(name, pdfExtension);
        }
        return pdfExtensions;
    }

    public static PDFExtensions newInstanceAdobe(PDFDocument pdfDocument, PDFExtension pdfExtension) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFExtensions pdfObject = PDFExtensions.newInstance(pdfDocument);
        pdfObject.set(ASName.k_ADBE, pdfExtension);
        return pdfObject;
    }

    @Override
    protected PDFExtension itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFExtension.getInstance(cosObject);
    }

    public PDFExtension get(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (super.containsKey(name)) {
            return (PDFExtension)super.get(name);
        }
        return null;
    }

    public void set(ASName name, PDFExtension pdfExtension) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(name, pdfExtension);
    }

    public PDFExtension getAdobeExtension() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.get(ASName.k_ADBE);
    }

    public void setAdobeExtension(PDFExtension pdfExtension) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.set(ASName.k_ADBE, pdfExtension);
    }
}

