/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryptionType;
import java.util.Map;

public class PDFEncryption
extends PDFCosDictionary {
    public static final ASName k_PDRLPol = ASName.create("PDRLPol");

    private PDFEncryption(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFEncryption newInstance(PDFDocument doc, Map<?, ?> encrypt) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFEncryption(PDFCosObject.newCosDictionary(doc, encrypt));
    }

    public static PDFEncryption newInstance(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary encryptDict = PDFCosObject.newCosDictionary(pdfDoc);
        encryptDict.put(ASName.k_Filter, ASName.k_Standard);
        encryptDict.put(ASName.k_V, 1);
        encryptDict.put(ASName.k_R, 2);
        return new PDFEncryption(encryptDict);
    }

    public static PDFEncryption getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFEncryption pdfObject = (PDFEncryption)PDFCosObject.getCachedInstance(cosObject, PDFEncryption.class);
        if (pdfObject == null) {
            pdfObject = new PDFEncryption(cosObject);
        }
        return pdfObject;
    }

    public CosDictionary getEncryption() {
        return (CosDictionary)this.getCosObject();
    }

    public Map<String, Object> getEncryptParameters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (Map)this.getEncryption().getValue();
    }

    public PDFEncryptionType getEncryptionType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_PDRLPol)) {
            return PDFEncryptionType.APS;
        }
        if (this.dictionaryContains(ASName.k_O)) {
            return PDFEncryptionType.Password;
        }
        if (this.dictionaryContains(ASName.k_Recipients)) {
            return PDFEncryptionType.PKI;
        }
        if (this.dictionaryContains(ASName.k_CF)) {
            for (CosDictionary cosDictionary : this.getDictionaryDictionaryValue(ASName.k_CF).values()) {
                if (!cosDictionary.containsKey(ASName.k_Recipients)) continue;
                return PDFEncryptionType.PKI;
            }
        }
        return PDFEncryptionType.Other;
    }
}

