/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFASNameInterface;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import java.util.List;

public abstract class PDFCosDictionary
extends PDFCosObject {
    protected PDFCosDictionary(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
        if (!(cosObject instanceof CosDictionary)) {
            this.removeFromCache(cosObject);
            throw new PDFInvalidDocumentException("CosDictionary expected, found" + cosObject.getClass() + ". Object number of invalid cosObject:" + cosObject.getObjNum());
        }
    }

    public CosDictionary getCosDictionary() {
        if (!(this.getCosObject() instanceof CosDictionary)) {
            return null;
        }
        return (CosDictionary)this.getCosObject();
    }

    public boolean dictionaryContains(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosObject() == null) {
            return false;
        }
        CosObject b = ((CosDictionary)this.getCosObject()).get(key);
        return b != null && !(b instanceof CosNull);
    }

    public boolean isEmpty() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary dict = this.getCosDictionary();
        if (dict == null) {
            return true;
        }
        return dict.isEmpty();
    }

    protected boolean containsKey(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().containsKey(key);
    }

    public boolean removeValue(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosObject() != null && ((CosDictionary)this.getCosObject()).containsKey(name)) {
            CosObject old = this.getCosDictionary().remove(name);
            return old != null;
        }
        return false;
    }

    protected String getDictionaryTextStringValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject value = this.getCosDictionary().get(key);
        if (value == null) {
            return null;
        }
        if (value.getType() != 4) {
            return null;
        }
        PDFText pdfText = PDFText.getInstance(value);
        return pdfText.stringValue();
    }

    public String getDictionaryTextStringOrStreamValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject value = this.getCosDictionary().get(key);
        if (value == null) {
            return null;
        }
        PDFText pdfText = PDFText.getInstance(value);
        return pdfText.stringValue();
    }

    protected ASDate getDictionaryDateValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject dateValue = this.getCosDictionary().get(key);
        if (dateValue == null) {
            return null;
        }
        if (dateValue instanceof CosString) {
            return ((CosString)dateValue).asDate();
        }
        throw new PDFInvalidDocumentException(this.getErrorMessage("CosString", dateValue, key));
    }

    private String getErrorMessage(String expectedType, CosObject invalidObject, ASName key) {
        if (invalidObject != null) {
            return expectedType + " expected, found " + invalidObject.getClass() + " , invalid obj number: " + invalidObject.getObjNum() + ", dict key: " + key;
        }
        return expectedType + " expected, found Null, dict key: " + key;
    }

    public ASName getDictionaryNameValue(PDFASNameInterface key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(key.getName());
    }

    public ASName getDictionaryNameValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject nameValue = this.getCosDictionary().get(key);
        if (nameValue == null) {
            return null;
        }
        if (nameValue instanceof CosName) {
            return ((CosName)nameValue).nameValue();
        }
        throw new PDFInvalidDocumentException(this.getErrorMessage("CosName", nameValue, key));
    }

    public String getDictionaryNameValueAsString(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName nameValue = this.getDictionaryNameValue(key);
        if (nameValue == null) {
            return null;
        }
        return nameValue.asString(true);
    }

    public Integer getDictionaryIntValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject value = this.getCosDictionary().get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException(this.getErrorMessage("CosNumeric", value, key));
        }
        return value.intValue();
    }

    public byte[] getDictionaryByteArrayValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject stringVal = this.getCosDictionary().get(key);
        if (stringVal == null) {
            return null;
        }
        if (stringVal instanceof CosString) {
            return ((CosString)stringVal).byteArrayValue();
        }
        throw new PDFInvalidDocumentException(this.getErrorMessage("CosString", stringVal, key));
    }

    public ASString getDictionaryStringValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject stringVal = this.getCosDictionary().get(key);
        if (stringVal == null) {
            return null;
        }
        if (stringVal instanceof CosString) {
            return ((CosString)stringVal).stringValue();
        }
        throw new PDFInvalidDocumentException(this.getErrorMessage("CosString", stringVal, key));
    }

    public String getDictionaryIntValueAsString(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number value = this.getDictionaryNumericValue(key);
        if (value == null) {
            return null;
        }
        return Integer.toString(value.intValue());
    }

    public double getDictionaryDoubleValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number value = this.getDictionaryNumericValue(key);
        if (value == null) {
            throw new PDFInvalidDocumentException(this.getErrorMessage("CosNumeric", null, key));
        }
        return value.doubleValue();
    }

    public boolean getDictionaryBooleanValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject booleanVal = this.getCosDictionary().get(key);
        if (booleanVal == null) {
            throw new PDFInvalidDocumentException(this.getErrorMessage("CosBoolean", null, key));
        }
        return booleanVal.booleanValue();
    }

    public String getDictionaryDoubleValueAsString(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number value = this.getDictionaryNumericValue(key);
        if (value == null) {
            return null;
        }
        return Double.toString(value.doubleValue());
    }

    public CosDictionary getDictionaryDictionaryValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject dictObject = this.getCosDictionary().get(key);
        if (dictObject instanceof CosDictionary) {
            return (CosDictionary)dictObject;
        }
        return null;
    }

    public Number getDictionaryNumericValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject value = this.getCosDictionary().get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof CosNumeric) {
            return ((CosNumeric)value).numberValue();
        }
        throw new PDFInvalidDocumentException(this.getErrorMessage("CosNumeric", value, key));
    }

    public InputByteStream getDictionaryStreamValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject streamVal = this.getCosDictionary().get(key);
        if (streamVal == null) {
            return null;
        }
        if (streamVal instanceof CosStream) {
            return ((CosStream)streamVal).getStreamDecoded();
        }
        throw new PDFInvalidDocumentException(this.getErrorMessage("CosStream", streamVal, key));
    }

    public CosObject getDictionaryCosObjectValue(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosObject() == null) {
            return null;
        }
        return ((CosDictionary)this.getCosObject()).get(name);
    }

    public CosArray getDictionaryArrayValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject arrObj = this.getCosDictionary().get(key);
        if (arrObj == null) {
            return null;
        }
        if (arrObj instanceof CosArray) {
            return (CosArray)arrObj;
        }
        throw new PDFInvalidDocumentException(this.getErrorMessage("CosArray", arrObj, key));
    }

    public void setDictionaryDateValue(ASName key, ASDate date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(key, date == null ? null : date.asString());
    }

    public void setDictionaryStringValue(ASName key, String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(key, value == null ? null : PDFText.createString(this.getPDFDocument(), value).getCosObject());
    }

    public void setDictionaryStringValue(ASName key, String value, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(key, value == null ? null : PDFText.createString(this.getPDFDocument(), value, unicode).getCosObject());
    }

    public void setDictionaryByteArrayValue(ASName key, byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(key, value == null ? null : PDFCosObject.newCosString(this.getPDFDocument(), value));
    }

    public void setDictionaryASStringValue(ASName key, ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(key, value == null ? null : PDFCosObject.newCosString(this.getPDFDocument(), value.getBytes()));
    }

    public void setDictionaryStringOrStreamValue(ASName key, String value) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryValue(key, value == null ? null : PDFText.newInstance(this.getPDFDocument(), value));
    }

    public void setDictionaryStringOrStreamValue(ASName key, String value, boolean utf16) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryValue(key, value == null ? null : PDFText.newInstance(value, utf16, this.getPDFDocument()));
    }

    public void setDictionaryTextValue(ASName key, PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(key, value);
    }

    public void setDictionaryNameValue(ASName key, PDFASNameInterface value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(key, value == null ? null : value.getName());
    }

    public void setDictionaryNameValue(ASName key, ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.getCosDictionary().remove(key);
        } else {
            this.getCosDictionary().put(key, value);
        }
    }

    public void setDictionaryNameValue(ASName key, String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(key, ASName.create(value));
    }

    public void setDictionaryIntValue(ASName key, long value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(key, value);
    }

    public void setDictionaryArrayValue(ASName key, long[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.getCosDictionary().remove(key);
        } else {
            this.getCosDictionary().put(key, value);
        }
    }

    public void setDictionaryIntValue(ASName key, String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            this.putValueInDictionary(key, value == null ? null : this.getCosDictionary().getDocument().createCosNumeric(Integer.parseInt(value)));
        }
        catch (NumberFormatException e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setDictionaryDoubleValue(ASName key, double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(key, value);
    }

    public void setDictionaryDoubleValue(ASName key, String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            this.getCosDictionary().put(key, Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setDictionaryBooleanValue(ASName key, Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.getCosDictionary().remove(key);
        } else {
            this.getCosDictionary().put(key, value);
        }
    }

    public void setDictionaryBooleanValue(ASName key, String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value != null) {
            this.getCosDictionary().put(key, "true".equals(value));
        } else {
            this.getCosDictionary().remove(key);
        }
    }

    public void setDictionaryArrayValue(ASName key, List<? extends Object> value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(key, value == null ? null : PDFCosDictionary.makeCosArray(this.getPDFDocument(), value));
    }

    protected void setDictionaryArrayValue(ASName key, int[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(key, value == null ? null : PDFCosDictionary.makeCosArray(this.getPDFDocument(), value, 0, value.length - 1));
    }

    public CosArray setDictionaryArrayValue(ASName key, double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.setDictionaryArrayValue(key, 0, value);
    }

    protected CosArray setDictionaryArrayValue(ASName key, int offset, double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray valueArray = null;
        this.setDictionaryArrayValue(key, value == null ? null : (valueArray = PDFCosDictionary.makeCosArray(this.getPDFDocument(), offset, value, 0, value.length - 1)));
        return valueArray;
    }

    private void putValueInDictionary(ASName key, CosObject value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.getCosDictionary().remove(key);
        } else {
            this.getCosDictionary().put(key, value);
        }
    }

    public void setDictionaryArrayValue(ASName key, CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.putValueInDictionary(key, value);
    }

    public void setDictionaryStreamValue(ASName key, CosStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.putValueInDictionary(key, value);
    }

    public void setDictionaryValue(ASName key, CosObject value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.putValueInDictionary(key, value);
    }

    public void setDictionaryValue(ASName key, PDFCosObject value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.putValueInDictionary(key, value == null ? null : value.getCosObject());
    }

    public CosObject getDictionaryValue(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject value = null;
        value = this.getCosDictionary().get(key);
        return value;
    }

    public PDFMetadata getMetadata() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMetadata.getInstance(this.getDictionaryCosObjectValue(ASName.k_Metadata));
    }

    public void setMetadata(PDFMetadata pdfMetadata) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Metadata, pdfMetadata);
    }

    boolean hasXMP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Metadata);
    }

    protected CosArray setDictionaryArrayValue(ASName key, int offset, ASName[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray valueArray = null;
        this.setDictionaryArrayValue(key, value == null ? null : (valueArray = PDFCosDictionary.makeCosArray(this.getPDFDocument(), offset, value, 0, value.length - 1)));
        return valueArray;
    }
}

