/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStreamList;

public class PDFValidationRelatedInfo
extends PDFCosDictionary {
    public static final ASName k_CRL = ASName.create("CRL");
    public static final ASName k_OCSP = ASName.create("OCSP");
    public static final ASName k_TU = ASName.create("TU");
    public static final ASName k_TS = ASName.create("TS");

    private PDFValidationRelatedInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    protected static PDFValidationRelatedInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFValidationRelatedInfo pdfObject = (PDFValidationRelatedInfo)PDFCosObject.getCachedInstance(cosObject, PDFValidationRelatedInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFValidationRelatedInfo(cosObject);
        }
        return pdfObject;
    }

    public static PDFValidationRelatedInfo newInstance(PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(doc);
        PDFValidationRelatedInfo pdfObject = new PDFValidationRelatedInfo(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.create("VRI"));
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public PDFStreamList getCRLs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_CRL);
        if (cosArray != null) {
            return PDFStreamList.getInstance(cosArray);
        }
        return null;
    }

    public void setCRLs(PDFStreamList crls) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (crls == null) {
            this.removeValue(k_CRL);
        } else {
            this.setDictionaryArrayValue(k_CRL, crls.getCosArray());
        }
    }

    public PDFStreamList getOCSPs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStreamList.getInstance(this.getDictionaryArrayValue(k_OCSP));
    }

    public void setOCSPs(PDFStreamList ocsps) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (ocsps == null) {
            this.removeValue(k_OCSP);
        } else {
            this.setDictionaryArrayValue(k_OCSP, ocsps.getCosArray());
        }
    }

    public ASDate getUnsecureTime() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(k_TU);
    }

    public void setUnsecureTime(ASDate date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (date != null) {
            this.setDictionaryDateValue(k_TU, date);
            this.removeValue(k_TS);
        } else {
            this.removeValue(k_TU);
        }
    }

    public PDFStream getTimeStamp() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStream.getInstance(this.getCosDictionary().get(k_TS));
    }

    public void setTimeStamp(PDFStream timeStamp) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (timeStamp != null) {
            this.setDictionaryStreamValue(k_TS, timeStamp.getCosStream());
            this.removeValue(k_TU);
        } else {
            this.removeValue(k_TS);
        }
    }
}

