/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReference;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReferenceList;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersUB1;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersUR;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;

public class PDFSignatureUtils {
    public static boolean hasUsageRights(PDFDocument pdfDoc, String transformMethod) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (transformMethod.equals(PDFSignature.k_UB1.asString(true))) {
            return PDFSignatureUtils.hasUB1Rights(pdfDoc);
        }
        PDFPermissions perms = pdfDoc.requireCatalog().getPermissions();
        if (perms != null) {
            if (perms.getUR() != null && transformMethod.equals(PDFSignature.k_UR.asString(true))) {
                return true;
            }
            if (perms.getUR3() != null && transformMethod.equals(PDFSignature.k_UR3.asString(true))) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasUB1Rights(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary rightsDict;
        CosDictionary viewerPrefs = pdfDoc.requireCatalog().getDictionaryDictionaryValue(ASName.k_ViewerPreferences);
        return viewerPrefs != null && (rightsDict = viewerPrefs.getCosDictionary(ASName.k_Rights)) != null;
    }

    public static PDFTransformParametersUR getDocumentUsageRights(PDFDocument pdfDoc, String transformMethod) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFTransformParametersUR urParams = null;
        if (PDFSignatureUtils.hasUsageRights(pdfDoc)) {
            if (PDFSignatureUtils.hasUB1Rights(pdfDoc) && transformMethod.equals(PDFSignature.k_UB1.asString(true))) {
                return PDFSignatureUtils.getUB1Rights(pdfDoc);
            }
            PDFPermissions perms = pdfDoc.requireCatalog().getPermissions();
            if (perms != null) {
                PDFSignature signature = perms.getUR();
                if (signature != null && transformMethod.equals(PDFSignature.k_UR.asString(true))) {
                    return PDFSignatureUtils.getPDFTransformParametersUR(pdfDoc, signature);
                }
                signature = perms.getUR3();
                if (signature != null && transformMethod.equals(PDFSignature.k_UR3.asString(true))) {
                    return PDFSignatureUtils.getPDFTransformParametersUR(pdfDoc, signature);
                }
            }
        }
        return urParams;
    }

    public static PDFTransformParametersUR getPDFTransformParametersUR(PDFDocument pdfDoc, PDFSignature signature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (signature == null) {
            return null;
        }
        PDFSignatureReferenceList sigRefList = signature.getSignatureReferences();
        if (sigRefList == null) {
            return null;
        }
        for (PDFSignatureReference sigRef : sigRefList) {
            if (sigRef == null || sigRef.getTransformMethodName() != PDFSignature.k_UR && sigRef.getTransformMethodName() != PDFSignature.k_UR3) continue;
            return (PDFTransformParametersUR)sigRef.getPDFTransformParameters();
        }
        return null;
    }

    public static PDFTransformParametersUB1 getUB1Rights(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary rightsDict;
        CosDictionary viewerPrefs = pdfDoc.requireCatalog().getDictionaryDictionaryValue(ASName.k_ViewerPreferences);
        if (viewerPrefs != null && (rightsDict = viewerPrefs.getCosDictionary(ASName.k_Rights)) != null) {
            return PDFTransformParametersUB1.getInstance(rightsDict);
        }
        return null;
    }

    public static boolean hasPermissionsSignature(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPermissions perms = pdfDoc.requireCatalog().getPermissions();
        return perms != null ? perms.getDocMDP() != null || perms.getUR() != null || perms.getUR3() != null : false;
    }

    public static boolean hasUsageRights(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFSignatureUtils.hasUB1Rights(pdfDoc)) {
            return true;
        }
        PDFPermissions perms = pdfDoc.requireCatalog().getPermissions();
        return perms != null ? perms.getUR() != null || perms.getUR3() != null : false;
    }
}

